/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import android.util.AttributeSet;
import android.util.Log;
import java.util.UUID;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;
import org.liquidplayer.node.NodeProcessService;
import org.liquidplayer.node.Process;
import org.liquidplayer.widget.ConsoleView;

public class NodeConsoleView
extends ConsoleView
implements Process.EventListener,
JSContext.IJSExceptionHandler {
    private Process process = null;
    private JSContext js = null;
    private JSFunction console_log = null;
    private boolean processedException = false;
    private int columns = 0;
    private int rows = 0;
    private Listener listener;

    public NodeConsoleView(Context context) {
        this(context, null);
    }

    public NodeConsoleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NodeConsoleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void updateState() {
        super.updateState();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        if (this.state().getString("uuid") == null) {
            String uuid = UUID.randomUUID().toString();
            this.state().putString("uuid", uuid);
        }
        this.resize(this.columns, this.rows);
    }

    @Override
    public void reset() {
        if (this.process != null) {
            this.process.removeEventListener(this);
            this.process = null;
        }
        super.reset();
    }

    @Override
    protected void resize(int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
        if (this.state().getString("uuid") != null) {
            Context context = this.getContext();
            LocalBroadcastManager.getInstance((Context)context).registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NodeConsoleView.this.process = NodeProcessService.getProcess(NodeConsoleView.this.state().getString("uuid"));
                    NodeConsoleView.this.process.addEventListener(NodeConsoleView.this);
                    LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)this);
                }
            }, new IntentFilter(this.state().getString("uuid")));
            Intent serviceIntent = new Intent(context, NodeProcessService.class);
            serviceIntent.putExtra("org.liquidplayer.node.Process", this.state().getString("uuid"));
            context.startService(serviceIntent);
        }
    }

    @Override
    protected void processCommand(final String cmd) {
        this.processedException = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                JSValue output = NodeConsoleView.this.js.evaluateScript(cmd);
                if (!NodeConsoleView.this.processedException && NodeConsoleView.this.console_log != null) {
                    NodeConsoleView.this.console_log.call(null, output);
                }
            }
        }).start();
    }

    private void setupStream(JSObject stream, final StreamCallback callback) {
        stream.property("write", new JSFunction(stream.getContext(), "write"){

            public void write(String string) {
                callback.callback(string);
            }
        });
        stream.property("clearScreenDown", new JSFunction(stream.getContext(), "clearScreenDown", "this.write('\\x1b[0J');", new String[0]));
        stream.property("moveCursor", new JSFunction(stream.getContext(), "moveCursor", "var out = ''; c = c || 0; r = r || 0;if (c>0) out += '\\x1b['+c+'C'; else if (c<0) out+='\\x1b['+(-c)+'D';if (r>0) out += '\\x1b['+r+'B'; else if (r<0) out+='\\x1b['+(-r)+'A';this.write(out);", "c", "r"));
        stream.property("rows", this.rows);
        stream.property("columns", this.columns);
    }

    @Override
    public void onProcessStart(Process process, JSContext context) {
        this.js = context;
        this.js.setExceptionHandler(this);
        this.console_log = this.js.property("console").toObject().property("log").toFunction();
        process.keepAlive();
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                NodeConsoleView.this.inputBox.setEnabled(true);
            }
        });
        JSObject stdout = this.js.property("process").toObject().property("stdout").toObject();
        JSObject stderr = this.js.property("process").toObject().property("stderr").toObject();
        this.setupStream(stdout, new StreamCallback(){

            @Override
            public void callback(String string) {
                NodeConsoleView.this.consoleTextView.print(string);
            }
        });
        this.setupStream(stderr, new StreamCallback(){

            @Override
            public void callback(String string) {
                string = "\u001b[31m" + string;
                NodeConsoleView.this.consoleTextView.print(string);
                Log.e((String)"stderr", (String)string);
            }
        });
        if (this.listener != null) {
            this.listener.onJSReady(context);
        }
    }

    @Override
    public void onProcessAboutToExit(Process process, int exitCode) {
        JSObject stdout = this.js.property("process").toObject().property("stdout").toObject();
        JSObject stderr = this.js.property("process").toObject().property("stderr").toObject();
        JSFunction writenull = new JSFunction(this.js, "_writenull", "", new String[0]);
        stdout.property("write", writenull);
        stderr.property("write", writenull);
        this.js.property("process").toObject().deleteProperty("clearScreenDown");
        this.js.property("process").toObject().deleteProperty("moveCursor");
        this.console_log = null;
        this.js = null;
        process.letDie();
        this.process = null;
        this.consoleTextView.println("\u001b[31mProcess about to exit with code " + exitCode);
        Log.e((String)"onProcessAboutToExit", (String)("Process about to exit with code " + exitCode));
        process.removeEventListener(this);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)"looper", (String)"setting stuff");
                NodeConsoleView.this.inputBox.setEnabled(false);
                NodeConsoleView.this.inputBox.setClickable(false);
                NodeConsoleView.this.inputBox.setAlpha(0.5f);
                NodeConsoleView.this.setButtonEnabled(NodeConsoleView.this.downHistory, false);
                NodeConsoleView.this.setButtonEnabled(NodeConsoleView.this.upHistory, false);
                Log.d((String)"looper", (String)"done setting stuff");
            }
        });
    }

    @Override
    public void onProcessExit(Process process, int exitCode) {
        Log.d((String)"onProcessExit", (String)"exiting");
        this.consoleTextView.println("\u001b[31mProcess exited with code " + exitCode);
        this.process = null;
    }

    @Override
    public void onProcessFailed(Process process, Exception error) {
    }

    @Override
    public void handle(JSException e) {
        this.processedException = true;
        this.consoleTextView.println("\u001b[31m" + e.stack());
    }

    private static interface StreamCallback {
        public void callback(String var1);
    }

    public static interface Listener {
        public void onJSReady(JSContext var1);
    }
}

