/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.widget;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.widget.NestedScrollView;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import org.liquidplayer.node.R;
import org.liquidplayer.widget.AnsiConsoleTextView;

class ConsoleView
extends RelativeLayout
implements AnsiConsoleTextView.Listener {
    protected EditText inputBox;
    protected NestedScrollView scrollView;
    protected ImageButton upHistory;
    protected ImageButton downHistory;
    protected AnsiConsoleTextView consoleTextView;
    private static SparseArray<Bundle> stateBundle = new SparseArray();
    private Bundle __bundle = null;
    private TextView.OnEditorActionListener onEditorAction = new TextView.OnEditorActionListener(){

        public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
            if (actionId == 6) {
                ConsoleView.this.enterCommand();
                return true;
            }
            return false;
        }
    };
    private View.OnKeyListener onKeyListener = new View.OnKeyListener(){

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (event.getAction() == 0 && keyCode == 66) {
                ConsoleView.this.enterCommand();
                return true;
            }
            if (event.getAction() == 0 && keyCode == 19) {
                ConsoleView.this.upHistory();
                return true;
            }
            if (event.getAction() == 0 && keyCode == 20) {
                ConsoleView.this.downHistory();
                return true;
            }
            return false;
        }
    };
    private View.OnClickListener onUpClick = new View.OnClickListener(){

        public void onClick(View view) {
            ConsoleView.this.upHistory();
        }
    };
    private View.OnClickListener onDownClick = new View.OnClickListener(){

        public void onClick(View view) {
            ConsoleView.this.downHistory();
        }
    };
    private ViewTreeObserver.OnGlobalLayoutListener onLayout = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            ConsoleView.this.scrollView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            TextPaint textPaint = ConsoleView.this.consoleTextView.getPaint();
            int width = Math.round(textPaint.measureText("X") * ConsoleView.this.consoleTextView.getTextScaleX());
            int height = Math.round(textPaint.getTextSize() * ConsoleView.this.consoleTextView.getTextScaleX());
            int rows = ConsoleView.this.scrollView.getMeasuredHeight() / height;
            int columns = ConsoleView.this.scrollView.getMeasuredWidth() / width;
            ConsoleView.this.resize(columns, rows);
        }
    };
    private Runnable scrollToBottom = new Runnable(){

        @Override
        public void run() {
            ConsoleView.this.onDisplayUpdated();
        }
    };
    private Handler uiThread = new Handler(Looper.getMainLooper());

    public ConsoleView(Context context) {
        this(context, null);
    }

    public ConsoleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ConsoleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater.from((Context)context).inflate(R.layout.console_view, (ViewGroup)this);
        this.loadViews();
    }

    protected void resize(int columns, int rows) {
    }

    protected void processCommand(String command) {
    }

    protected Bundle state() {
        if (this.__bundle != null) {
            return this.__bundle;
        }
        if (this.getId() != -1) {
            this.__bundle = (Bundle)stateBundle.get(this.getId());
            if (this.__bundle == null) {
                Log.d((String)"state()", (String)("creating new bundle for " + this.getId()));
                this.__bundle = new Bundle();
                stateBundle.append(this.getId(), (Object)this.__bundle);
            }
        } else {
            Log.d((String)"state()", (String)"we ain't got no id");
            this.__bundle = new Bundle();
        }
        return this.__bundle;
    }

    private void setInputBoxText(final CharSequence text) {
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                ConsoleView.this.inputBox.setText(text);
            }
        });
        this.state().putCharSequence("inputBox", text);
    }

    private int getItem() {
        return this.state().getInt("item", 0);
    }

    private void setItem(int item) {
        this.state().putInt("item", item);
    }

    private ArrayList<String> history() {
        ArrayList history = this.state().getStringArrayList("history");
        if (history == null) {
            history = new ArrayList();
            this.state().putStringArrayList("history", history);
        }
        return history;
    }

    public void reset() {
        if (this.getId() != -1) {
            stateBundle.remove(this.getId());
        }
        this.__bundle = null;
        this.updateState();
    }

    private void loadViews() {
        Log.d((String)"foo", (String)"loadViews");
        this.inputBox = (EditText)this.findViewById(R.id.inputBox);
        this.scrollView = (NestedScrollView)this.findViewById(R.id.scroll);
        this.inputBox.setFocusableInTouchMode(true);
        this.inputBox.requestFocus();
        this.inputBox.setOnEditorActionListener(this.onEditorAction);
        this.inputBox.setOnKeyListener(this.onKeyListener);
        this.inputBox.setEnabled(false);
        this.upHistory = (ImageButton)this.findViewById(R.id.up_history);
        this.downHistory = (ImageButton)this.findViewById(R.id.down_history);
        this.upHistory.setOnClickListener(this.onUpClick);
        this.downHistory.setOnClickListener(this.onDownClick);
        this.setButtonEnabled(this.upHistory, false);
        this.setButtonEnabled(this.downHistory, false);
        ViewTreeObserver vto = this.scrollView.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(this.onLayout);
        this.consoleTextView = (AnsiConsoleTextView)this.findViewById(R.id.console_text);
        this.consoleTextView.addListener(this);
        this.updateState();
        this.uiThread.post(this.scrollToBottom);
    }

    protected void updateState() {
        CharSequence text = this.state().getCharSequence("inputBox", (CharSequence)"");
        if (text != null) {
            this.setInputBoxText(text);
        }
        if ((text = this.state().getCharSequence("textView", (CharSequence)"")) != null) {
            this.consoleTextView.setText(text);
        }
    }

    public void setId(int id2) {
        super.setId(id2);
        Log.d((String)"setId", (String)("Setting id " + id2));
        this.__bundle = null;
        this.updateState();
    }

    @Override
    public void onDisplayUpdated() {
        View lastChild = this.scrollView.getChildAt(this.scrollView.getChildCount() - 1);
        int bottom = lastChild.getBottom() + this.scrollView.getPaddingBottom();
        int sy = this.scrollView.getScrollY();
        int sh = this.scrollView.getHeight();
        int delta = bottom - (sy + sh);
        this.scrollView.smoothScrollBy(0, delta);
        this.state().putCharSequence("textView", this.consoleTextView.getText());
    }

    protected void setButtonEnabled(ImageButton button, boolean enable) {
        button.setEnabled(enable);
        button.setAlpha(enable ? 1.0f : 0.5f);
        button.setClickable(enable);
    }

    private void upHistory() {
        if (this.upHistory.isEnabled()) {
            int item = this.getItem() - 1;
            this.setItem(item);
            this.setInputBoxText(this.history().get(item));
            if (item == 0) {
                this.setButtonEnabled(this.upHistory, false);
            }
            this.setButtonEnabled(this.downHistory, true);
            this.inputBox.setSelection(this.inputBox.getText().length());
        }
    }

    private void downHistory() {
        if (this.downHistory.isEnabled()) {
            int item = this.getItem() + 1;
            this.setItem(item);
            if (item >= this.history().size()) {
                this.setButtonEnabled(this.downHistory, false);
                this.setInputBoxText("");
            } else {
                this.setInputBoxText(this.history().get(item));
            }
            this.setButtonEnabled(this.upHistory, true);
            this.inputBox.setSelection(this.inputBox.getText().length());
        }
    }

    private void enterCommand() {
        String cmd = this.inputBox.getText().toString();
        this.consoleTextView.println("\u001b[30;1m> " + cmd);
        this.setInputBoxText("");
        this.history().add(cmd);
        this.setItem(this.history().size());
        this.setButtonEnabled(this.upHistory, true);
        this.setButtonEnabled(this.downHistory, false);
        this.processCommand(cmd);
    }
}

