/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;

public class Process {
    public static final int kContextFinalizedButProcessStillActive = -222;
    public static final int kMediaAccessPermissionsNone = 0;
    public static final int kMediaAccessPermissionsRead = 1;
    public static final int kMediaAccessPermissionsWrite = 2;
    public static final int kMediaAccessPermissionsRW = 3;
    private boolean notifiedExit = false;
    private long exitCode;
    protected WeakReference<ProcessContext> jscontext = null;
    private boolean isActive = false;
    private boolean isDone = false;
    private FileSystem fs = null;
    private ArrayList<EventListener> listeners = new ArrayList();
    private final long processRef;
    private final String uniqueID;
    private final Context androidCtx;
    private final int mediaAccessMask;

    public Process(Context androidContext, String uniqueID, int mediaAccessMask, EventListener listener) {
        this.addEventListener(listener);
        this.processRef = this.start();
        this.androidCtx = androidContext;
        this.uniqueID = uniqueID;
        this.mediaAccessMask = mediaAccessMask;
    }

    public synchronized void addEventListener(final EventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).async(new Runnable(){

                @Override
                public void run() {
                    if (Process.this.isActive()) {
                        listener.onProcessStart(Process.this, (JSContext)Process.this.jscontext.get());
                    } else {
                        listener.onProcessExit(Process.this, Long.valueOf(Process.this.exitCode).intValue());
                    }
                }
            });
        } else if (this.isDone) {
            listener.onProcessExit(this, Long.valueOf(this.exitCode).intValue());
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        Log.d((String)"removeEventListener", (String)("There were " + this.listeners.size() + " listeners"));
        this.listeners.remove(listener);
        Log.d((String)"removeEventListener", (String)("There are now " + this.listeners.size() + " listeners"));
    }

    public boolean isActive() {
        return this.isActive && this.jscontext.get() != null;
    }

    public void exit(final int exitc) {
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).async(new Runnable(){

                @Override
                public void run() {
                    if (Process.this.isActive()) {
                        ((ProcessContext)Process.this.jscontext.get()).evaluateScript("process.exit(" + exitc + ");");
                    }
                }
            });
        }
    }

    public void keepAlive() {
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).keepAlive();
        }
    }

    public void letDie() {
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).letDie();
        }
    }

    private synchronized void eventOnStart(JSContext ctx) {
        for (EventListener listener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            listener.onProcessStart(this, ctx);
        }
    }

    private synchronized void eventOnAboutToExit(long code) {
        this.exitCode = code;
        for (EventListener listener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            listener.onProcessAboutToExit(this, Long.valueOf(code).intValue());
        }
    }

    private void eventOnExit(long code) {
        this.exitCode = code;
        if (!this.notifiedExit) {
            this.notifiedExit = true;
            for (EventListener listener : this.listeners) {
                listener.onProcessExit(this, Long.valueOf(code).intValue());
            }
            if (this.fs != null) {
                this.fs.cleanUp();
            }
            this.fs = null;
        }
    }

    private void onNodeStarted(final long mainContext, long ctxGroupRef) {
        final ProcessContext ctx = new ProcessContext(mainContext, new JSContextGroup(ctxGroupRef));
        this.jscontext = new WeakReference<ProcessContext>(ctx);
        this.isActive = true;
        ctx.property("__nodedroid_onLoad", new JSFunction(ctx, "__nodedroid_onLoad"){

            public void __nodedroid_onLoad() {
                if (Process.this.isActive()) {
                    ((ProcessContext)Process.this.jscontext.get()).deleteProperty("__nodedroid_onLoad");
                    Process.this.fs = new FileSystem(ctx, Process.this.mediaAccessMask);
                    Process.this.setFileSystem(mainContext, Process.this.fs.valueRef());
                    JSFunction onExit = new JSFunction(this.context, "onExit"){

                        public void onExit(int code) {
                            Process.this.eventOnAboutToExit(code);
                        }
                    };
                    new JSFunction(this.context, "__onExit", new String[]{"exitFunc"}, "process.on('exit',exitFunc);process.chdir('/home');", null, 0).call(null, onExit);
                    JSObject stdout = ctx.property("process").toObject().property("stdout").toObject();
                    stdout.property("write", new JSFunction(stdout.getContext(), "write"){

                        public void write(String string) {
                            Log.i((String)"stdout", (String)string);
                        }
                    });
                    JSObject stderr = ctx.property("process").toObject().property("stderr").toObject();
                    stderr.property("write", new JSFunction(stderr.getContext(), "write"){

                        public void write(String string) {
                            Log.e((String)"stderr", (String)string);
                        }
                    });
                    Process.this.eventOnStart((JSContext)Process.this.jscontext.get());
                }
            }
        });
    }

    private void onNodeExit(long exitCode) {
        ProcessContext ctx;
        this.isActive = false;
        if (this.jscontext != null && this.jscontext.get() != null && (ctx = (ProcessContext)this.jscontext.get()) != null) {
            ctx.setDefunct();
        }
        this.jscontext = null;
        this.isDone = true;
        this.eventOnExit(exitCode);
        new Thread(){

            @Override
            public void run() {
                Process.this.dispose(Process.this.processRef);
            }
        }.start();
    }

    private native long start();

    private native void dispose(long var1);

    private native long keepAlive(long var1);

    private native void letDie(long var1);

    private native long setFileSystem(long var1, long var3);

    static {
        JSContext.dummy();
    }

    private class FileSystem
    extends JSObject {
        @JSObject.jsexport(attributes=2)
        private JSObject.Property<JSObject> access_;
        @JSObject.jsexport(attributes=2)
        private JSObject.Property<JSObject> aliases_;
        @JSObject.jsexport(attributes=2)
        private JSObject.Property<JSFunction> fs;
        @JSObject.jsexport(attributes=2)
        private JSObject.Property<JSFunction> alias;
        private List<String> toclean;

        private String realDir(String dir) {
            return this.getContext().evaluateScript("(function(){return require('fs').realpathSync('" + dir + "');})()").toString();
        }

        private String mkdir(String dir) {
            new File(dir).mkdirs();
            return this.realDir(dir);
        }

        private void symlink(String target, String linkpath) {
            this.getContext().evaluateScript("(function(){require('fs').symlinkSync('" + target + "','" + linkpath + "');})()");
        }

        private boolean isSymlink(File file) {
            try {
                return file.getCanonicalFile().equals(file.getAbsoluteFile());
            }
            catch (IOException e) {
                return true;
            }
        }

        private void deleteRecursive(File fileOrDirectory) {
            if (fileOrDirectory.isDirectory() && !this.isSymlink(fileOrDirectory)) {
                for (File child : fileOrDirectory.listFiles()) {
                    this.deleteRecursive(child);
                }
            }
            if (!fileOrDirectory.delete()) {
                Log.d((String)"nodedroid", (String)"Failed to delete directory");
            }
        }

        private void setUp() {
            String suffix = "/__org.liquidplayer.node__/_" + Process.this.uniqueID;
            String random = "" + UUID.randomUUID();
            String sessionSuffix = suffix + "/" + random;
            String home = this.mkdir(Process.this.androidCtx.getFilesDir().getAbsolutePath() + sessionSuffix + "/home");
            this.toclean.add(home);
            this.aliases_.get().property("/home", home);
            this.access_.get().property("/home", 3);
            String cache = this.mkdir(Process.this.androidCtx.getCacheDir().getAbsolutePath() + sessionSuffix + "/cache");
            this.toclean.add(cache);
            this.symlink(cache, home + "/cache");
            this.aliases_.get().property("/home/cache", cache);
            String persistent = this.mkdir(Process.this.androidCtx.getFilesDir().getAbsolutePath() + suffix + "/persistent");
            this.symlink(persistent, home + "/persistent");
            this.aliases_.get().property("/home/persistent", persistent);
            new File(home + "/external").mkdirs();
            if (Process.this.androidCtx.getExternalCacheDir() != null) {
                String externalCache = this.mkdir(Process.this.androidCtx.getExternalCacheDir().getAbsolutePath() + sessionSuffix + "/cache");
                this.symlink(externalCache, home + "/external/cache");
                this.toclean.add(externalCache);
                this.aliases_.get().property("/home/external/cache", externalCache);
            } else {
                Log.d((String)"setUp", (String)"No external cache dir");
            }
            File external = Process.this.androidCtx.getExternalFilesDir(null);
            if (external != null) {
                String externalPersistent = this.mkdir(external.getAbsolutePath() + "/LiquidPlayer/" + Process.this.uniqueID);
                this.symlink(externalPersistent, home + "/external/persistent");
                this.aliases_.get().property("/home/external/persistent", externalPersistent);
            }
            external = Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_DCIM);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_MUSIC);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_NOTIFICATIONS);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_PODCASTS);
            Process.this.androidCtx.getExternalFilesDir(Environment.DIRECTORY_RINGTONES);
            if (external != null) {
                String media = this.realDir(external.getAbsolutePath() + "/..");
                this.symlink(media, home + "/media");
                this.aliases_.get().property("/home/media", media);
            }
        }

        private void tearDown() {
            for (String dir : this.toclean) {
                this.deleteRecursive(new File(dir));
            }
        }

        FileSystem(JSContext ctx, int mediaPermissionsMask) {
            super(ctx);
            this.toclean = new ArrayList<String>();
            this.aliases_.set(new JSObject(ctx));
            this.access_.set(new JSObject(ctx));
            this.setUp();
            this.fs.set(new JSFunction(ctx, "fs", "try { file = require('path').resolve(file); } catch (e) {}var access = 0;for (var p in this.aliases_) {if (file.startsWith(this.aliases_[p] + '/')) {file = p + '/' + file.substring(this.aliases_[p].length + 1);break;} else if (file == this.aliases_[p]) {file = p;break;}}for (var p in this.access_) {if (file.startsWith(p + '/') || p==file) {access = this.access_[p];break;}}var newfile = file;for (var p in this.aliases_) {if (file.startsWith(p + '/')) {newfile = this.aliases_[p] + '/' + file.substring(p.length + 1);break;} else if (file == p) {newfile = this.aliases_[p];break;}}return [access,newfile];", "file"));
            this.alias.set(new JSFunction(ctx, "alias", "for (var p in this.aliases_) {if (file.startsWith(this.aliases_[p] + '/')) {file = p + '/' + file.substring(this.aliases_[p].length + 1);break;} else if (file == this.aliases_[p]) {file = p;break;}}return file;", "file"));
        }

        void cleanUp() {
            this.tearDown();
        }
    }

    private class ProcessContext
    extends JSContext {
        private long handleRef;

        ProcessContext(long contextRef, JSContextGroup group) {
            super(contextRef, group);
            this.handleRef = 0L;
        }

        void setDefunct() {
            this.isDefunct = true;
        }

        void keepAlive() {
            if (this.handleRef == 0L && !this.isDefunct.booleanValue()) {
                this.handleRef = Process.this.keepAlive(this.ctxRef());
            }
        }

        @Override
        public void async(Runnable runnable) {
            super.async(runnable);
        }

        void letDie() {
            if (this.handleRef != 0L && !this.isDefunct.booleanValue()) {
                Process.this.letDie(this.handleRef);
                this.handleRef = 0L;
            }
        }

        @Override
        public void finalize() throws Throwable {
            Process.this.exit(-222);
            Process.this.eventOnExit(Process.this.exitCode);
            super.finalize();
            Process.this.isActive = false;
        }
    }

    public static interface EventListener {
        public void onProcessStart(Process var1, JSContext var2);

        public void onProcessAboutToExit(Process var1, int var2);

        public void onProcessExit(Process var1, int var2);

        public void onProcessFailed(Process var1, Exception var2);
    }
}

