/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.node.Process;

public class NodeProcessService
extends IntentService
implements Process.EventListener {
    private static Map<String, Process> processMap = new HashMap<String, Process>();

    public NodeProcessService() {
        super("org.liquidplayer.node.NodeProcessService");
    }

    protected void onHandleIntent(Intent workIntent) {
        String uuid = workIntent.getExtras().getString("org.liquidplayer.node.Process");
        if (processMap.get(uuid) == null) {
            Log.d((String)"NodeProcessService", (String)("Creating new Process UUID " + uuid));
            processMap.put(uuid, new Process((Context)this, "node_console", 3, this));
        }
        Intent intent = new Intent(uuid);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    public static Process getProcess(String id) {
        return processMap.get(id);
    }

    @Override
    public void onProcessStart(Process process, JSContext context) {
    }

    @Override
    public void onProcessAboutToExit(Process process, int exitCode) {
        for (Map.Entry<String, Process> entry : processMap.entrySet()) {
            if (entry.getValue() != process) continue;
            processMap.remove(entry.getKey());
            process.removeEventListener(this);
            break;
        }
    }

    @Override
    public void onProcessExit(Process process, int exitCode) {
        for (Map.Entry<String, Process> entry : processMap.entrySet()) {
            if (entry.getValue() != process) continue;
            processMap.remove(entry.getKey());
            process.removeEventListener(this);
            break;
        }
    }

    @Override
    public void onProcessFailed(Process process, Exception error) {
    }
}

