/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.surfaces.console;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import java.util.HashMap;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;
import org.liquidplayer.node.Process;
import org.liquidplayer.service.MicroService;
import org.liquidplayer.service.Surface;
import org.liquidplayer.surfaces.console.ConsoleView;

public class ConsoleSurface
extends ConsoleView
implements Surface {
    public static String SURFACE_VERSION = "0.2.0";
    private ConsoleSession session = null;
    private String uuid;

    public ConsoleSurface(Context context) {
        this(context, null);
    }

    public ConsoleSurface(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ConsoleSurface(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setSaveEnabled(true);
    }

    @Override
    public void reset() {
        this.detach();
        super.reset();
    }

    @Override
    protected void resize(int columns, int rows) {
        if (this.session != null) {
            this.session.resize(columns, rows);
        }
    }

    public void attach(MicroService service, Runnable onAttached) {
        this.session = ConsoleSession.newSession(service, onAttached);
        this.session.setCurrentView(this);
        this.uuid = service.getId();
    }

    public void detach() {
        if (this.session != null) {
            this.session.detach();
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                ConsoleSurface.this.inputBox.setEnabled(false);
                ConsoleSurface.this.inputBox.setClickable(false);
                ConsoleSurface.this.inputBox.setAlpha(0.5f);
                ConsoleSurface.this.setButtonEnabled(ConsoleSurface.this.downHistory, false);
                ConsoleSurface.this.setButtonEnabled(ConsoleSurface.this.upHistory, false);
            }
        });
    }

    @Override
    protected void processCommand(String cmd) {
        if (this.session != null) {
            this.session.processCommand(cmd);
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.uuid = this.uuid;
        if (this.session != null) {
            this.session.removeCurrentView(this);
        }
        this.session = null;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.uuid = ss.uuid;
        this.session = ConsoleSession.getSessionFromServiceId(this.uuid);
    }

    private static class ConsoleSession
    implements Process.EventListener,
    JSContext.IJSExceptionHandler {
        private static HashMap<String, ConsoleSession> sessionMap = new HashMap();
        private Process process = null;
        private JSContext js = null;
        private JSFunction console_log = null;
        private Runnable onAttached = null;
        private ConsoleSurface currentView = null;
        private boolean processedException = false;
        private int columns = 0;
        private int rows = 0;
        private String uuid = null;

        static ConsoleSession newSession(MicroService service, Runnable onAttached) {
            ConsoleSession session = new ConsoleSession(service, onAttached);
            sessionMap.put(service.getId(), session);
            return session;
        }

        static ConsoleSession getSessionFromServiceId(String id) {
            return sessionMap.get(id);
        }

        private ConsoleSession(MicroService service, Runnable onAttached) {
            this.onAttached = onAttached;
            if (service != null) {
                this.process = service.getProcess();
                this.process.addEventListener((Process.EventListener)this);
                this.uuid = service.getId();
            }
        }

        void detach() {
            if (this.js != null && this.process.isActive()) {
                JSObject stdout = this.js.property("process").toObject().property("stdout").toObject();
                JSObject stderr = this.js.property("process").toObject().property("stderr").toObject();
                this.teardownStream(stdout);
                this.teardownStream(stderr);
            }
            this.console_log = null;
            this.js = null;
            this.process.removeEventListener((Process.EventListener)this);
            if (this.uuid != null) {
                sessionMap.remove(this.uuid);
            }
        }

        void setCurrentView(ConsoleSurface view) {
            this.currentView = view;
        }

        void removeCurrentView(ConsoleSurface view) {
            if (this.currentView == view) {
                this.currentView = null;
            }
        }

        void processCommand(final String cmd) {
            this.processedException = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JSValue output = ConsoleSession.this.js.evaluateScript(cmd);
                    if (!ConsoleSession.this.processedException && ConsoleSession.this.console_log != null) {
                        ConsoleSession.this.console_log.call(null, new Object[]{output});
                    }
                }
            }).start();
        }

        void resize(int columns, int rows) {
            this.columns = columns;
            this.rows = rows;
        }

        private void setupStream(JSObject stream, final StreamCallback callback) {
            stream.property("write", (Object)new JSFunction(stream.getContext(), "write"){

                public void write(String string) {
                    callback.callback(string);
                }
            });
            stream.property("clearScreenDown", (Object)new JSFunction(stream.getContext(), "clearScreenDown", "this.write('\\x1b[0J');", new String[0]));
            stream.property("moveCursor", (Object)new JSFunction(stream.getContext(), "moveCursor", "var out = ''; c = c || 0; r = r || 0;if (c>0) out += '\\x1b['+c+'C'; else if (c<0) out+='\\x1b['+(-c)+'D';if (r>0) out += '\\x1b['+r+'B'; else if (r<0) out+='\\x1b['+(-r)+'A';this.write(out);", new String[]{"c", "r"}));
            stream.property("rows", (Object)this.rows);
            stream.property("columns", (Object)this.columns);
        }

        private void teardownStream(JSObject stream) {
            stream.property("write", (Object)new JSFunction(this.js));
            stream.deleteProperty("clearScreenDown");
            stream.deleteProperty("moveCursor");
        }

        public void onProcessStart(Process process, JSContext context) {
            this.js = context;
            this.js.setExceptionHandler((JSContext.IJSExceptionHandler)this);
            this.console_log = this.js.property("console").toObject().property("log").toFunction();
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (ConsoleSession.this.currentView != null) {
                        ((ConsoleSession)ConsoleSession.this).currentView.inputBox.setEnabled(true);
                    }
                }
            });
            JSObject stdout = this.js.property("process").toObject().property("stdout").toObject();
            JSObject stderr = this.js.property("process").toObject().property("stderr").toObject();
            this.setupStream(stdout, new StreamCallback(){

                @Override
                public void callback(String string) {
                    if (ConsoleSession.this.currentView != null) {
                        ((ConsoleSession)ConsoleSession.this).currentView.consoleTextView.print(string);
                    }
                }
            });
            this.setupStream(stderr, new StreamCallback(){

                @Override
                public void callback(String string) {
                    string = "\u001b[31m" + string;
                    if (ConsoleSession.this.currentView != null) {
                        ((ConsoleSession)ConsoleSession.this).currentView.consoleTextView.print(string);
                    }
                    Log.e((String)"stderr", (String)string);
                }
            });
            if (this.onAttached != null) {
                this.onAttached.run();
                this.onAttached = null;
            }
        }

        public void onProcessAboutToExit(Process process, int exitCode) {
            if (this.currentView != null) {
                this.currentView.consoleTextView.println("\u001b[31mProcess about to exit with code " + exitCode);
            }
            Log.i((String)"onProcessAboutToExit", (String)("Process about to exit with code " + exitCode));
            this.detach();
        }

        public void onProcessExit(Process process, int exitCode) {
            Log.i((String)"onProcessExit", (String)"exiting");
            if (this.currentView != null) {
                this.currentView.consoleTextView.println("\u001b[31mProcess exited with code " + exitCode);
            }
            this.process = null;
        }

        public void onProcessFailed(Process process, Exception error) {
        }

        public void handle(JSException e) {
            this.processedException = true;
            if (this.currentView != null) {
                this.currentView.consoleTextView.println("\u001b[31m" + e.stack());
            }
        }

        private static interface StreamCallback {
            public void callback(String var1);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        String uuid;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.uuid = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.uuid);
        }
    }
}

