/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSObject;

public class JSDate
extends JSObject {
    public JSDate(JSContext ctx) {
        this.context = ctx;
        this.valueRef = this.context.ctxRef().makeDate(new long[0]);
        this.addJSExports();
        this.context.persistObject(this);
    }

    public JSDate(JSContext ctx, Date date) {
        this.context = ctx;
        long[] args = new long[]{date.getTime()};
        this.valueRef = this.context.ctxRef().makeDate(args);
        this.addJSExports();
        this.context.persistObject(this);
    }

    public JSDate(JSContext ctx, Long epoch) {
        this.context = ctx;
        long[] args = new long[]{epoch};
        this.valueRef = this.context.ctxRef().makeDate(args);
        this.addJSExports();
        this.context.persistObject(this);
    }

    public JSDate(JSContext ctx, Integer ... params) {
        this.context = ctx;
        Calendar calendar = Calendar.getInstance();
        int[] fields = new int[]{1, 2, 5, 11, 12, 13, 14};
        for (int i = 0; i < fields.length; ++i) {
            if (i < params.length) {
                calendar.set(fields[i], params[i]);
                continue;
            }
            calendar.set(fields[i], 0);
        }
        this.valueRef = this.context.ctxRef().makeDate(new long[]{calendar.getTime().getTime()});
        this.context.persistObject(this);
    }

    public static Long now(JSContext ctx) {
        return ctx.property("Date").toObject().property("now").toFunction().call().toNumber().longValue();
    }

    public static Long parse(JSContext ctx, String string) {
        return ctx.property("Date").toObject().property("parse").toFunction().call(null, string).toNumber().longValue();
    }

    public static Long UTC(JSContext ctx, Integer ... params) {
        ArrayList<Integer> p = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            if (i < params.length) {
                p.add(params[i]);
                continue;
            }
            p.add(0);
        }
        return ctx.property("Date").toObject().property("UTC").toFunction().apply(null, p.toArray()).toNumber().longValue();
    }

    public Integer getDate() {
        return this.property("getDate").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getDay() {
        return this.property("getDay").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getFullYear() {
        return this.property("getFullYear").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getHours() {
        return this.property("getHours").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getMilliseconds() {
        return this.property("getMilliseconds").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getMinutes() {
        return this.property("getMinutes").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getMonth() {
        return this.property("getMonth").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getSeconds() {
        return this.property("getSeconds").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Long getTime() {
        return this.property("getTime").toFunction().call(this, new Object[0]).toNumber().longValue();
    }

    public Integer getTimezoneOffset() {
        return this.property("getTimezoneOffset").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCDate() {
        return this.property("getUTCDate").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCDay() {
        return this.property("getUTCDay").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCFullYear() {
        return this.property("getUTCFullYear").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCHours() {
        return this.property("getUTCHours").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCMilliseconds() {
        return this.property("getUTCMilliseconds").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCMinutes() {
        return this.property("getUTCMinutes").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCMonth() {
        return this.property("getUTCMonth").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public Integer getUTCSeconds() {
        return this.property("getUTCSeconds").toFunction().call(this, new Object[0]).toNumber().intValue();
    }

    public void setDate(Integer value) {
        this.property("setDate").toFunction().call(this, value);
    }

    public void setFullYear(Integer value) {
        this.property("setFullYear").toFunction().call(this, value);
    }

    public void setHours(Integer value) {
        this.property("setHours").toFunction().call(this, value);
    }

    public void setMilliseconds(Integer value) {
        this.property("setMilliseconds").toFunction().call(this, value);
    }

    public void setMinutes(Integer value) {
        this.property("setMinutes").toFunction().call(this, value);
    }

    public void setMonth(Integer value) {
        this.property("setMonth").toFunction().call(this, value);
    }

    public void setSeconds(Integer value) {
        this.property("setSeconds").toFunction().call(this, value);
    }

    public void setTime(Long value) {
        this.property("setTime").toFunction().call(this, value);
    }

    public void setUTCDate(Integer value) {
        this.property("setUTCDate").toFunction().call(this, value);
    }

    public void setUTCFullYear(Integer value) {
        this.property("setUTCFullYear").toFunction().call(this, value);
    }

    public void setUTCHours(Integer value) {
        this.property("setUTCHours").toFunction().call(this, value);
    }

    public void setUTCMilliseconds(Integer value) {
        this.property("setUTCMilliseconds").toFunction().call(this, value);
    }

    public void setUTCMinutes(Integer value) {
        this.property("setUTCMinutes").toFunction().call(this, value);
    }

    public void setUTCMonth(Integer value) {
        this.property("setUTCMonth").toFunction().call(this, value);
    }

    public void setUTCSeconds(Integer value) {
        this.property("setUTCSeconds").toFunction().call(this, value);
    }

    public String toDateString() {
        return this.property("toDateString").toFunction().call(this, new Object[0]).toString();
    }

    public String toISOString() {
        return this.property("toISOString").toFunction().call(this, new Object[0]).toString();
    }

    @Override
    public String toJSON() {
        return this.property("toJSON").toFunction().call(this, new Object[0]).toString();
    }

    public String toTimeString() {
        return this.property("toTimeString").toFunction().call(this, new Object[0]).toString();
    }

    public String toUTCString() {
        return this.property("toUTCString").toFunction().call(this, new Object[0]).toString();
    }
}

