/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSValue;

public abstract class JSBaseArray<T>
extends JSFunction
implements List<T> {
    Class<T> mType;
    int mLeftBuffer = 0;
    private int mRightBuffer = 0;
    JSBaseArray<T> mSuperList = null;

    JSBaseArray(JNIJSObject valueRef, JSContext ctx, Class<T> cls) {
        super(valueRef, ctx);
        this.mType = cls;
    }

    JSBaseArray(JSBaseArray<T> superList, int leftBuffer, int rightBuffer, Class<T> cls) {
        this.mType = cls;
        this.mLeftBuffer = leftBuffer;
        this.mRightBuffer = rightBuffer;
        this.context = superList.context;
        this.valueRef = superList.valueRef();
        this.mSuperList = superList;
    }

    JSBaseArray(JSContext ctx, Class<T> cls) {
        this.context = ctx;
        this.mType = cls;
    }

    public Object[] toArray(Class clazz) {
        int count = this.size();
        Object[] array = (Object[])Array.newInstance(clazz, count);
        for (int i = 0; i < count; ++i) {
            array[i] = this.elementAtIndex(i).toJavaObject(clazz);
        }
        return array;
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.toArray(this.mType);
    }

    @Override
    public T get(int index) {
        int count = this.size();
        if (index >= count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (T)this.elementAtIndex(index).toJavaObject(this.mType);
    }

    @Override
    public boolean add(T val) {
        int count = this.size();
        this.elementAtIndex(count, val);
        return true;
    }

    @Override
    public int size() {
        if (this.mSuperList == null) {
            return this.property("length").toNumber().intValue();
        }
        return Math.max(0, this.mSuperList.size() - this.mLeftBuffer - this.mRightBuffer);
    }

    protected JSValue arrayElement(int index) {
        return this.propertyAtIndex(index);
    }

    protected void arrayElement(int index, T value) {
        this.propertyAtIndex(index, value);
    }

    private JSValue elementAtIndex(int index) {
        if (this.mSuperList == null) {
            return this.arrayElement(index);
        }
        return super.elementAtIndex(index + this.mLeftBuffer);
    }

    private void elementAtIndex(int index, T value) {
        if (this.mSuperList == null) {
            this.arrayElement(index, value);
        } else {
            super.elementAtIndex(index + this.mLeftBuffer, value);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    @Override
    @NonNull
    public <U> U[] toArray(U[] phantomArray) {
        Object[] elemArray = (Object[])Array.newInstance(phantomArray.getClass().getComponentType(), this.size());
        ArrayIterator iterator = new ArrayIterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            elemArray[index++] = next;
        }
        for (int i = index; i < elemArray.length; ++i) {
            elemArray[i] = null;
        }
        return elemArray;
    }

    @Override
    public boolean remove(Object object) {
        ArrayIterator listIterator = new ArrayIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().equals(object)) continue;
            listIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        for (Object item : collection.toArray()) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends T> collection) {
        int i = index;
        for (Object item : collection.toArray()) {
            this.add(i++, (T)item);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        boolean any = false;
        ListIterator<T> listIterator = this.listIterator();
        block0: while (listIterator.hasNext()) {
            T compare = listIterator.next();
            for (Object element : collection) {
                if (!compare.equals(element)) continue;
                listIterator.remove();
                any = true;
                continue block0;
            }
        }
        return any;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        boolean any = false;
        ListIterator<T> listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            T compare = listIterator.next();
            boolean remove = true;
            for (Object element : collection) {
                if (!compare.equals(element)) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            listIterator.remove();
            any = true;
        }
        return any;
    }

    @Override
    public void clear() {
        for (int i = this.size(); i > 0; --i) {
            this.remove(i - 1);
        }
    }

    @Override
    public T set(int index, T element) {
        int count = this.size();
        if (index >= count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        JSValue oldValue = this.elementAtIndex(index);
        this.elementAtIndex(index, element);
        return (T)oldValue.toJavaObject(this.mType);
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<T> listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().equals(object)) continue;
            return listIterator.nextIndex() - 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<T> listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            if (!listIterator.previous().equals(object)) continue;
            return listIterator.previousIndex() + 1;
        }
        return -1;
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator(int index) {
        return new ArrayIterator(index);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        if (this.size() != otherList.size()) {
            return false;
        }
        Iterator<T> iterator = this.iterator();
        Iterator otherIterator = otherList.iterator();
        while (iterator.hasNext() && otherIterator.hasNext()) {
            Object otherNext;
            T next = iterator.next();
            if (next.equals(otherNext = otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    private class ArrayIterator
    implements ListIterator<T> {
        private int current;
        private Integer modifiable = null;

        ArrayIterator() {
            this(0);
        }

        ArrayIterator(int index) {
            if (index > JSBaseArray.this.size()) {
                index = JSBaseArray.this.size();
            }
            if (index < 0) {
                index = 0;
            }
            this.current = index;
        }

        @Override
        public boolean hasNext() {
            return this.current < JSBaseArray.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.current > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.modifiable = this.current;
            return JSBaseArray.this.get(this.current++);
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.modifiable = --this.current;
            return JSBaseArray.this.get(this.current);
        }

        @Override
        public void remove() {
            if (this.modifiable == null) {
                throw new NoSuchElementException();
            }
            JSBaseArray.this.remove(this.modifiable);
            this.current = this.modifiable;
            this.modifiable = null;
        }

        @Override
        public int nextIndex() {
            return this.current;
        }

        @Override
        public int previousIndex() {
            return this.current - 1;
        }

        @Override
        public void set(T value) {
            if (this.modifiable == null) {
                throw new NoSuchElementException();
            }
            JSBaseArray.this.set((int)this.modifiable, value);
        }

        @Override
        public void add(T value) {
            JSBaseArray.this.add(this.current++, value);
            this.modifiable = null;
        }
    }
}

