/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.liquidplayer.javascript.JNIJSBoolean;
import org.liquidplayer.javascript.JNIJSPrimitive;
import org.liquidplayer.javascript.JNIJSValue;

class JNIJSNumber
extends JNIJSPrimitive {
    private final double value;
    private static final DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    JNIJSNumber(long ref) {
        super(ref);
        this.value = Double.longBitsToDouble(ref);
    }

    @Override
    boolean isNumber() {
        return true;
    }

    @Override
    protected boolean primitiveEqual(JNIJSPrimitive b) {
        return b instanceof JNIJSNumber && ((JNIJSNumber)b).value == this.value || b instanceof JNIJSBoolean && (((JNIJSBoolean)b).reference == 14L && this.toBoolean() || ((JNIJSBoolean)b).reference == 10L && !this.toBoolean());
    }

    @Override
    protected boolean primitiveStrictEqual(JNIJSPrimitive b) {
        return b instanceof JNIJSNumber && ((JNIJSNumber)b).value == this.value;
    }

    @Override
    JNIJSValue createJSONString() {
        return this;
    }

    @Override
    boolean toBoolean() {
        return this.value != 0.0;
    }

    @Override
    double toNumber() {
        return this.value;
    }

    @Override
    String toStringCopy() {
        return df.format(this.value);
    }

    static {
        df.setMaximumFractionDigits(340);
    }
}

