/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSObjectPropertiesMap;

public class JSValue {
    protected JNIJSValue valueRef;
    protected JSContext context = null;

    protected JSValue() {
    }

    public JSValue(JSContext ctx) {
        this.context = ctx;
        this.valueRef = ctx.ctxRef().makeUndefined();
    }

    public JSValue(JSContext ctx, Object val) {
        this.context = ctx;
        this.valueRef = val == null ? this.context.ctxRef().makeNull() : (val instanceof JSValue ? ((JSValue)val).valueRef() : (val instanceof Map ? new JSObjectPropertiesMap<Object>(this.context, (Map)val, Object.class).getJSObject().valueRef() : (val instanceof List ? new JSArray<JSValue>(this.context, (List)val, JSValue.class).valueRef() : (val.getClass().isArray() ? new JSArray<JSValue>(this.context, (Object[])val, JSValue.class).valueRef() : (val instanceof Boolean ? this.context.ctxRef().makeBoolean((Boolean)val) : (val instanceof Double ? this.context.ctxRef().makeNumber((Double)val) : (val instanceof Float ? this.context.ctxRef().makeNumber(Double.valueOf(val.toString())) : (val instanceof Integer ? this.context.ctxRef().makeNumber(((Integer)val).doubleValue()) : (val instanceof Long ? this.context.ctxRef().makeNumber(((Long)val).doubleValue()) : (val instanceof Byte ? this.context.ctxRef().makeNumber(((Byte)val).doubleValue()) : (val instanceof Short ? this.context.ctxRef().makeNumber(((Short)val).doubleValue()) : (val instanceof String ? this.context.ctxRef().makeString((String)val) : this.context.ctxRef().makeUndefined()))))))))))));
    }

    JSValue(JNIJSValue valueRef, JSContext ctx) {
        this.context = ctx;
        this.valueRef = valueRef != null ? valueRef : ctx.ctxRef().makeUndefined();
    }

    public Boolean isUndefined() {
        return this.valueRef().isUndefined();
    }

    public Boolean isNull() {
        return this.valueRef().isNull();
    }

    public Boolean isBoolean() {
        return this.valueRef().isBoolean();
    }

    public Boolean isNumber() {
        return this.valueRef().isNumber();
    }

    public Boolean isString() {
        return this.valueRef().isString();
    }

    public Boolean isArray() {
        return this.valueRef().isArray();
    }

    public Boolean isDate() {
        return this.valueRef().isDate();
    }

    public Boolean isTypedArray() {
        return this.valueRef().isTypedArray();
    }

    public Boolean isInt8Array() {
        return this.valueRef().isInt8Array();
    }

    public Boolean isInt16Array() {
        return this.valueRef().isInt16Array();
    }

    public Boolean isInt32Array() {
        return this.valueRef().isInt32Array();
    }

    public Boolean isUint8ClampedArray() {
        return this.valueRef().isUint8ClampedArray();
    }

    public Boolean isUint8Array() {
        return this.valueRef().isUint8Array();
    }

    public Boolean isUint16Array() {
        return this.valueRef().isUint16Array();
    }

    public Boolean isUint32Array() {
        return this.valueRef().isUint32Array();
    }

    public Boolean isFloat32Array() {
        return this.valueRef().isFloat32Array();
    }

    public Boolean isFloat64Array() {
        return this.valueRef().isFloat64Array();
    }

    public Boolean isObject() {
        return this.valueRef().isObject();
    }

    public Boolean isInstanceOfConstructor(JSObject constructor) {
        try {
            JSFunction instanceOf = new JSFunction(this.context, "_instanceOf", new String[]{"a", "b"}, "return (a instanceof b);", null, 0);
            return instanceOf.call(null, this, constructor).toBoolean();
        }
        catch (JSException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    public boolean isEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue otherJSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        JSValue ojsv = otherJSValue;
        try {
            return this.valueRef().isEqual(ojsv.valueRef);
        }
        catch (JNIJSException excp) {
            return false;
        }
    }

    public boolean isStrictEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue otherJSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        JSValue ojsv = otherJSValue;
        return this.valueRef().isStrictEqual(ojsv.valueRef);
    }

    public Boolean toBoolean() {
        return this.valueRef().toBoolean();
    }

    public Double toNumber() {
        try {
            return this.valueRef().toNumber();
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return 0.0;
        }
    }

    @NonNull
    public String toString() {
        try {
            return this.valueRef().toStringCopy();
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return "";
        }
    }

    public JSObject toObject() {
        if (this instanceof JSObject) {
            return (JSObject)this;
        }
        try {
            return this.context.getObjectFromRef(this.valueRef().toObject());
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return new JSObject(this.context);
        }
    }

    public JSFunction toFunction() {
        JSObject obj;
        if (this.isObject().booleanValue() && (obj = this.toObject()) instanceof JSFunction) {
            return (JSFunction)obj;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not a function"));
        return null;
    }

    public JSBaseArray toJSArray() {
        JSObject obj;
        if (this.isObject().booleanValue() && (obj = this.toObject()) instanceof JSBaseArray) {
            return (JSBaseArray)obj;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not an array"));
        return null;
    }

    public String toJSON() {
        try {
            JSValue json = new JSValue(this.valueRef().createJSONString(), this.context);
            if (json.isUndefined().booleanValue()) {
                return null;
            }
            return json.toString();
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return null;
        }
    }

    Object toJavaObject(Class clazz) {
        if (clazz == Object.class) {
            return this;
        }
        if (clazz == Map.class) {
            return new JSObjectPropertiesMap<Object>(this.toObject(), Object.class);
        }
        if (clazz == List.class) {
            return this.toJSArray();
        }
        if (clazz == String.class) {
            return this.toString();
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return this.toNumber();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(this.toNumber().floatValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return this.toNumber().intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return this.toNumber().longValue();
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return this.toNumber().byteValue();
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return this.toNumber().shortValue();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return this.toBoolean();
        }
        if (clazz.isArray()) {
            return this.toJSArray().toArray(clazz.getComponentType());
        }
        if (JSArray.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toJSArray());
        }
        if (JSObject.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toObject());
        }
        if (JSValue.class.isAssignableFrom(clazz)) {
            return clazz.cast(this);
        }
        return null;
    }

    public int hashCode() {
        if (this.isBoolean().booleanValue()) {
            return this.toBoolean().hashCode();
        }
        if (this.isNumber().booleanValue()) {
            return this.toNumber().hashCode();
        }
        if (this.isString().booleanValue()) {
            return this.toString().hashCode();
        }
        if (this.isUndefined().booleanValue() || this.isNull().booleanValue()) {
            return 0;
        }
        return super.hashCode();
    }

    public JSContext getContext() {
        return this.context;
    }

    JNIJSValue valueRef() {
        return this.valueRef;
    }

    public long valueHash() {
        return this.valueRef().reference;
    }
}

