/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JSArrayBuffer;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFloat32Array;
import org.liquidplayer.javascript.JSFloat64Array;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSInt16Array;
import org.liquidplayer.javascript.JSInt32Array;
import org.liquidplayer.javascript.JSInt8Array;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSUint16Array;
import org.liquidplayer.javascript.JSUint32Array;
import org.liquidplayer.javascript.JSUint8Array;
import org.liquidplayer.javascript.JSUint8ClampedArray;
import org.liquidplayer.javascript.JSValue;

public abstract class JSTypedArray<T>
extends JSBaseArray<T> {
    protected JSTypedArray(JSContext ctx, int length, String jsConstructor, Class<T> cls) {
        super(ctx, cls);
        JSFunction constructor = new JSFunction(this.context, "_" + jsConstructor, new String[]{"length"}, "return new " + jsConstructor + "(length);", null, 0);
        JSValue newArray = constructor.call(null, length);
        this.valueRef = newArray.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSTypedArray typedArray, String jsConstructor, Class<T> cls) {
        super(typedArray.context, cls);
        JSFunction constructor = new JSFunction(this.context, "_" + jsConstructor, new String[]{"tarr"}, "return new " + jsConstructor + "(tarr);", null, 0);
        JSValue newArray = constructor.call(null, typedArray);
        this.valueRef = newArray.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSContext ctx, Object object, String jsConstructor, Class<T> cls) {
        super(ctx, cls);
        this.context = ctx;
        JSFunction constructor = new JSFunction(this.context, "_" + jsConstructor, new String[]{"obj"}, "return new " + jsConstructor + "(obj);", null, 0);
        JSValue newArray = constructor.call(null, object);
        this.valueRef = newArray.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSArrayBuffer buffer, int byteOffset, int length, String jsConstructor, Class<T> cls) {
        super(buffer.getJSObject().getContext(), cls);
        JSFunction constructor = new JSFunction(this.context, "_" + jsConstructor, new String[]{"buffer,byteOffset,length"}, "return new " + jsConstructor + "(buffer,byteOffset,length);", null, 0);
        JSValue newArray = constructor.call(null, buffer.getJSObject(), byteOffset, length);
        this.valueRef = newArray.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSArrayBuffer buffer, int byteOffset, String jsConstructor, Class<T> cls) {
        super(buffer.getJSObject().getContext(), cls);
        JSFunction constructor = new JSFunction(this.context, "_" + jsConstructor, new String[]{"buffer,byteOffset"}, "return new " + jsConstructor + "(buffer,byteOffset);", null, 0);
        JSValue newArray = constructor.call(null, buffer.getJSObject(), byteOffset);
        this.valueRef = newArray.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSArrayBuffer buffer, String jsConstructor, Class<T> cls) {
        super(buffer.getJSObject().getContext(), cls);
        JSFunction constructor = new JSFunction(this.context, "_" + jsConstructor, new String[]{"buffer"}, "return new " + jsConstructor + "(buffer);", null, 0);
        JSValue newArray = constructor.call(null, buffer.getJSObject());
        this.valueRef = newArray.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JNIJSObject objRef, JSContext ctx, Class<T> cls) {
        super(objRef, ctx, cls);
    }

    protected JSTypedArray(JSTypedArray superList, int leftBuffer, int rightBuffer, Class<T> cls) {
        super(superList, leftBuffer, rightBuffer, cls);
    }

    public static JSTypedArray from(JSObject obj) {
        JSTypedArray arr;
        if (obj.isInt8Array().booleanValue()) {
            arr = new JSInt8Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isUint8Array().booleanValue()) {
            arr = new JSUint8Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isUint8ClampedArray().booleanValue()) {
            arr = new JSUint8ClampedArray(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isInt16Array().booleanValue()) {
            arr = new JSInt16Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isUint16Array().booleanValue()) {
            arr = new JSUint16Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isInt32Array().booleanValue()) {
            arr = new JSInt32Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isUint32Array().booleanValue()) {
            arr = new JSUint32Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isFloat32Array().booleanValue()) {
            arr = new JSFloat32Array(obj.toObject().JNI(), obj.getContext());
        } else if (obj.isFloat64Array().booleanValue()) {
            arr = new JSFloat64Array(obj.toObject().JNI(), obj.getContext());
        } else {
            throw new JSException(obj.getContext(), "Object not a typed array");
        }
        return arr;
    }

    public JSArrayBuffer buffer() {
        return new JSArrayBuffer(this.property("buffer").toObject());
    }

    public int byteLength() {
        return this.property("byteLength").toNumber().intValue();
    }

    public int byteOffset() {
        return this.property("byteOffset").toNumber().intValue();
    }

    @Override
    protected JSValue arrayElement(int index) {
        JSFunction getElement = new JSFunction(this.context, "_getElement", new String[]{"thiz", "index"}, "return thiz[index]", null, 0);
        return getElement.call(null, this, index);
    }

    @Override
    protected void arrayElement(int index, T value) {
        JSFunction setElement = new JSFunction(this.context, "_setElement", new String[]{"thiz", "index", "value"}, "thiz[index] = value", null, 0);
        setElement.call(null, this, index, value);
    }

    @Override
    public boolean add(T val) throws JSException {
        throw new UnsupportedOperationException();
    }

    protected JSTypedArray<T> subarray(int begin, int end) {
        JSObject subarray = this.property("subarray").toFunction().call(this, begin, end).toObject();
        return (JSTypedArray)subarray.toJSArray();
    }

    protected JSTypedArray<T> subarray(int begin) {
        JSObject subarray = this.property("subarray").toFunction().call(this, begin).toObject();
        return (JSTypedArray)subarray.toJSArray();
    }
}

