/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.service;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSON;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;
import org.liquidplayer.node.Process;
import org.liquidplayer.service.AddOn;

public class MicroService
implements Process.EventListener {
    private ServiceStartListener startListener;
    private ServiceExitListener exitListener;
    private ServiceErrorListener errorListener;
    private final URI serviceURI;
    private String serviceId;
    private final Context androidCtx;
    private final String uuid;
    private String[] argv;
    private String module;
    private JSObject emitter;
    private JSFunction safeStringify;
    private boolean started = false;
    private Process process;
    private final Map<String, Map<EventListener, JSFunction>> listeners = Collections.synchronizedMap(new HashMap());
    private final Object listenersMutex = new Object();
    private static final Map<String, MicroService> serviceMap = Collections.synchronizedMap(new HashMap());
    private static final Object serviceMapMutex = new Object();

    public static URI DevServer(@Nullable String fileName, @Nullable Integer port) {
        if (fileName == null) {
            fileName = "liquid.js";
        }
        if (port == null) {
            port = 8082;
        }
        if (fileName.endsWith(".js")) {
            fileName = fileName.substring(0, fileName.length() - 3);
        }
        if (!fileName.endsWith(".bundle")) {
            fileName = fileName.concat(".bundle");
        }
        URI loopback = URI.create("http://10.0.2.2:" + port + "/" + fileName + "?platform=android&dev=true");
        return loopback;
    }

    public static URI DevServer() {
        return MicroService.DevServer(null, null);
    }

    public MicroService(Context ctx, URI serviceURI, ServiceStartListener start, ServiceErrorListener error, ServiceExitListener exit) {
        this.serviceURI = serviceURI;
        try {
            this.serviceId = URLEncoder.encode(serviceURI.toString().substring(0, serviceURI.toString().lastIndexOf(47)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"MicrosService", (String)e.toString());
        }
        this.startListener = start;
        this.exitListener = exit;
        this.errorListener = error;
        this.androidCtx = ctx;
        this.uuid = UUID.randomUUID().toString();
        serviceMap.put(this.uuid, this);
    }

    public MicroService(Context ctx, URI serviceURI, ServiceStartListener start, ServiceErrorListener error) {
        this(ctx, serviceURI, start, error, null);
    }

    public MicroService(Context ctx, URI serviceURI, ServiceStartListener start) {
        this(ctx, serviceURI, start, null);
    }

    public MicroService(Context ctx, URI serviceURI) {
        this(ctx, serviceURI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(final String event, final EventListener listener) {
        String safeStringifyBody = "   function serializer(replacer, cycleReplacer) {\n       var stack = [], keys = []\n       if (cycleReplacer == null) cycleReplacer = function(key, value) {\n           if (stack[0] === value) return '[Circular ~]'\n           return'[Circular ~.' + keys.slice(0, stack.indexOf(value)).join('.')+']'\n       }\n       return function(key, value) {\n           if (stack.length > 0) {\n               var thisPos = stack.indexOf(this)\n               ~thisPos ? stack.splice(thisPos + 1) : stack.push(this)\n               ~thisPos ? keys.splice(thisPos, Infinity, key) : keys.push(key)\n               if (~stack.indexOf(value))value=cycleReplacer.call(this, key, value)\n           }\n           else stack.push(value)\n\n           if (typeof value === 'function') {\n               value = {};\n           }\n\n           return replacer == null ? value : replacer.call(this, key, value)\n       }\n   }\n   return JSON.stringify(obj, serializer(replacer, cycleReplacer), spaces)\n";
        if (this.emitter != null) {
            if (this.safeStringify == null) {
                this.safeStringify = new JSFunction(this.emitter.getContext(), "safeStringify", "   function serializer(replacer, cycleReplacer) {\n       var stack = [], keys = []\n       if (cycleReplacer == null) cycleReplacer = function(key, value) {\n           if (stack[0] === value) return '[Circular ~]'\n           return'[Circular ~.' + keys.slice(0, stack.indexOf(value)).join('.')+']'\n       }\n       return function(key, value) {\n           if (stack.length > 0) {\n               var thisPos = stack.indexOf(this)\n               ~thisPos ? stack.splice(thisPos + 1) : stack.push(this)\n               ~thisPos ? keys.splice(thisPos, Infinity, key) : keys.push(key)\n               if (~stack.indexOf(value))value=cycleReplacer.call(this, key, value)\n           }\n           else stack.push(value)\n\n           if (typeof value === 'function') {\n               value = {};\n           }\n\n           return replacer == null ? value : replacer.call(this, key, value)\n       }\n   }\n   return JSON.stringify(obj, serializer(replacer, cycleReplacer), spaces)\n", "obj", "replacer", "spaces", "cycleReplacer");
            }
            JSFunction jsListener = new JSFunction(this.emitter.getContext(), "on"){

                public void on(JSValue value) throws JSONException {
                    JSONObject o = null;
                    if (value != null && !value.isNull().booleanValue() && !value.isUndefined().booleanValue()) {
                        if (value.isArray().booleanValue()) {
                            JSONArray a = new JSONArray(MicroService.this.safeStringify.call(null, value).toString());
                            o = new JSONObject();
                            o.put("_", (Object)a);
                        } else if (value.isNumber().booleanValue()) {
                            o = new JSONObject();
                            o.put("_", (Object)value.toNumber());
                        } else if (value.isBoolean().booleanValue()) {
                            o = new JSONObject();
                            o.put("_", (Object)value.toBoolean());
                        } else if (value.isDate().booleanValue()) {
                            o = new JSONObject();
                            o.put("_", (Object)MicroService.this.safeStringify.call(null, value).toString());
                        } else if (value.isObject().booleanValue()) {
                            o = new JSONObject(MicroService.this.safeStringify.call(null, value).toString());
                        } else {
                            o = new JSONObject();
                            o.put("_", (Object)value.toString());
                        }
                    }
                    listener.onEvent(MicroService.this, event, o);
                }
            };
            Object object = this.listenersMutex;
            synchronized (object) {
                Map<EventListener, JSFunction> eventMap = this.listeners.get(event);
                if (eventMap == null) {
                    eventMap = Collections.synchronizedMap(new HashMap());
                    this.listeners.put(event, eventMap);
                }
                eventMap.put(listener, jsListener);
            }
            this.emitter.property("on").toFunction().call(this.emitter, event, jsListener);
        }
    }

    public String getId() {
        return this.uuid;
    }

    public Process getProcess() {
        return this.process;
    }

    public URI getServiceURI() {
        return this.serviceURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(String event, EventListener listener) {
        Map<EventListener, JSFunction> eventMap;
        Object object = this.listenersMutex;
        synchronized (object) {
            eventMap = this.listeners.get(event);
        }
        if (eventMap != null) {
            JSFunction func;
            Object object2 = this.listenersMutex;
            synchronized (object2) {
                func = eventMap.get(listener);
                if (func != null) {
                    eventMap.remove(listener);
                    if (eventMap.size() == 0) {
                        this.listeners.remove(event);
                    }
                }
            }
            if (this.emitter != null) {
                this.emitter.property("removeListener").toFunction().call(this.emitter, event, func);
            }
        }
    }

    public void emit(String event, JSONObject payload) {
        if (this.emitter != null) {
            JSValue o = payload != null ? JSON.parse(this.emitter.getContext(), payload.toString()) : new JSValue(this.emitter.getContext());
            this.emitter.property("emit").toFunction().call(this.emitter, event, o);
        }
    }

    public void emit(String event) {
        this.emit(event, (JSONObject)null);
    }

    public void emit(String event, Integer v) {
        if (this.emitter != null) {
            this.emitter.property("emit").toFunction().call(this.emitter, event, v);
        }
    }

    public void emit(String event, Long v) {
        if (this.emitter != null) {
            this.emitter.property("emit").toFunction().call(this.emitter, event, v);
        }
    }

    public void emit(String event, Float v) {
        if (this.emitter != null) {
            this.emitter.property("emit").toFunction().call(this.emitter, event, v);
        }
    }

    public void emit(String event, Double v) {
        if (this.emitter != null) {
            this.emitter.property("emit").toFunction().call(this.emitter, event, v);
        }
    }

    public void emit(String event, String v) {
        if (this.emitter != null) {
            this.emitter.property("emit").toFunction().call(this.emitter, event, v);
        }
    }

    public void emit(String event, Boolean v) {
        if (this.emitter != null) {
            this.emitter.property("emit").toFunction().call(this.emitter, event, v);
        }
    }

    public void emit(String event, JSONArray v) {
        if (this.emitter != null) {
            JSValue o = v != null ? JSON.parse(this.emitter.getContext(), v.toString()) : new JSValue(this.emitter.getContext());
            this.emitter.property("emit").toFunction().call(this.emitter, event, o);
        }
    }

    public synchronized void start(String ... argv) {
        if (this.started) {
            throw new ServiceAlreadyStartedError();
        }
        this.started = true;
        this.argv = argv;
        this.process = new Process(this.androidCtx, this.serviceId, 3, this);
    }

    public static void uninstall(Context ctx, URI serviceURI) {
        try {
            String serviceId = URLEncoder.encode(serviceURI.toString().substring(0, serviceURI.toString().lastIndexOf(47)), "UTF-8");
            Process.uninstall(ctx, serviceId, Process.UninstallScope.Global);
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"MicrosService", (String)e.toString());
        }
    }

    private File getModulePath() {
        String suffix = "/__org.liquidplayer.node__/_" + this.serviceId;
        String modules = this.androidCtx.getFilesDir().getAbsolutePath() + suffix + "/module";
        return new File(modules);
    }

    private File getNodeModulesPath() {
        String suffix = "/__org.liquidplayer.node__/_" + this.serviceId;
        String node_modules = this.androidCtx.getFilesDir().getAbsolutePath() + suffix + "/node_modules";
        return new File(node_modules);
    }

    private void fetchService() throws IOException {
        String path = this.serviceURI.getPath();
        this.module = path.substring(path.lastIndexOf(47) + 1);
        if (!this.module.endsWith(".js")) {
            this.module = this.module + ".js";
        }
        File moduleF = new File(this.getModulePath().getAbsolutePath() + "/" + this.module);
        long lastModified = moduleF.lastModified();
        String scheme = this.serviceURI.getScheme();
        InputStream in = null;
        if ("http".equals(scheme) || "https".equals(scheme)) {
            URL url = this.serviceURI.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            if (lastModified > 0L) {
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                connection.setRequestProperty("If-Modified-Since", sdf.format(new Date(lastModified)) + " GMT");
            }
            connection.setRequestProperty("Accept-Encoding", "gzip");
            String version = "0.6.0";
            String info = "Android; API " + Build.VERSION.SDK_INT;
            String userAgent = "LiquidCore/" + version + " (" + info + ")";
            Log.d((String)"MicroService", (String)("User-Agent : " + userAgent));
            connection.setRequestProperty("User-Agent", userAgent);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                in = connection.getHeaderField("Content-Encoding") != null && connection.getHeaderField("Content-Encoding").equals("gzip") ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream();
            } else if (responseCode != 304) {
                Log.e((String)"FileNotFound", (String)("responseCode = " + responseCode));
                throw new FileNotFoundException();
            }
        } else if ("jarfile".equals(scheme)) {
            int loc = this.serviceURI.getPath().lastIndexOf("/");
            in = this.getClass().getClassLoader().getResourceAsStream(this.serviceURI.getPath().substring(loc + 1));
        } else {
            in = "file".equals(scheme) && path.startsWith("/android_asset/") ? this.androidCtx.getAssets().open(path.substring(15)) : this.androidCtx.getContentResolver().openInputStream(Uri.parse((String)this.serviceURI.toString()));
        }
        if (in != null) {
            int len;
            FileOutputStream out = new FileOutputStream(moduleF);
            byte[] buf = new byte[16384];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
    }

    private static String canon(String name) {
        name = name.replaceAll("[^a-zA-Z0-9]", "*");
        StringBuilder canonical = new StringBuilder();
        boolean nextCapital = true;
        for (int i = 0; i < name.length(); ++i) {
            if (name.substring(i, i + 1).equals("*")) {
                nextCapital = true;
                continue;
            }
            char ch = name.charAt(i);
            if (nextCapital && ch >= 'a' && ch <= 'z') {
                ch = (char)(65 + ch - 97);
            }
            nextCapital = false;
            canonical.append(ch);
        }
        return canonical.toString();
    }

    private static void IGNORE_RESULT(boolean b) {
    }

    private JSValue bindings(JSContext context, String module, JSFunction require) {
        String moduleName;
        int fndx = module.lastIndexOf(47);
        String fname = module.substring(fndx + 1);
        int endx = fname.lastIndexOf(46);
        String ext = endx >= 0 ? fname.substring(endx + 1) : "";
        String string = moduleName = endx < 0 ? fname : fname.substring(0, endx);
        if (!"node".equals(ext)) {
            return require.call(null, module);
        }
        Class addOnClass = AddOn.class;
        try {
            Class<?> klass = context.getClass().getClassLoader().loadClass("org.liquidplayer.addon." + MicroService.canon(moduleName));
            if (AddOn.class.isAssignableFrom(klass)) {
                addOnClass = klass;
                AddOn addOn = (AddOn)addOnClass.getConstructor(Context.class).newInstance(this.androidCtx);
                addOn.register(moduleName);
                File node_module = new File(this.getNodeModulesPath() + "/" + fname);
                if (!node_module.exists()) {
                    try {
                        MicroService.IGNORE_RESULT(node_module.createNewFile());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                JSValue binding = require.call(null, "/home/node_modules/" + fname);
                addOn.require(binding, this);
                return binding;
            }
            Log.e((String)"LiquidCore.bindings", (String)("Class " + klass.getCanonicalName() + " does not implement org.liquidplayer.service.AddOn"));
        }
        catch (JSException e) {
            Log.e((String)"LiquidCore.bindings", (String)e.stack());
        }
        catch (ClassNotFoundException e) {
            Log.e((String)"bindings", (String)("Class org.liquidplayer.addon." + moduleName + " not found."));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)"LiquidCore AddOn", (String)("" + addOnClass.getCanonicalName() + " must have a default constructor."));
        }
        catch (IllegalAccessException e) {
            Log.e((String)"LiquidCore AddOn", (String)("" + addOnClass.getCanonicalName() + " must be public."));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return new JSValue(context);
    }

    @Override
    public void onProcessStart(Process process, JSContext context) {
        context.evaluateScript("(()=>{\n   class LiquidCore extends require('events') {}\n   global.LiquidCore = new LiquidCore();\n   return global.LiquidCore;})()");
        this.emitter = context.property("LiquidCore").toObject();
        final JSValue require = context.property("require");
        JSFunction bindings = new JSFunction(context, "bindings"){

            public JSValue bindings(String module) {
                return MicroService.this.bindings(this.context, module, require.toFunction());
            }
        };
        bindings.prototype(require);
        context.property("require", bindings);
        try {
            this.fetchService();
            if (this.startListener != null) {
                this.startListener.onStart(this);
                this.startListener = null;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("node");
            args.add("/home/module/" + this.module);
            if (this.argv != null) {
                args.addAll(Arrays.asList(this.argv));
            }
            context.property("process").toObject().property("argv", args);
            String script = "(()=>{  const fs = require('fs'), vm = require('vm');   (new vm.Script(fs.readFileSync('/home/module/" + this.module + "'),      {filename: '" + this.module + "'} )).runInThisContext();})()";
            try {
                context.evaluateScript(script);
            }
            catch (JSException e) {
                Log.e((String)"JSEXCEPTION", (String)("Unhandled exception: " + e.getError().toString()));
                Log.e((String)"JSEXCEPTION", (String)e.getError().stack());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.onProcessFailed(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessAboutToExit(Process process, int exitCode) {
        if (this.exitListener != null) {
            this.exitListener.onExit(this, exitCode);
        }
        this.exitListener = null;
        this.errorListener = null;
        this.emitter = null;
        Object object = serviceMapMutex;
        synchronized (object) {
            for (Map.Entry<String, MicroService> entry : serviceMap.entrySet()) {
                if (entry.getValue() != this) continue;
                serviceMap.remove(entry.getKey());
                process.removeEventListener(this);
                break;
            }
        }
        this.process = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessExit(Process process, int exitCode) {
        if (this.exitListener != null) {
            this.exitListener.onExit(this, exitCode);
        }
        this.exitListener = null;
        this.errorListener = null;
        this.emitter = null;
        Object object = serviceMapMutex;
        synchronized (object) {
            for (Map.Entry<String, MicroService> entry : serviceMap.entrySet()) {
                if (entry.getValue() != this) continue;
                serviceMap.remove(entry.getKey());
                process.removeEventListener(this);
                break;
            }
        }
        this.process = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessFailed(Process process, Exception error) {
        if (this.errorListener != null) {
            this.errorListener.onError(this, error);
        }
        this.exitListener = null;
        this.errorListener = null;
        this.emitter = null;
        Object object = serviceMapMutex;
        synchronized (object) {
            for (Map.Entry<String, MicroService> entry : serviceMap.entrySet()) {
                if (entry.getValue() != this) continue;
                serviceMap.remove(entry.getKey());
                if (process == null) break;
                process.removeEventListener(this);
                break;
            }
        }
        this.process = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MicroService getService(String id) {
        Object object = serviceMapMutex;
        synchronized (object) {
            return serviceMap.get(id);
        }
    }

    public class ServiceAlreadyStartedError
    extends RuntimeException {
    }

    public static interface ServiceErrorListener {
        public void onError(MicroService var1, Exception var2);
    }

    public static interface ServiceExitListener {
        public void onExit(MicroService var1, Integer var2);
    }

    public static interface ServiceStartListener {
        public void onStart(MicroService var1);
    }

    public static interface EventListener {
        public void onEvent(MicroService var1, String var2, JSONObject var3);
    }
}

