/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;

class FileSystem
extends JSObject {
    private final Context androidCtx;
    private final String uniqueID;
    private final String sessionID;
    private static final Object sessionMutex = new Object();
    private static final ArrayList<String> activeSessions = new ArrayList();
    private static final Object lock = new Object();
    private static long lastSessionBark = 0L;
    private static final long SESSION_WATCHDOG_TIMER = 300000L;

    private static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    static void deleteRecursive(File fileOrDirectory) {
        try {
            if (fileOrDirectory.isDirectory() && !FileSystem.isSymlink(fileOrDirectory) && fileOrDirectory.listFiles() != null) {
                for (File child : fileOrDirectory.listFiles()) {
                    FileSystem.deleteRecursive(child);
                }
            }
        }
        catch (IOException e) {
            Log.e((String)"deleteRecursive", (String)e.getMessage());
        }
        if (!fileOrDirectory.delete()) {
            Log.e((String)"deleteRecursive", (String)("Failed to delete " + fileOrDirectory.getAbsolutePath()));
        }
    }

    private void setUp(JSBuilder js, int mediaPermissionsMask) {
        String suffix = "/__org.liquidplayer.node__/_" + this.uniqueID;
        String sessionSuffix = "/__org.liquidplayer.node__/sessions/" + this.sessionID;
        String sessionPath = this.androidCtx.getCacheDir().getAbsolutePath() + sessionSuffix;
        String path = this.androidCtx.getCacheDir().getAbsolutePath() + suffix;
        String localPath = this.androidCtx.getFilesDir().getAbsolutePath() + suffix;
        js.mkdir("/home", sessionPath + "/home", 1);
        if (new File(localPath + "/module").mkdirs()) {
            Log.i((String)"FileSystem", (String)("Created directory " + path + "/module"));
        }
        js.symlink("/home/module", localPath + "/module", sessionPath + "/home/module", 1);
        js.mkdirAndSymlink("/home/temp", sessionPath + "/temp", sessionPath + "/home/temp", 3);
        js.mkdirAndSymlink("/home/cache", path + "/cache", sessionPath + "/home/cache", 3);
        js.mkdirAndSymlink("/home/local", localPath + "/local", sessionPath + "/home/local", 3);
        if (new File(localPath + "/node_modules").mkdirs()) {
            Log.i((String)"FileSystem", (String)("Created directory " + path + "/node_module"));
        }
        js.symlink("/home/node_modules", localPath + "/node_modules", sessionPath + "/home/node_modules", 1);
        String state = Environment.getExternalStorageState();
        if (!("mounted".equals(state) || "mounted_ro".equals(state) || "shared".equals(state))) {
            Log.w((String)"FileSystem", (String)"Warning: external storage is unavailable");
        } else {
            File external;
            if ("mounted_ro".equals(state) && (mediaPermissionsMask & 2) != 0) {
                Log.w((String)"FileSystem", (String)"Warning: external storage is read only.");
                mediaPermissionsMask &= 0xFFFFFFFD;
            }
            if (!new File(sessionPath + "/home/public").mkdirs()) {
                Log.e((String)"FileSystem", (String)"Error: Failed to set up /home/public");
            }
            if ((external = this.androidCtx.getExternalFilesDir(null)) != null) {
                String externalPersistent = external.getAbsolutePath() + "/LiquidPlayer/" + this.uniqueID;
                if (new File(externalPersistent).mkdirs()) {
                    Log.i((String)"FileSystem", (String)("Created external directory " + externalPersistent));
                }
                js.symlink("/home/public/data", externalPersistent, sessionPath + "/home/public/data", 3);
            }
            if (!new File(sessionPath + "/home/public/media").mkdirs()) {
                Log.e((String)"FileSystem", (String)"Error: Failed to set up /home/public/media");
            }
            if ((mediaPermissionsMask & 2) != 0 && ContextCompat.checkSelfPermission((Context)this.androidCtx, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                mediaPermissionsMask &= 0xFFFFFFFD;
            }
            js.linkMedia(Environment.DIRECTORY_MOVIES, "Movies", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_PICTURES, "Pictures", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_DCIM, "DCIM", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_ALARMS, "Alarms", sessionPath + "/home", mediaPermissionsMask);
            if (Build.VERSION.SDK_INT >= 19) {
                js.linkMedia(Environment.DIRECTORY_DOCUMENTS, "Documents", sessionPath + "/home", mediaPermissionsMask);
            }
            js.linkMedia(Environment.DIRECTORY_DOWNLOADS, "Downloads", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_MUSIC, "Music", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_NOTIFICATIONS, "Notifications", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_PODCASTS, "Podcasts", sessionPath + "/home", mediaPermissionsMask);
            js.linkMedia(Environment.DIRECTORY_RINGTONES, "Ringtones", sessionPath + "/home", mediaPermissionsMask);
        }
        js.append("fs_.cwd='/home';");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uninstallSession(Context ctx, String sessionID) {
        Object object = lock;
        synchronized (object) {
            String sessionSuffix = "/__org.liquidplayer.node__/sessions/" + sessionID;
            File session = new File(ctx.getCacheDir().getAbsolutePath() + sessionSuffix);
            Log.i((String)"sessionWatchdog", (String)("deleting session " + session));
            FileSystem.deleteRecursive(session);
        }
    }

    static void uninstallLocal(Context ctx, String serviceID) {
        String suffix = "/__org.liquidplayer.node__/_" + serviceID;
        FileSystem.deleteRecursive(new File(ctx.getCacheDir().getAbsolutePath() + suffix));
        FileSystem.deleteRecursive(new File(ctx.getFilesDir().getAbsolutePath() + suffix));
    }

    static void uninstallGlobal(Context ctx, String serviceID) {
        File external = ctx.getExternalFilesDir(null);
        if (external != null) {
            String externalPersistent = external.getAbsolutePath() + "/LiquidPlayer/" + serviceID;
            FileSystem.deleteRecursive(new File(externalPersistent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileSystem(JSContext ctx, Context androidCtx, String uniqueID, int mediaPermissionsMask) {
        super(ctx);
        this.androidCtx = androidCtx;
        FileSystem.sessionWatchdog(androidCtx);
        this.uniqueID = uniqueID;
        this.sessionID = UUID.randomUUID().toString();
        Object object = sessionMutex;
        synchronized (object) {
            activeSessions.add(this.sessionID);
        }
        JSBuilder js = new JSBuilder();
        js.append("fs_.aliases_={};fs_.access_={};fs_.require=global.require;");
        this.setUp(js, mediaPermissionsMask);
        js.append("fs_.fs=function(file){");
        js.append("if (!file.startsWith('/')) { file = ''+this.cwd+'/'+file; }try { file = fs_.require('path').resolve(file); } catch (e) {console.log(e);}var access = 0;var keys = Object.keys(this.aliases_).sort().reverse();for (var p=0; p<keys.length; p++) {    if (file.startsWith(this.aliases_[keys[p]] + '/')) {        file = keys[p] + '/' + file.substring(this.aliases_[keys[p]].length + 1);        break;    } else if (file == this.aliases_[keys[p]]) {        file = keys[p];        break;    }}var acckeys = Object.keys(this.access_).sort().reverse();for (var p=0; p<acckeys.length; p++) {    if (file.startsWith(acckeys[p] + '/') || acckeys[p]==file) {        access = this.access_[acckeys[p]];        break;    }}var newfile = file;for (var p=0; p<keys.length; p++) {    if (file.startsWith(keys[p] + '/')) {        newfile = this.aliases_[keys[p]] +'/'+file.substring(keys[p].length + 1);        break;    } else if (file == keys[p]) {        newfile = this.aliases_[keys[p]];        break;    }}return [access,newfile];");
        js.append("};");
        js.append("fs_.alias=function(file){");
        js.append("var keys = Object.keys(this.aliases_).sort().reverse();for (var p=0; p<keys.length; p++) {   if (file.startsWith(this.aliases_[keys[p]] + '/')) {       file = keys[p] + '/' + file.substring(this.aliases_[keys[p]].length + 1);       break;   } else if (file == this.aliases_[keys[p]]) {       file = keys[p];       break;   }}return file;");
        js.append("};");
        new JSFunction(ctx, "setup", new String[]{"fs_"}, js.build(), null, 0).call(null, this);
    }

    private static void sessionWatchdog(final Context ctx) {
        String sessionsSuffix = "/__org.liquidplayer.node__/sessions";
        if (new Date().getTime() - lastSessionBark > 300000L) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File sessions = new File(ctx.getCacheDir().getAbsolutePath() + "/__org.liquidplayer.node__/sessions");
                    File[] files = sessions.listFiles();
                    if (files != null) {
                        for (File session : files) {
                            boolean isActive;
                            Object object = sessionMutex;
                            synchronized (object) {
                                isActive = activeSessions.contains(session.getName());
                            }
                            if (isActive) continue;
                            FileSystem.uninstallSession(ctx, session.getName());
                        }
                    }
                    lastSessionBark = new Date().getTime();
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() {
        boolean needClean;
        Object object = sessionMutex;
        synchronized (object) {
            needClean = activeSessions.contains(this.sessionID);
            activeSessions.remove(this.sessionID);
        }
        if (needClean) {
            FileSystem.uninstallSession(this.androidCtx, this.sessionID);
        }
    }

    private class JSBuilder {
        private StringBuilder js = new StringBuilder();

        private JSBuilder() {
        }

        private void realDir(String android) {
            this.js.append("(function(){try {return fs.realpathSync('");
            this.js.append(android);
            this.js.append("');}catch(e){}})()");
        }

        private void alias(String alias, String android, int mask) {
            this.js.append("fs_.aliases_['");
            this.js.append(alias);
            this.js.append("']=");
            this.realDir(android);
            this.js.append(";fs_.access_['");
            this.js.append(alias);
            this.js.append("']=");
            this.js.append(mask);
            this.js.append(";");
        }

        private void mkdir(String alias, String androidp, int mask) {
            if (new File(androidp).mkdirs()) {
                Log.i((String)"mkdir", (String)("Created directory " + androidp));
            }
            this.alias(alias, androidp, mask);
        }

        private void symlink(String alias, String target, String linkpath, int mask) {
            this.js.append("(function(){fs.symlinkSync('");
            this.js.append(target);
            this.js.append("','");
            this.js.append(linkpath);
            this.js.append("');})();");
            this.alias(alias, target, mask);
        }

        private void mkdirAndSymlink(String alias, String target, String linkpath, int mask) {
            if (new File(target).mkdirs()) {
                Log.i((String)"mkdir", (String)("Created directory " + target));
            }
            this.symlink(alias, target, linkpath, mask);
        }

        private void linkMedia(String type, String alias, String linkpath, int mask) {
            File external = Environment.getExternalStoragePublicDirectory((String)type);
            if (external.mkdirs()) {
                Log.i((String)"linkMedia", (String)("Created external directory " + external));
            }
            this.js.append("{var m=");
            this.realDir(external.getAbsolutePath());
            this.js.append(";");
            this.js.append("if(m){");
            this.js.append("(function(){fs.symlinkSync(m,'");
            this.js.append(linkpath);
            this.js.append("/public/media/");
            this.js.append(alias);
            this.js.append("');})();");
            this.js.append("fs_.aliases_['");
            this.js.append("/home/public/media/");
            this.js.append(alias);
            this.js.append("']=m;fs_.access_['");
            this.js.append("/home/public/media/");
            this.js.append(alias);
            this.js.append("']=");
            this.js.append(mask);
            this.js.append(";}}");
        }

        private void append(String s) {
            this.js.append(s);
        }

        private String build() {
            return this.js.toString();
        }
    }
}

