/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;

public class JSRegExp
extends JSObject {
    public JSRegExp(JSContext ctx, String pattern, String flags) {
        this.context = ctx;
        try {
            this.valueRef = this.context.ctxRef().makeRegExp(pattern, flags);
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            this.valueRef = this.context.ctxRef().make();
        }
        this.addJSExports();
    }

    public JSRegExp(JSContext ctx, String pattern) {
        this(ctx, pattern, "");
    }

    public ExecResult exec(String str) {
        JSValue result = this.property("exec").toFunction().call(this, str);
        return result.isNull() != false ? null : new ExecResult(result.toObject());
    }

    public Integer lastIndex() {
        return this.property("lastIndex").toNumber().intValue();
    }

    public Boolean ignoreCase() {
        return this.property("ignoreCase").toBoolean();
    }

    public Boolean global() {
        return this.property("global").toBoolean();
    }

    public Boolean multiline() {
        return this.property("multiline").toBoolean();
    }

    public String source() {
        return this.property("source").toString();
    }

    public Boolean test(String str) {
        return this.property("test").toFunction().call(this, str).toBoolean();
    }

    public class ExecResult
    extends JSArray<String> {
        protected ExecResult(JSObject result) {
            super((JNIJSObject)result.valueRef(), result.getContext(), String.class);
        }

        public Integer index() {
            return this.property("index").toNumber().intValue();
        }

        public String input() {
            return this.property("input").toString();
        }
    }
}

