/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.os.Process;
import java.io.File;
import java.io.IOException;
import org.liquidplayer.javascript.JNIJSContextGroup;
import org.liquidplayer.javascript.JNILoopPreserver;
import org.liquidplayer.javascript.JSContext;

public class JSContextGroup {
    private JNIJSContextGroup group;
    private int mContextGroupThreadTid = 0;
    private boolean hasDedicatedThread = false;

    public JSContextGroup() {
        this.group = JNIJSContextGroup.createGroup();
        this.hasDedicatedThread = false;
    }

    JSContextGroup(JNIJSContextGroup groupRef) {
        this.group = groupRef;
        this.hasDedicatedThread = this.group.isManaged();
    }

    JSContextGroup(long groupRef) {
        this(JNIJSContextGroup.fromRef(groupRef));
    }

    public JSContextGroup(File snapshot) {
        this.group = JNIJSContextGroup.createGroupWithSnapshot(snapshot.getAbsolutePath());
        this.hasDedicatedThread = false;
    }

    public static File createSnapshot(String script, File snapshotToWrite) throws IOException {
        int result = JNIJSContextGroup.createSnapshot(script, snapshotToWrite.getAbsolutePath());
        switch (result) {
            case 0: {
                return snapshotToWrite;
            }
            case -1: {
                throw new IOException("Failed to create snapshot");
            }
            case -2: {
                throw new IOException("Unable to open for writing");
            }
            case -3: {
                throw new IOException("Could not write file");
            }
            case -4: {
                throw new IOException("Could not close file");
            }
        }
        throw new IOException();
    }

    private boolean hasDedicatedThread() {
        return this.hasDedicatedThread;
    }

    public JNIJSContextGroup groupRef() {
        return this.group;
    }

    public long groupHash() {
        return this.group.reference;
    }

    public boolean isOnThread() {
        return !this.hasDedicatedThread() || Process.myTid() == this.mContextGroupThreadTid;
    }

    private void inContextCallback(Runnable runnable) {
        this.mContextGroupThreadTid = Process.myTid();
        runnable.run();
    }

    public void schedule(Runnable runnable) {
        this.group.runInContextGroup(this, runnable);
    }

    public LoopPreserver keepAlive() {
        return new LoopPreserver(this.group.newLoopPreserver());
    }

    public boolean equals(Object other) {
        return other != null && this == other || other instanceof JSContextGroup && this.groupRef() != null && this.groupRef().equals(((JSContextGroup)other).groupRef());
    }

    static {
        JSContext.init();
    }

    public class LoopPreserver {
        private JNILoopPreserver m_reference;

        LoopPreserver(JNILoopPreserver reference) {
            this.m_reference = reference;
        }

        public void release() {
            if (this.m_reference != null) {
                this.m_reference.release();
            }
        }
    }
}

