/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.v4.util.LongSparseArray;
import java.lang.ref.WeakReference;
import org.liquidplayer.javascript.JNIJSBoolean;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSNull;
import org.liquidplayer.javascript.JNIJSNumber;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSUndefined;
import org.liquidplayer.javascript.JNIObject;

class JNIJSValue
extends JNIObject {
    static final long ODDBALL_UNDEFINED = 2L;
    static final long ODDBALL_NULL = 6L;
    static final long ODDBALL_FALSE = 10L;
    static final long ODDBALL_TRUE = 14L;
    private static LongSparseArray<WeakReference<JNIJSValue>> objectsHash = new LongSparseArray();

    protected JNIJSValue(long ref) {
        super(ref);
    }

    static boolean isReferencePrimitiveNumber(long ref) {
        return (ref & 3L) == 0L;
    }

    private static boolean isReferenceJNI(long ref) {
        return (ref & 1L) == 1L;
    }

    static boolean isReferenceObject(long ref) {
        return (ref & 3L) == 3L;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (JNIJSValue.isReferenceJNI(this.reference)) {
            this.Finalize(this.reference);
        }
    }

    public int hashCode() {
        return (int)this.reference;
    }

    boolean isUndefined() {
        return JNIJSValue.isUndefined(this.reference);
    }

    boolean isNull() {
        return JNIJSValue.isNull(this.reference);
    }

    boolean isBoolean() {
        return JNIJSValue.isBoolean(this.reference);
    }

    boolean isNumber() {
        return JNIJSValue.isNumber(this.reference);
    }

    boolean isString() {
        return JNIJSValue.isString(this.reference);
    }

    boolean isObject() {
        return JNIJSValue.isReferenceObject(this.reference);
    }

    boolean isArray() {
        return JNIJSValue.isArray(this.reference);
    }

    boolean isDate() {
        return JNIJSValue.isDate(this.reference);
    }

    boolean isTypedArray() {
        return JNIJSValue.isTypedArray(this.reference);
    }

    boolean isInt8Array() {
        return JNIJSValue.isInt8Array(this.reference);
    }

    boolean isInt16Array() {
        return JNIJSValue.isInt16Array(this.reference);
    }

    boolean isInt32Array() {
        return JNIJSValue.isInt32Array(this.reference);
    }

    boolean isUint8Array() {
        return JNIJSValue.isUint8Array(this.reference);
    }

    boolean isUint8ClampedArray() {
        return JNIJSValue.isUint8ClampedArray(this.reference);
    }

    boolean isUint32Array() {
        return JNIJSValue.isUint32Array(this.reference);
    }

    boolean isUint16Array() {
        return JNIJSValue.isUint16Array(this.reference);
    }

    boolean isFloat32Array() {
        return JNIJSValue.isFloat32Array(this.reference);
    }

    boolean isFloat64Array() {
        return JNIJSValue.isFloat64Array(this.reference);
    }

    boolean isEqual(JNIJSValue b) throws JNIJSException {
        return JNIJSValue.isEqual(this.reference, b.reference);
    }

    boolean isStrictEqual(JNIJSValue b) {
        return JNIJSValue.isStrictEqual(this.reference, b.reference);
    }

    JNIJSValue createJSONString() throws JNIJSException {
        return JNIJSValue.fromRef(JNIJSValue.createJSONString(this.reference));
    }

    boolean toBoolean() {
        return JNIJSValue.toBoolean(this.reference);
    }

    double toNumber() throws JNIJSException {
        return JNIJSValue.toNumber(this.reference);
    }

    String toStringCopy() throws JNIJSException {
        return JNIJSValue.toStringCopy(this.reference);
    }

    JNIJSObject toObject() throws JNIJSException {
        if (this instanceof JNIJSObject) {
            return (JNIJSObject)this;
        }
        return JNIJSObject.fromRef(JNIJSValue.toObject(this.reference));
    }

    static JNIJSValue fromRef(long valueRef) {
        JNIJSValue v;
        if (!JNIJSValue.isReferenceJNI(valueRef)) {
            return valueRef == 10L || valueRef == 14L ? new JNIJSBoolean(valueRef) : (valueRef == 6L ? new JNIJSNull(valueRef) : (valueRef == 2L ? new JNIJSUndefined(valueRef) : new JNIJSNumber(valueRef)));
        }
        WeakReference wr = (WeakReference)objectsHash.get(valueRef);
        if (wr != null && (v = (JNIJSValue)wr.get()) != null) {
            return v;
        }
        v = JNIJSValue.isReferenceObject(valueRef) ? new JNIJSObject(valueRef) : new JNIJSValue(valueRef);
        objectsHash.put(valueRef, new WeakReference<JNIJSValue>(v));
        return v;
    }

    long canonicalReference() {
        return JNIJSValue.canonicalReference(this.reference);
    }

    static native long makeNumber(long var0, double var2);

    static native long makeString(long var0, String var2);

    static native long makeFromJSONString(long var0, String var2);

    private static native boolean isUndefined(long var0);

    private static native boolean isNull(long var0);

    private static native boolean isBoolean(long var0);

    private static native boolean isNumber(long var0);

    private static native boolean isString(long var0);

    private static native boolean isArray(long var0);

    private static native boolean isDate(long var0);

    private static native boolean isTypedArray(long var0);

    private static native boolean isInt8Array(long var0);

    private static native boolean isInt16Array(long var0);

    private static native boolean isInt32Array(long var0);

    private static native boolean isUint8Array(long var0);

    private static native boolean isUint8ClampedArray(long var0);

    private static native boolean isUint32Array(long var0);

    private static native boolean isUint16Array(long var0);

    private static native boolean isFloat32Array(long var0);

    private static native boolean isFloat64Array(long var0);

    private static native boolean isEqual(long var0, long var2) throws JNIJSException;

    private static native boolean isStrictEqual(long var0, long var2);

    private static native long createJSONString(long var0) throws JNIJSException;

    private static native boolean toBoolean(long var0);

    private static native double toNumber(long var0) throws JNIJSException;

    private static native String toStringCopy(long var0) throws JNIJSException;

    private static native long toObject(long var0) throws JNIJSException;

    private static native long canonicalReference(long var0);

    private native void Finalize(long var1);
}

