/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObjectPropertiesMap;
import org.liquidplayer.javascript.JSValue;

public class JSObject
extends JSValue {
    public static final int JSPropertyAttributeNone = 0;
    public static final int JSPropertyAttributeReadOnly = 2;
    public static final int JSPropertyAttributeDontEnum = 4;
    public static final int JSPropertyAttributeDontDelete = 8;
    final List<JSObject> zombies = new ArrayList<JSObject>();
    private JSObject thiz = null;
    private long canon = 0L;
    boolean persisted = false;

    public JSObject(JSContext ctx) {
        this.context = ctx;
        this.valueRef = this.context.ctxRef().make();
        this.addJSExports();
        this.context.persistObject(this);
    }

    void addJSExports() {
        try {
            Method[] methods;
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!f.isAnnotationPresent(jsexport.class)) continue;
                f.setAccessible(true);
                if (!Property.class.isAssignableFrom(f.getType())) continue;
                Property prop = (Property)f.get(this);
                if (prop == null) {
                    Constructor<?> ctor = f.getType().getDeclaredConstructor(JSObject.class);
                    ctor.setAccessible(true);
                    prop = (Property)ctor.newInstance(this);
                    f.set(this, prop);
                }
                prop.setName(f.getName(), f.getAnnotation(jsexport.class).type(), f.getAnnotation(jsexport.class).attributes());
            }
            for (Method m : methods = this.getClass().getDeclaredMethods()) {
                if (!m.isAnnotationPresent(jsexport.class)) continue;
                m.setAccessible(true);
                JSFunction f = new JSFunction(this.context, m, JSObject.class, this);
                this.property(m.getName(), f, m.getAnnotation(jsexport.class).attributes());
            }
        }
        catch (Exception e) {
            this.context.throwJSException(new JSException(this.context, e.toString()));
        }
    }

    public JSObject() {
    }

    protected JSObject(JNIJSObject objRef, JSContext ctx) {
        super(objRef, ctx);
        this.context.persistObject(this);
    }

    public JSObject(JSContext ctx, Class<?> iface) {
        Method[] methods;
        this.context = ctx;
        this.valueRef = this.context.ctxRef().make();
        this.addJSExports();
        for (Method m : methods = iface.getDeclaredMethods()) {
            JSFunction f = new JSFunction(this.context, m, JSObject.class, this);
            this.property(m.getName(), f);
        }
        this.context.persistObject(this);
    }

    public JSObject(JSContext ctx, Map map) {
        this(ctx);
        new JSObjectPropertiesMap<Object>(this, Object.class).putAll(map);
        this.addJSExports();
    }

    public boolean hasProperty(String prop) {
        return this.JNI().hasProperty(prop);
    }

    public JSValue property(String prop) {
        try {
            return new JSValue(this.JNI().getProperty(prop), this.context);
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return new JSValue(this.context);
        }
    }

    public void property(String prop, Object val, int attributes) {
        JNIJSValue ref = val instanceof JSValue ? ((JSValue)val).valueRef() : new JSValue(this.context, val).valueRef();
        try {
            this.JNI().setProperty(prop, ref, attributes);
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
        }
    }

    public void property(String prop, Object value) {
        this.property(prop, value, 0);
    }

    public boolean deleteProperty(String prop) {
        try {
            return this.JNI().deleteProperty(prop);
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return false;
        }
    }

    public JSValue propertyAtIndex(int index) {
        try {
            return new JSValue(this.JNI().getPropertyAtIndex(index), this.context);
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return new JSValue(this.context);
        }
    }

    public void propertyAtIndex(int index, Object val) {
        try {
            this.JNI().setPropertyAtIndex(index, val instanceof JSValue ? ((JSValue)val).valueRef() : new JSValue(this.context, val).valueRef());
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
        }
    }

    public String[] propertyNames() {
        return this.JNI().copyPropertyNames();
    }

    public boolean isFunction() {
        return this.JNI().isFunction();
    }

    public boolean isConstructor() {
        return this.JNI().isConstructor();
    }

    @Override
    public int hashCode() {
        return (int)this.valueRef().reference;
    }

    public JSValue prototype() {
        return new JSValue(this.JNI().getPrototype(), this.context);
    }

    public void prototype(JSValue proto) {
        this.JNI().setPrototype(proto.valueRef());
    }

    protected void finalize() throws Throwable {
        if (this.context != null && this.persisted) {
            this.context.finalizeObject(this);
        }
        super.finalize();
    }

    protected void setThis(JSObject thiz) {
        this.thiz = thiz;
    }

    public JSObject getThis() {
        return this.thiz;
    }

    public JSValue __nullFunc() {
        return new JSValue(this.context);
    }

    protected JNIJSObject JNI() {
        return (JNIJSObject)this.valueRef();
    }

    long canonical() {
        if (this.canon == 0L) {
            this.canon = this.valueRef().canonicalReference();
        }
        return this.canon;
    }

    public class Property<T> {
        private T temp = null;
        private Class pT;
        private Integer attributes = null;
        private String name = null;

        private Property() {
        }

        public void set(T v) {
            this.temp = v;
            if (this.temp != null) {
                this.pT = this.temp.getClass();
            }
            if (this.name != null) {
                if (this.attributes != null) {
                    JSObject.this.property(this.name, v, this.attributes);
                    this.attributes = null;
                } else {
                    JSObject.this.property(this.name, v);
                }
            }
        }

        public T get() {
            if (this.temp == null && this.pT == Object.class) {
                JSObject.this.context.throwJSException(new JSException(JSObject.this.context, "object has no defined type"));
                return null;
            }
            if (this.name != null) {
                return (T)JSObject.this.property(this.name).toJavaObject(this.pT);
            }
            return this.temp;
        }

        private void setName(String n, Class cls, int attributes) {
            this.name = n;
            this.attributes = attributes;
            if (this.temp != null) {
                JSObject.this.property(this.name, this.temp, this.attributes);
                this.attributes = null;
            } else {
                this.pT = cls;
                JSObject.this.property(this.name, new JSValue(JSObject.this.context));
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface jsexport {
        public Class type() default Object.class;

        public int attributes() default 0;
    }
}

