/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.surface.console;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.widget.NestedScrollView;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.liquidplayer.node.R;
import org.liquidplayer.surface.console.AnsiConsoleTextView;

class ConsoleView
extends RelativeLayout
implements AnsiConsoleTextView.Listener {
    protected EditText inputBox;
    protected NestedScrollView scrollView;
    protected ImageButton upHistory;
    protected ImageButton downHistory;
    protected AnsiConsoleTextView consoleTextView;
    private TextView.OnEditorActionListener onEditorAction = new TextView.OnEditorActionListener(){

        public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
            if (actionId == 6) {
                ConsoleView.this.enterCommand();
                return true;
            }
            return false;
        }
    };
    private View.OnKeyListener onKeyListener = new View.OnKeyListener(){

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (event.getAction() == 0 && keyCode == 66) {
                ConsoleView.this.enterCommand();
                return true;
            }
            if (event.getAction() == 0 && keyCode == 19) {
                ConsoleView.this.upHistory();
                return true;
            }
            if (event.getAction() == 0 && keyCode == 20) {
                ConsoleView.this.downHistory();
                return true;
            }
            return false;
        }
    };
    private View.OnClickListener onUpClick = new View.OnClickListener(){

        public void onClick(View view) {
            ConsoleView.this.upHistory();
        }
    };
    private View.OnClickListener onDownClick = new View.OnClickListener(){

        public void onClick(View view) {
            ConsoleView.this.downHistory();
        }
    };
    private ViewTreeObserver.OnGlobalLayoutListener onLayout = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            TextPaint textPaint = ConsoleView.this.consoleTextView.getPaint();
            int width = Math.round(textPaint.measureText("X") * ConsoleView.this.consoleTextView.getTextScaleX());
            int height = Math.round(textPaint.getTextSize() * ConsoleView.this.consoleTextView.getTextScaleX());
            int rows = ConsoleView.this.scrollView.getMeasuredHeight() / height;
            int columns = ConsoleView.this.scrollView.getMeasuredWidth() / width;
            ConsoleView.this.resize(columns, rows);
        }
    };
    private Runnable scrollToBottom = new Runnable(){

        @Override
        public void run() {
            ConsoleView.this.onDisplayUpdated();
        }
    };
    private Handler uiThread = new Handler(Looper.getMainLooper());
    private int item = 0;
    private ArrayList<String> history = new ArrayList();

    public ConsoleView(Context context) {
        this(context, null);
    }

    public ConsoleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ConsoleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater.from((Context)context).inflate(R.layout.console_view, (ViewGroup)this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.loadViews();
    }

    protected void resize(int columns, int rows) {
    }

    protected void processCommand(String command) {
    }

    private void setInputBoxText(final CharSequence text) {
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                ConsoleView.this.inputBox.setText(text);
            }
        });
    }

    private void setConsoleText(final CharSequence text) {
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                ConsoleView.this.consoleTextView.setDisplayText(text);
            }
        });
    }

    public void reset() {
        if (this.getId() != -1) {
            this.history.clear();
            this.item = 0;
            this.setInputBoxText("");
            this.setConsoleText("");
        }
    }

    private void loadViews() {
        this.inputBox = (EditText)this.findViewById(R.id.inputBox);
        this.scrollView = (NestedScrollView)this.findViewById(R.id.scroll);
        this.inputBox.setFocusableInTouchMode(true);
        this.inputBox.requestFocus();
        this.inputBox.setOnEditorActionListener(this.onEditorAction);
        this.inputBox.setOnKeyListener(this.onKeyListener);
        this.inputBox.setEnabled(false);
        this.upHistory = (ImageButton)this.findViewById(R.id.up_history);
        this.downHistory = (ImageButton)this.findViewById(R.id.down_history);
        this.upHistory.setOnClickListener(this.onUpClick);
        this.downHistory.setOnClickListener(this.onDownClick);
        this.setButtonEnabled(this.upHistory, false);
        this.setButtonEnabled(this.downHistory, false);
        ViewTreeObserver vto = this.scrollView.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(this.onLayout);
        this.consoleTextView = (AnsiConsoleTextView)this.findViewById(R.id.console_text);
        this.consoleTextView.addListener(this);
        this.uiThread.post(this.scrollToBottom);
    }

    @Override
    public void onDisplayUpdated() {
        View lastChild = this.scrollView.getChildAt(this.scrollView.getChildCount() - 1);
        int bottom = lastChild.getBottom() + this.scrollView.getPaddingBottom();
        int sy = this.scrollView.getScrollY();
        int sh = this.scrollView.getHeight();
        int delta = bottom - (sy + sh);
        this.scrollView.smoothScrollBy(0, delta);
    }

    protected void setButtonEnabled(ImageButton button, boolean enable) {
        button.setEnabled(enable);
        button.setAlpha(enable ? 1.0f : 0.5f);
        button.setClickable(enable);
    }

    private void upHistory() {
        if (this.upHistory.isEnabled()) {
            --this.item;
            this.setInputBoxText(this.history.get(this.item));
            if (this.item == 0) {
                this.setButtonEnabled(this.upHistory, false);
            }
            this.setButtonEnabled(this.downHistory, true);
            this.inputBox.setSelection(this.inputBox.getText().length());
        }
    }

    private void downHistory() {
        if (this.downHistory.isEnabled()) {
            ++this.item;
            if (this.item >= this.history.size()) {
                this.setButtonEnabled(this.downHistory, false);
                this.setInputBoxText("");
            } else {
                this.setInputBoxText(this.history.get(this.item));
            }
            this.setButtonEnabled(this.upHistory, true);
            this.inputBox.setSelection(this.inputBox.getText().length());
        }
    }

    private void enterCommand() {
        String cmd = this.inputBox.getText().toString();
        this.consoleTextView.println("\u001b[30;1m> " + cmd);
        this.setInputBoxText("");
        this.history.add(cmd);
        this.item = this.history.size();
        this.setButtonEnabled(this.upHistory, true);
        this.setButtonEnabled(this.downHistory, false);
        this.processCommand(cmd);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.textView = this.consoleTextView.getText();
        if (ss.inputBox != null) {
            this.setInputBoxText(ss.inputBox);
        }
        ss.item = this.item;
        ss.history = this.history;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setConsoleText(ss.textView);
        this.inputBox.setText(ss.inputBox);
        this.item = ss.item;
        this.history = new ArrayList(ss.history);
    }

    static class SavedState
    extends View.BaseSavedState {
        private CharSequence textView;
        private CharSequence inputBox;
        private int item;
        private List<String> history;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.textView = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.inputBox = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.item = in.readInt();
            in.readStringList(this.history);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            TextUtils.writeToParcel((CharSequence)this.textView, (Parcel)out, (int)flags);
            TextUtils.writeToParcel((CharSequence)this.inputBox, (Parcel)out, (int)flags);
            out.writeInt(this.item);
            out.writeStringList(this.history);
        }
    }
}

