/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.service;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;
import dalvik.system.DexFile;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;
import org.liquidplayer.node.Process;
import org.liquidplayer.node.R;
import org.liquidplayer.service.MicroService;
import org.liquidplayer.service.Surface;

public class LiquidView
extends RelativeLayout {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static final String createPromiseObject = "(()=>{  var po = {}; var clock = true;  var timer = setInterval(()=>{if(!clock) clearTimeout(timer);}, 100);   po.promise = new Promise((resolve,reject)=>{po.resolve=resolve;po.reject=reject});  po.promise.then(()=>{clock=false}).catch(()=>{clock=false});  return po;})();";
    private ArrayList<MicroService.ServiceStartListener> startListeners = new ArrayList();
    private static ArrayList<MicroService.AvailableSurface> registeredSurfaces = new ArrayList();
    private ArrayList<MicroService.AvailableSurface> surfaces = registeredSurfaces;
    private static HashMap<String, Surface> surfaceHashMap = new HashMap();
    private URI uri;
    private String[] argv;
    private View surfaceView;
    private int surfaceId = -1;
    private ArrayList<String> surfaceNames = null;
    private ArrayList<String> surfaceVersions = null;
    private String serviceId;
    private SparseArray childrenStates;
    private ArrayList<String> boundSurfaces = new ArrayList();
    private String attachedSurface = null;
    private ArrayList<String> boundCanonicalSurfaces = new ArrayList();
    private static boolean isInit = false;

    public LiquidView(Context context) {
        this(context, null);
    }

    public LiquidView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiquidView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LiquidView.registerSurfaces(context);
        this.setSaveEnabled(true);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LiquidView, 0, 0);
        try {
            if (a.hasValue(R.styleable.LiquidView_liquidcore_URI)) {
                String uri_ = a.getString(R.styleable.LiquidView_liquidcore_URI);
                if (uri_ != null && uri_.length() != 0) {
                    this.uri = URI.create(uri_);
                }
            } else if (attrs != null) {
                this.uri = MicroService.DevServer();
            }
            if (a.hasValue(R.styleable.LiquidView_liquidcore_argv)) {
                this.argv = this.getResources().getStringArray(a.getResourceId(R.styleable.LiquidView_liquidcore_argv, 0));
            }
            if (a.hasValue(R.styleable.LiquidView_liquidcore_surface)) {
                String[] surfaces;
                TypedValue v = a.peekValue(R.styleable.LiquidView_liquidcore_surface);
                if (v != null && v.type == 3) {
                    String s = a.getString(R.styleable.LiquidView_liquidcore_surface);
                    surfaces = new String[]{s};
                } else {
                    surfaces = this.getResources().getStringArray(a.getResourceId(R.styleable.LiquidView_liquidcore_surfaces, 0));
                }
                for (String surface : surfaces) {
                    if (surface.startsWith(".")) {
                        surface = "org.liquidplayer.surface" + surface;
                    }
                    this.enableSurface(surface);
                }
            }
        }
        finally {
            a.recycle();
        }
        LayoutInflater.from((Context)context).inflate(R.layout.liquid_view, (ViewGroup)this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.surfaceId == -1 && this.uri != null) {
            this.start(this.uri, this.argv);
            this.uri = null;
        }
    }

    private static int generateViewIdCommon() {
        int newValue;
        int result;
        if (Build.VERSION.SDK_INT >= 17) {
            return LiquidView.generateViewId();
        }
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    private JSObject bind(final JSContext context, String surface_, final JSValue config) {
        final MicroService service = MicroService.getService(this.serviceId);
        final JSObject promiseObj = context.evaluateScript(createPromiseObject).toObject();
        try {
            this.boundCanonicalSurfaces.add(surface_);
            if (service == null) {
                throw new Exception("service not available");
            }
            Log.d((String)"bind", (String)("surface_: " + surface_));
            boolean found = false;
            for (MicroService.AvailableSurface sfc : this.availableSurfaces()) {
                if (!sfc.cls.getCanonicalName().equals(surface_)) continue;
                found = true;
                final Class<? extends Surface> cls = sfc.cls;
                final String boundSurfaceId = UUID.randomUUID().toString();
                final JSObject surfaceObject = new JSObject(context);
                surfaceObject.property("attach", new JSFunction(context, "attach_"){

                    public JSObject attach_() {
                        Surface surface = (Surface)surfaceHashMap.get(boundSurfaceId);
                        return LiquidView.this.attach(this.context, this.getThis(), surface);
                    }
                });
                surfaceObject.property("detach", new JSFunction(context, "detach_"){

                    public JSObject detach_(JSFunction cb) {
                        return LiquidView.this.detach(this.context);
                    }
                });
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Surface s = (Surface)cls.getConstructor(Context.class).newInstance(LiquidView.this.getContext());
                            surfaceHashMap.put(boundSurfaceId, s);
                            LiquidView.this.boundSurfaces.add(boundSurfaceId);
                            s.bind(service, context, surfaceObject, config, new Runnable(){

                                @Override
                                public void run() {
                                    context.getGroup().schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            promiseObj.property("resolve").toFunction().call(null, surfaceObject);
                                        }
                                    });
                                }
                            }, new Surface.ReportErrorRunnable(){

                                @Override
                                public void run(final String errorMessage) {
                                    context.getGroup().schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            promiseObj.property("reject").toFunction().call(null, errorMessage);
                                        }
                                    });
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Log.d((String)"exception", (String)e.toString());
                            context.getGroup().schedule(new Runnable(){

                                @Override
                                public void run() {
                                    promiseObj.property("reject").toFunction().call(null, e.getMessage());
                                }
                            });
                        }
                    }
                });
                break;
            }
            if (!found) {
                throw new Exception("Surface " + surface_ + " is not available.");
            }
        }
        catch (Exception e) {
            Log.d((String)"exception", (String)e.toString());
            promiseObj.property("reject").toFunction().call(null, e.getMessage());
        }
        return promiseObj.property("promise").toObject();
    }

    private JSObject attach(final @Nullable JSContext context, final @Nullable JSObject thiz, final Surface surface) {
        final MicroService service = MicroService.getService(this.serviceId);
        final JSObject promiseObj = context != null ? context.evaluateScript(createPromiseObject).toObject() : null;
        try {
            if (service == null) {
                throw new Exception("service not available");
            }
            Log.d((String)"attach", (String)("surface_: " + surface.getClass().getCanonicalName()));
            if (this.surfaceId == -1) {
                this.surfaceId = LiquidView.generateViewIdCommon();
            }
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            LiquidView.this.surfaceView = surface.attach(service, new Runnable(){

                                @Override
                                public void run() {
                                    LiquidView.this.attachedSurface = null;
                                    for (String s : surfaceHashMap.keySet()) {
                                        if (surfaceHashMap.get(s) != surface) continue;
                                        LiquidView.this.attachedSurface = s;
                                        break;
                                    }
                                    if (promiseObj != null) {
                                        promiseObj.property("resolve").toFunction().call(null, thiz);
                                    }
                                }
                            }, new Surface.ReportErrorRunnable(){

                                @Override
                                public void run(final String errorMessage) {
                                    context.getGroup().schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            promiseObj.property("reject").toFunction().call(null, errorMessage);
                                        }
                                    });
                                }
                            });
                            LiquidView.this.surfaceView.setId(LiquidView.this.surfaceId);
                            ViewGroup parent = (ViewGroup)LiquidView.this.surfaceView.getParent();
                            if (parent != null) {
                                parent.removeView(LiquidView.this.surfaceView);
                            }
                            LiquidView.this.addView(LiquidView.this.surfaceView);
                            if (LiquidView.this.childrenStates != null) {
                                for (int i = 0; i < LiquidView.this.getChildCount(); ++i) {
                                    LiquidView.this.getChildAt(i).restoreHierarchyState(LiquidView.this.childrenStates);
                                }
                                LiquidView.this.childrenStates = null;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Log.d((String)"exception", (String)e.toString());
                            if (promiseObj == null) break block5;
                            promiseObj.property("reject").toFunction().call(null, e.getMessage());
                        }
                    }
                }
            });
            service.getProcess().addEventListener(new Process.EventListener(){

                @Override
                public void onProcessStart(Process process, JSContext context2) {
                }

                @Override
                public void onProcessAboutToExit(Process process, int exitCode) {
                    LiquidView.this.detach(context);
                    process.removeEventListener(this);
                }

                @Override
                public void onProcessExit(Process process, int exitCode) {
                    LiquidView.this.detach(context);
                    process.removeEventListener(this);
                }

                @Override
                public void onProcessFailed(Process process, Exception error) {
                    LiquidView.this.detach(context);
                    process.removeEventListener(this);
                }
            });
        }
        catch (Exception e) {
            Log.d((String)"exception", (String)e.toString());
            if (promiseObj != null) {
                promiseObj.property("reject").toFunction().call(null, e.getMessage());
            }
            this.detach(context);
        }
        if (promiseObj != null) {
            return promiseObj.property("promise").toObject();
        }
        return null;
    }

    private JSObject detach(@Nullable JSContext context) {
        final JSObject promiseObj = context != null ? context.evaluateScript(createPromiseObject).toObject() : null;
        this.surfaceId = -1;
        if (this.attachedSurface != null && this.attachedSurface.length() > 0 && surfaceHashMap.get(this.attachedSurface) != null) {
            String s = this.attachedSurface;
            this.attachedSurface = null;
            surfaceHashMap.get(s).detach();
        }
        if (this.surfaceView != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    LiquidView.this.removeView(LiquidView.this.surfaceView);
                    if (promiseObj != null) {
                        promiseObj.property("resolve").toFunction().call(null, new Object[0]);
                    }
                }
            });
        } else if (promiseObj != null) {
            promiseObj.property("resolve").toFunction().call(null, new Object[0]);
        }
        if (promiseObj != null) {
            return promiseObj.property("promise").toObject();
        }
        return null;
    }

    public void addServiceStartListener(MicroService.ServiceStartListener listener) {
        if (!this.startListeners.contains(listener)) {
            this.startListeners.add(listener);
        }
    }

    public MicroService start(final URI uri, String ... argv) {
        if (this.getId() == -1) {
            this.setId(LiquidView.generateViewIdCommon());
        }
        if (uri != null) {
            if (this.surfaceNames == null) {
                MicroService.AvailableSurface[] surfaces = this.availableSurfaces();
                this.surfaceNames = new ArrayList();
                this.surfaceVersions = new ArrayList();
                for (MicroService.AvailableSurface surface : surfaces) {
                    this.surfaceNames.add(surface.cls.getCanonicalName());
                    this.surfaceVersions.add(surface.version == null ? "0" : surface.version);
                }
            }
            MicroService svc = new MicroService(this.getContext(), uri, new MicroService.ServiceStartListener(){

                @Override
                public void onStart(final MicroService service) {
                    LiquidView.this.serviceId = service.getId();
                    service.getProcess().addEventListener(new Process.EventListener(){

                        @Override
                        public void onProcessStart(Process process, JSContext context) {
                            JSObject liquidCore = context.property("LiquidCore").toObject();
                            JSObject availableSurfaces = new JSObject(context);
                            for (int i = 0; LiquidView.this.surfaceNames != null && LiquidView.this.surfaceVersions != null && i < LiquidView.this.surfaceNames.size(); ++i) {
                                availableSurfaces.property((String)LiquidView.this.surfaceNames.get(i), LiquidView.this.surfaceVersions.get(i));
                            }
                            liquidCore.property("availableSurfaces", availableSurfaces);
                            liquidCore.property("bind", new JSFunction(context, "bind_"){

                                public JSObject bind_(String s, JSValue config) {
                                    return LiquidView.this.bind(this.context, s, config);
                                }
                            });
                            for (MicroService.ServiceStartListener listener : LiquidView.this.startListeners) {
                                listener.onStart(service);
                            }
                            LiquidView.this.startListeners.clear();
                        }

                        @Override
                        public void onProcessAboutToExit(Process process, int exitCode) {
                            process.removeEventListener(this);
                            for (String boundSurface : LiquidView.this.boundSurfaces) {
                                surfaceHashMap.remove(boundSurface);
                            }
                            LiquidView.this.boundSurfaces.clear();
                        }

                        @Override
                        public void onProcessExit(Process process, int exitCode) {
                            process.removeEventListener(this);
                            for (String boundSurface : LiquidView.this.boundSurfaces) {
                                surfaceHashMap.remove(boundSurface);
                            }
                            LiquidView.this.boundSurfaces.clear();
                        }

                        @Override
                        public void onProcessFailed(Process process, Exception error) {
                            process.removeEventListener(this);
                            for (String boundSurface : LiquidView.this.boundSurfaces) {
                                surfaceHashMap.remove(boundSurface);
                            }
                            LiquidView.this.boundSurfaces.clear();
                        }
                    });
                }
            }, new MicroService.ServiceErrorListener(){

                @Override
                public void onError(MicroService service, Exception e) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)LiquidView.this.getContext(), (CharSequence)("Failed to start service at " + uri), (int)1).show();
                        }
                    });
                }
            });
            svc.setAvailableSurfaces(this.availableSurfaces());
            svc.start(argv);
            return svc;
        }
        return null;
    }

    public void enableSurface(String canonicalName) {
        if (this.surfaces == registeredSurfaces) {
            this.surfaces = new ArrayList();
        }
        for (MicroService.AvailableSurface surface : registeredSurfaces) {
            if (!surface.cls.getCanonicalName().equalsIgnoreCase(canonicalName)) continue;
            this.surfaces.add(surface);
            return;
        }
    }

    public static void registerSurface(Class<? extends Surface> cls) {
        try {
            Field f = cls.getDeclaredField("SURFACE_VERSION");
            MicroService.AvailableSurface as = new MicroService.AvailableSurface(cls, f.get(null).toString());
            registeredSurfaces.add(as);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MicroService.AvailableSurface[] availableSurfaces() {
        return this.surfaces.toArray(new MicroService.AvailableSurface[0]);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.surfaceId = this.surfaceId;
        ss.surfaceNames = this.surfaceNames;
        ss.surfaceVersions = this.surfaceVersions;
        ss.serviceId = this.serviceId;
        ss.childrenStates = new SparseArray();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).saveHierarchyState(ss.childrenStates);
        }
        ss.boundSurfaces = this.boundSurfaces;
        ss.attachedSurface = this.attachedSurface;
        ss.boundCanonicalSurfaces = this.boundCanonicalSurfaces;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.surfaceId = ss.surfaceId;
        this.surfaceNames = ss.surfaceNames == null ? new ArrayList() : new ArrayList(ss.surfaceNames);
        if (ss.surfaceVersions == null) {
            ss.surfaceVersions = new ArrayList();
        } else {
            this.surfaceVersions = new ArrayList(ss.surfaceVersions);
        }
        for (String surface : this.surfaceNames) {
            this.enableSurface(surface);
        }
        this.serviceId = ss.serviceId;
        this.childrenStates = ss.childrenStates;
        if (this.attachedSurface != null) {
            Surface s = surfaceHashMap.get(this.attachedSurface);
            this.attach(null, null, s);
        }
        this.boundSurfaces = ss.boundSurfaces == null ? new ArrayList() : new ArrayList(ss.boundSurfaces);
        this.attachedSurface = ss.attachedSurface;
        this.boundCanonicalSurfaces = ss.boundCanonicalSurfaces == null ? new ArrayList() : new ArrayList(ss.boundSurfaces);
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private static String[] getClassesOfPackage(Context context) {
        ArrayList<String> classes = new ArrayList<String>();
        String packageName = "org.liquidplayer.surface";
        try {
            String packageCodePath = context.getPackageCodePath();
            DexFile df = new DexFile(packageCodePath);
            Enumeration iter = df.entries();
            while (iter.hasMoreElements()) {
                String className = (String)iter.nextElement();
                if (!className.contains("org.liquidplayer.surface")) continue;
                classes.add(className);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes.toArray(new String[0]);
    }

    private static void registerSurfaces(Context context) {
        String[] classes;
        if (isInit) {
            return;
        }
        isInit = true;
        for (String cls : classes = LiquidView.getClassesOfPackage(context)) {
            try {
                Class<?> klass = context.getClassLoader().loadClass(cls);
                if (!Surface.class.isAssignableFrom(klass)) continue;
                Class<?> surfaceClass = klass;
                LiquidView.registerSurface(surfaceClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        SparseArray childrenStates;
        private int surfaceId;
        private List<String> surfaceNames;
        private List<String> surfaceVersions;
        private String serviceId;
        private List<String> boundSurfaces;
        private String attachedSurface;
        private List<String> boundCanonicalSurfaces;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return new SavedState(source, loader);
            }

            public SavedState createFromParcel(Parcel source) {
                return this.createFromParcel(source, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in, ClassLoader classLoader) {
            super(in);
            this.surfaceId = in.readInt();
            in.readStringList(this.surfaceNames);
            in.readStringList(this.surfaceVersions);
            this.serviceId = in.readString();
            this.childrenStates = in.readSparseArray(classLoader);
            in.readStringList(this.boundSurfaces);
            this.attachedSurface = in.readString();
            in.readStringList(this.boundCanonicalSurfaces);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.surfaceId);
            out.writeStringList(this.surfaceNames);
            out.writeStringList(this.surfaceVersions);
            out.writeString(this.serviceId);
            out.writeSparseArray(this.childrenStates);
            out.writeStringList(this.boundSurfaces);
            out.writeString(this.attachedSurface);
            out.writeStringList(this.boundCanonicalSurfaces);
        }
    }
}

