/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.liquidplayer.node.FileSystem;
import org.liquidplayer.node.SQLite3Shim;

public class Modules {
    private final Context context;
    private static boolean modules_loaded = false;
    private static final Object mutex = new Object();

    Modules(Context ctx) {
        this.context = ctx;
        SQLite3Shim.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUpNodeModules() {
        Object object = mutex;
        synchronized (object) {
            File path = this.context.getFilesDir();
            String dest_dir_path = path + this.addLeadingSlash("__org.liquidplayer.node__/node_modules");
            File dest_dir = new File(dest_dir_path);
            if (!modules_loaded) {
                File version = new File(dest_dir_path + this.addLeadingSlash(".__version"));
                try {
                    boolean reload = true;
                    if (version.exists()) {
                        BufferedReader br = new BufferedReader(new FileReader(version));
                        String installed_version = br.readLine().trim();
                        br.close();
                        boolean bl = reload = !"0.5.1".equals(installed_version);
                    }
                    if (reload) {
                        if (dest_dir.exists()) {
                            FileSystem.deleteRecursive(dest_dir);
                        }
                        this.copyDirorfileFromAssetManager("node_modules", "node_modules");
                        FileWriter writer = new FileWriter(dest_dir_path + this.addLeadingSlash(".__version"));
                        writer.write("0.5.1");
                        writer.close();
                    }
                    modules_loaded = true;
                }
                catch (IOException e) {
                    Log.e((String)"setUpNodeModules", (String)"Exception", (Throwable)e);
                }
            }
        }
    }

    private void copyDirorfileFromAssetManager(String arg_assetDir, String arg_destinationDir) throws IOException {
        File sd_path = this.context.getFilesDir();
        String dest_dir_path = sd_path + this.addLeadingSlash("__org.liquidplayer.node__") + this.addLeadingSlash(arg_destinationDir);
        File dest_dir = new File(dest_dir_path);
        this.createDir(dest_dir);
        AssetManager asset_manager = this.context.getAssets();
        String[] files = asset_manager.list(arg_assetDir);
        if (files == null) {
            return;
        }
        for (String file : files) {
            String abs_asset_file_path = this.addTrailingSlash(arg_assetDir) + file;
            String[] sub_files = asset_manager.list(abs_asset_file_path);
            if (sub_files == null || sub_files.length == 0) {
                String dest_file_path = this.addTrailingSlash(dest_dir_path) + file;
                this.copyAssetFile(abs_asset_file_path, dest_file_path);
                continue;
            }
            this.copyDirorfileFromAssetManager(abs_asset_file_path, this.addTrailingSlash(arg_destinationDir) + file);
        }
    }

    private void copyAssetFile(String assetFilePath, String destinationFilePath) throws IOException {
        int len;
        Log.i((String)"tag", (String)("Copying " + assetFilePath + " to " + destinationFilePath));
        InputStream in = this.context.getAssets().open(assetFilePath);
        FileOutputStream out = new FileOutputStream(destinationFilePath);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    private String addTrailingSlash(String path) {
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        return path;
    }

    private String addLeadingSlash(String path) {
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        return path;
    }

    private void createDir(File dir) throws IOException {
        Log.i((String)"tag", (String)("Create dir " + dir));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("Can't create directory, a file is in the way");
            }
        } else {
            if (dir.mkdirs()) {
                Log.i((String)"LiquidCore", (String)("Created directory " + dir));
            }
            if (!dir.isDirectory()) {
                throw new IOException("Unable to create directory");
            }
        }
    }
}

