/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSFunction;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;

public class JSFunction
extends JSObject {
    private Class<? extends JSObject> subclass = null;
    protected Method method = null;
    private Class<?>[] pType;
    private JSObject invokeObject = null;

    public JSFunction(JSContext ctx, @NonNull String name, @NonNull String[] parameterNames, @NonNull String body, String sourceURL, int startingLineNumber) {
        this.context = ctx;
        StringBuilder func = new StringBuilder("(function(");
        for (int i = 0; i < parameterNames.length; ++i) {
            func.append(parameterNames[i]);
            if (i >= parameterNames.length - 1) continue;
            func.append(",");
        }
        func.append("){");
        func.append(body);
        func.append("})");
        String function = func.toString();
        try {
            this.valueRef = this.context.ctxRef().makeFunction(name, function, sourceURL == null ? "<anonymous>" : sourceURL, startingLineNumber);
        }
        catch (JNIJSException excp) {
            this.valueRef = this.testException(excp.exception);
        }
        this.addJSExports();
        this.context.persistObject(this);
    }

    public JSFunction(JSContext ctx, @NonNull String name, @NonNull String body, String ... parameterNames) {
        this(ctx, name, parameterNames, body, null, 1);
    }

    private JNIJSObject testException(@NonNull JNIJSValue exception) {
        this.context.throwJSException(new JSException(new JSValue(exception, this.context)));
        return this.context.ctxRef().make();
    }

    public JSFunction(JSContext ctx, Method method, Class<? extends JSObject> instanceClass, JSObject invokeObject) {
        this.context = ctx;
        this.method = method;
        this.method.setAccessible(true);
        this.pType = this.method.getParameterTypes();
        this.invokeObject = invokeObject == null ? this : invokeObject;
        this.valueRef = this.context.ctxRef().makeFunctionWithCallback(this, method.getName());
        this.subclass = instanceClass;
        this.addJSExports();
        this.context.persistObject(this);
        this.context.zombies.add(this);
    }

    public JSFunction(JSContext ctx, Method method, Class<? extends JSObject> instanceClass) {
        this(ctx, method, instanceClass, null);
    }

    public JSFunction(JSContext ctx, Method method) {
        this(ctx, method, JSObject.class);
    }

    public JSFunction(JSContext ctx) {
        this(ctx, (String)null);
    }

    public JSFunction(JSContext ctx, String methodName, Class<? extends JSObject> instanceClass, JSObject invokeObject) {
        Method[] methods;
        this.context = ctx;
        this.invokeObject = invokeObject == null ? this : invokeObject;
        String name = methodName == null ? "__nullFunc" : methodName;
        for (Method method : methods = this.invokeObject.getClass().getMethods()) {
            if (!method.getName().equals(name)) continue;
            this.method = method;
            break;
        }
        if (this.method == null) {
            this.valueRef = this.context.ctxRef().makeUndefined();
            this.context.throwJSException(new JSException(this.context, "No such method. Did you make it public?"));
        } else {
            this.method.setAccessible(true);
            this.pType = this.method.getParameterTypes();
            this.valueRef = this.context.ctxRef().makeFunctionWithCallback(this, this.method.getName());
            this.subclass = instanceClass;
            this.addJSExports();
        }
        this.context.persistObject(this);
        this.context.zombies.add(this);
    }

    public JSFunction(JSContext ctx, String methodName, Class<? extends JSObject> instanceClass) {
        this(ctx, methodName, instanceClass, null);
    }

    public JSFunction(JSContext ctx, String methodName) {
        this(ctx, methodName, JSObject.class);
    }

    public JSFunction(JNIJSObject objRef, JSContext context) {
        super(objRef, context);
    }

    public JSValue call(JSObject thiz, Object ... args) {
        return this.apply(thiz, args);
    }

    private JNIJSValue[] argsToValueRefs(Object[] args) {
        ArrayList<JSArray<Object>> largs = new ArrayList<JSArray<Object>>();
        if (args != null) {
            for (Object o : args) {
                if (o == null) break;
                JSValue v = o.getClass() == Void.class ? new JSArray<Object>(this.context) : (o instanceof JSValue ? (JSValue)o : (o instanceof Object[] ? new JSArray<Object>(this.context, (Object[])o, Object.class) : new JSValue(this.context, o)));
                largs.add((JSArray<Object>)v);
            }
        }
        JNIJSValue[] valueRefs = new JNIJSValue[largs.size()];
        for (int i = 0; i < largs.size(); ++i) {
            valueRefs[i] = ((JSValue)largs.get(i)).valueRef();
        }
        return valueRefs;
    }

    public JSValue apply(JSObject thiz, Object[] args) {
        try {
            return new JSValue(this.JNI().callAsFunction(thiz == null ? null : thiz.JNI(), this.argsToValueRefs(args)), this.context);
        }
        catch (JNIJSException excp) {
            this.context.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return new JSValue(this.context);
        }
    }

    public JSValue call() {
        return this.call(null, new Object[0]);
    }

    public JSObject newInstance(Object ... args) {
        try {
            return this.context.getObjectFromRef(this.JNI().callAsConstructor(this.argsToValueRefs(args)));
        }
        catch (JNIJSException excp) {
            return new JSObject(this.testException(excp.exception), this.context);
        }
    }

    @Keep
    private long functionCallback(long thisObjectRef, long[] argumentsValueRef) {
        long reference = 2L;
        try {
            JSValue[] args = new JSValue[argumentsValueRef.length];
            for (int i = 0; i < argumentsValueRef.length; ++i) {
                JNIJSValue ref = JNIJSValue.fromRef(argumentsValueRef[i]);
                if (ref.isObject()) {
                    try {
                        args[i] = this.context.getObjectFromRef(ref.toObject(), true);
                        continue;
                    }
                    catch (JNIJSException e) {
                        e.printStackTrace();
                        throw new AssertionError();
                    }
                }
                args[i] = new JSValue(ref, this.context);
            }
            JNIJSObject thizRef = !JNIJSValue.isReferenceObject(thisObjectRef) ? null : JNIJSObject.fromRef(thisObjectRef);
            JSObject thiz = thizRef == null ? null : this.context.getObjectFromRef(thizRef);
            JSValue value = this.function(thiz, args, this.invokeObject);
            reference = value == null ? 2L : value.valueRef().reference;
        }
        catch (JSException e) {
            e.printStackTrace();
            JNIJSFunction.setException(this.valueRef().reference, e.getError().valueRef().reference);
        }
        return reference;
    }

    protected JSValue function(JSObject thiz, JSValue[] args) {
        return this.function(thiz, args, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSValue function(JSObject thiz, JSValue[] args, JSObject invokeObject) {
        JSValue returnValue;
        int i;
        Object[] passArgs = new Object[this.pType.length];
        if (this.pType.length > 0 && args.length >= this.pType.length && !args[args.length - 1].isArray().booleanValue() && this.pType[this.pType.length - 1].isArray()) {
            for (i = 0; i < passArgs.length - 1; ++i) {
                if (i < args.length) {
                    if (args[i] == null) {
                        passArgs[i] = null;
                        continue;
                    }
                    passArgs[i] = args[i].toJavaObject(this.pType[i]);
                    continue;
                }
                passArgs[i] = null;
            }
            JSValue[] varArgs = new JSValue[args.length - this.pType.length + 1];
            int varArgsCounter = 0;
            while (i < args.length) {
                varArgs[varArgsCounter++] = args[i];
                ++i;
            }
            passArgs[passArgs.length - 1] = varArgs;
        } else {
            for (i = 0; i < passArgs.length; ++i) {
                if (i < args.length) {
                    if (args[i] == null) {
                        passArgs[i] = null;
                        continue;
                    }
                    passArgs[i] = args[i].toJavaObject(this.pType[i]);
                    continue;
                }
                passArgs[i] = null;
            }
        }
        JSObject stack = null;
        try {
            stack = invokeObject.getThis();
            invokeObject.setThis(thiz);
            Object ret = this.method.invoke((Object)invokeObject, passArgs);
            returnValue = ret == null ? null : (ret instanceof JSValue ? (JSValue)ret : new JSValue(this.context, ret));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.context.throwJSException(new JSException(this.context, e.toString()));
            returnValue = null;
        }
        catch (IllegalAccessException e) {
            this.context.throwJSException(new JSException(this.context, e.toString()));
            returnValue = null;
        }
        finally {
            invokeObject.setThis(stack);
        }
        return returnValue;
    }

    protected void constructor(JNIJSObject thisObj, JSValue[] args) {
        try {
            Constructor<? extends JSObject> defaultConstructor = this.subclass.getConstructor(new Class[0]);
            JSObject thiz = defaultConstructor.newInstance(new Object[0]);
            thiz.context = this.context;
            thiz.valueRef = thisObj;
            thiz.addJSExports();
            this.function(thiz, args);
            this.context.persistObject(thiz);
            this.context.zombies.add(thiz);
        }
        catch (NoSuchMethodException e) {
            String error = e.toString() + "If " + this.subclass.getName() + " is an embedded class, did you specify it as 'static'?";
            this.context.throwJSException(new JSException(this.context, error));
        }
        catch (InvocationTargetException e) {
            String error = e.toString() + "; Did you remember to call super?";
            this.context.throwJSException(new JSException(this.context, error));
        }
        catch (IllegalAccessException e) {
            String error = e.toString() + "; Is your constructor public?";
            this.context.throwJSException(new JSException(this.context, error));
        }
        catch (InstantiationException e) {
            this.context.throwJSException(new JSException(this.context, e.toString()));
        }
    }

    @Keep
    private void constructorCallback(long thisObjectRef, long[] argumentsValueRef) {
        try {
            JSValue[] args = new JSValue[argumentsValueRef.length];
            for (int i = 0; i < argumentsValueRef.length; ++i) {
                JNIJSValue ref = JNIJSValue.fromRef(argumentsValueRef[i]);
                if (ref.isObject()) {
                    try {
                        args[i] = this.context.getObjectFromRef(ref.toObject(), true);
                        continue;
                    }
                    catch (JNIJSException e) {
                        e.printStackTrace();
                        throw new AssertionError();
                    }
                }
                args[i] = new JSValue(ref, this.context);
            }
            this.constructor(JNIJSObject.fromRef(thisObjectRef), args);
        }
        catch (JSException e) {
            JNIJSFunction.setException(this.valueRef().reference, e.getError().valueRef().reference);
        }
    }

    protected JSFunction() {
    }
}

