/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import android.util.LongSparseArray;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import org.liquidplayer.javascript.JNIJSContext;
import org.liquidplayer.javascript.JNIJSContextGroup;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSTypedArray;
import org.liquidplayer.javascript.JSValue;

public class JSContext
extends JSObject {
    private JSContextGroup contextGroup = null;
    private JNIJSContext ctxRef;
    private IJSExceptionHandler exceptionHandler;
    private final LongSparseArray<WeakReference<JSObject>> objects = new LongSparseArray();

    static void init() {
    }

    public void sync(final Runnable runnable) {
        if (this.isOnThread()) {
            runnable.run();
        } else {
            final Semaphore sempahore = new Semaphore(0);
            Runnable syncRunner = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    sempahore.release();
                }
            };
            this.getGroup().schedule(syncRunner);
            sempahore.acquireUninterruptibly();
        }
    }

    private boolean isOnThread() {
        return this.ctxRef == null || this.getGroup().isOnThread();
    }

    public long getJSCContext() {
        return 0L;
    }

    protected JSContext(long ctxHandle, JSContextGroup group) {
        this.context = this;
        this.contextGroup = group;
        this.ctxRef = JNIJSContext.fromRef(ctxHandle);
        this.valueRef = this.ctxRef.getGlobalObject();
        this.addJSExports();
    }

    public JSContext() {
        this(new JSContextGroup());
    }

    public JSContext(JSContextGroup inGroup) {
        this.context = this;
        this.contextGroup = inGroup;
        this.ctxRef = JNIJSContext.createContext(inGroup.groupRef());
        this.valueRef = this.ctxRef.getGlobalObject();
        this.addJSExports();
    }

    public JSContext(Class<?> iface) {
        this(new JSContextGroup(), iface);
    }

    public JSContext(JSContextGroup inGroup, Class<?> iface) {
        this(inGroup);
        Method[] methods;
        for (Method m : methods = iface.getDeclaredMethods()) {
            JSFunction f = new JSFunction(this.context, m, JSObject.class, (JSObject)this.context);
            this.property(m.getName(), f);
        }
    }

    public void setExceptionHandler(IJSExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public void clearExceptionHandler() {
        this.exceptionHandler = null;
    }

    public void throwJSException(JSException exception) {
        if (this.exceptionHandler == null) {
            throw exception;
        }
        IJSExceptionHandler temp = this.exceptionHandler;
        this.exceptionHandler = null;
        temp.handle(exception);
        this.exceptionHandler = temp;
    }

    public JSContextGroup getGroup() {
        if (this.contextGroup == null) {
            JNIJSContextGroup g = this.ctxRef.getGroup();
            if (g == null) {
                return null;
            }
            this.contextGroup = new JSContextGroup(g);
        }
        return this.contextGroup;
    }

    public JNIJSContext ctxRef() {
        return this.ctxRef;
    }

    public JSValue evaluateScript(@NonNull String script, String sourceURL, int startingLineNumber) {
        String src = sourceURL == null ? "<code>" : sourceURL;
        try {
            return new JSValue(this.ctxRef.evaluateScript(script, src, startingLineNumber), this.context);
        }
        catch (JNIJSException excp) {
            this.throwJSException(new JSException(new JSValue(excp.exception, this.context)));
            return new JSValue(this);
        }
    }

    public JSValue evaluateScript(String script) {
        return this.evaluateScript(script, null, 0);
    }

    void persistObject(JSObject obj) {
        this.objects.put(obj.canonical(), new WeakReference<JSObject>(obj));
        obj.persisted = true;
    }

    void finalizeObject(JSObject obj) {
        this.objects.remove(obj.canonical());
    }

    JSObject getObjectFromRef(JNIJSObject objRef, boolean create) {
        if (objRef.equals(this.valueRef())) {
            return this;
        }
        WeakReference wr = (WeakReference)this.objects.get(objRef.canonicalReference());
        JSObject obj = null;
        if (wr != null) {
            obj = (JSArray)wr.get();
        }
        if (obj == null && create) {
            obj = new JSObject(objRef, this);
            if (obj.isArray().booleanValue()) {
                obj = new JSArray(objRef, this);
            } else if (obj.isTypedArray().booleanValue()) {
                obj = JSTypedArray.from(obj);
            } else if (obj.isFunction()) {
                obj = new JSFunction(objRef, this);
            }
        }
        return obj;
    }

    JSObject getObjectFromRef(JNIJSObject objRef) {
        return this.getObjectFromRef(objRef, true);
    }

    static {
        System.loadLibrary("node");
        System.loadLibrary("liquidcore");
    }

    public static interface IJSExceptionHandler {
        public void handle(JSException var1);
    }
}

