/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSValue;

class JNIJSObject
extends JNIJSValue {
    protected JNIJSObject(long ref) {
        super(ref);
    }

    JNIJSValue getPrototype() {
        return JNIJSValue.fromRef(JNIJSObject.getPrototype(this.reference));
    }

    void setPrototype(@NonNull JNIJSValue value) {
        JNIJSObject.setPrototype(this.reference, value.reference);
    }

    boolean hasProperty(String propertyName) {
        return JNIJSObject.hasProperty(this.reference, propertyName);
    }

    JNIJSValue getProperty(String propertyName) throws JNIJSException {
        return JNIJSValue.fromRef(JNIJSObject.getProperty(this.reference, propertyName));
    }

    void setProperty(String propertyName, JNIJSValue value, int attributes) throws JNIJSException {
        JNIJSObject.setProperty(this.reference, propertyName, value.reference, attributes);
    }

    boolean deleteProperty(String propertyName) throws JNIJSException {
        return JNIJSObject.deleteProperty(this.reference, propertyName);
    }

    JNIJSValue getPropertyAtIndex(int propertyIndex) throws JNIJSException {
        return JNIJSValue.fromRef(JNIJSObject.getPropertyAtIndex(this.reference, propertyIndex));
    }

    void setPropertyAtIndex(int propertyIndex, JNIJSValue value) throws JNIJSException {
        JNIJSObject.setPropertyAtIndex(this.reference, propertyIndex, value.reference);
    }

    boolean isFunction() {
        return JNIJSObject.isFunction(this.reference);
    }

    JNIJSValue callAsFunction(JNIJSObject thisObject, JNIJSValue[] args) throws JNIJSException {
        long[] args_ = new long[args.length];
        for (int i = 0; i < args.length; ++i) {
            args_[i] = args[i].reference;
        }
        return JNIJSValue.fromRef(JNIJSObject.callAsFunction(this.reference, thisObject == null ? 0L : thisObject.reference, args_));
    }

    boolean isConstructor() {
        return JNIJSObject.isConstructor(this.reference);
    }

    JNIJSObject callAsConstructor(JNIJSValue[] args) throws JNIJSException {
        long[] args_ = new long[args.length];
        for (int i = 0; i < args.length; ++i) {
            args_[i] = args[i].reference;
        }
        return JNIJSObject.fromRef(JNIJSObject.callAsConstructor(this.reference, args_));
    }

    String[] copyPropertyNames() {
        return JNIJSObject.copyPropertyNames(this.reference);
    }

    static JNIJSObject fromRef(long valueRef) {
        return (JNIJSObject)JNIJSValue.fromRef(valueRef);
    }

    static native long make(long var0);

    static native long makeArray(long var0, long[] var2) throws JNIJSException;

    static native long makeDate(long var0, long[] var2);

    static native long makeError(long var0, String var2);

    static native long makeRegExp(long var0, String var2, String var3) throws JNIJSException;

    static native long makeFunction(long var0, String var2, String var3, String var4, int var5) throws JNIJSException;

    static native boolean isFunction(long var0);

    private static native long getPrototype(long var0);

    private static native void setPrototype(long var0, long var2);

    private static native boolean hasProperty(long var0, String var2);

    private static native long getProperty(long var0, String var2) throws JNIJSException;

    private static native void setProperty(long var0, String var2, long var3, int var5) throws JNIJSException;

    private static native boolean deleteProperty(long var0, String var2) throws JNIJSException;

    private static native long getPropertyAtIndex(long var0, int var2) throws JNIJSException;

    private static native void setPropertyAtIndex(long var0, int var2, long var3) throws JNIJSException;

    private static native long callAsFunction(long var0, long var2, long[] var4) throws JNIJSException;

    private static native boolean isConstructor(long var0);

    private static native long callAsConstructor(long var0, long[] var2) throws JNIJSException;

    private static native String[] copyPropertyNames(long var0);
}

