/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import org.liquidplayer.javascript.JNIJSContextGroup;
import org.liquidplayer.javascript.JNIJSException;
import org.liquidplayer.javascript.JNIJSFunction;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JNIObject;
import org.liquidplayer.javascript.JSFunction;

class JNIJSContext
extends JNIObject {
    private JNIJSContext(long ref) {
        super(ref);
    }

    public void finalize() throws Throwable {
        super.finalize();
        JNIJSContext.Finalize(this.reference);
    }

    @NonNull
    static JNIJSContext createContext(JNIJSContextGroup group) {
        return JNIJSContext.fromRef(JNIJSContext.createInGroup(group.reference));
    }

    JNIJSContextGroup getGroup() {
        return JNIJSContextGroup.fromRef(JNIJSContext.getGroup(this.reference));
    }

    JNIJSObject getGlobalObject() {
        return JNIJSObject.fromRef(JNIJSContext.getGlobalObject(this.reference));
    }

    JNIJSValue makeUndefined() {
        return JNIJSValue.fromRef(2L);
    }

    JNIJSValue makeNull() {
        return JNIJSValue.fromRef(6L);
    }

    JNIJSValue makeBoolean(boolean bool) {
        return JNIJSValue.fromRef(bool ? 14L : 10L);
    }

    JNIJSValue makeNumber(double number) {
        long ref = Double.doubleToLongBits(number);
        if (!JNIJSValue.isReferencePrimitiveNumber(ref)) {
            ref = JNIJSValue.makeNumber(this.reference, number);
        }
        return JNIJSValue.fromRef(ref);
    }

    JNIJSValue makeString(String string) {
        return JNIJSValue.fromRef(JNIJSValue.makeString(this.reference, string));
    }

    JNIJSValue makeFromJSONString(String string) {
        return JNIJSValue.fromRef(JNIJSValue.makeFromJSONString(this.reference, string));
    }

    JNIJSObject make() {
        return JNIJSObject.fromRef(JNIJSObject.make(this.reference));
    }

    JNIJSObject makeArray(JNIJSValue[] args) throws JNIJSException {
        long[] args_ = new long[args.length];
        for (int i = 0; i < args.length; ++i) {
            args_[i] = args[i].reference;
        }
        return JNIJSObject.fromRef(JNIJSObject.makeArray(this.reference, args_));
    }

    JNIJSObject makeDate(long[] args) {
        return JNIJSObject.fromRef(JNIJSObject.makeDate(this.reference, args));
    }

    JNIJSObject makeError(String message) {
        return JNIJSObject.fromRef(JNIJSObject.makeError(this.reference, message));
    }

    JNIJSObject makeRegExp(String pattern, String flags) throws JNIJSException {
        return JNIJSObject.fromRef(JNIJSObject.makeRegExp(this.reference, pattern, flags));
    }

    JNIJSObject makeFunction(@NonNull String name, @NonNull String func, @NonNull String sourceURL, int startingLineNumber) throws JNIJSException {
        return JNIJSFunction.fromRef(JNIJSObject.makeFunction(this.reference, name, func, sourceURL, startingLineNumber));
    }

    JNIJSObject makeFunctionWithCallback(JSFunction thiz, String name) {
        return JNIJSFunction.fromRef(JNIJSFunction.makeFunctionWithCallback(thiz, this.reference, name));
    }

    JNIJSValue evaluateScript(String script, String sourceURL, int startingLineNumber) throws JNIJSException {
        return JNIJSValue.fromRef(JNIJSContext.evaluateScript(this.reference, script, sourceURL, startingLineNumber));
    }

    @NonNull
    static JNIJSContext fromRef(long ctxRef) {
        return new JNIJSContext(ctxRef);
    }

    private static native long createInGroup(long var0);

    private static native long getGroup(long var0);

    private static native long getGlobalObject(long var0);

    private static native long evaluateScript(long var0, String var2, String var3, int var4) throws JNIJSException;

    private static native void Finalize(long var0);
}

