/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.service;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.node.Process;
import org.liquidplayer.node.R;
import org.liquidplayer.service.MicroService;
import org.liquidplayer.service.Surface;
import org.liquidplayer.service.Synchronizer;

public class LiquidView
extends RelativeLayout {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private ArrayList<MicroService.ServiceStartListener> startListeners = new ArrayList();
    private ArrayList<MicroService.AvailableSurface> surfaces = new ArrayList();
    private static HashMap<String, Surface> surfaceHashMap = new HashMap();
    private URI uri;
    private String[] argv;
    private View surfaceView;
    private int surfaceId = -1;
    private ArrayList<String> surfaceNames = null;
    private ArrayList<String> surfaceVersions = null;
    private String serviceId;
    private String canonicalSurface;
    private SparseArray childrenStates;
    private ArrayList<String> boundSurfaces = new ArrayList();
    private String attachedSurface = null;

    public LiquidView(Context context) {
        this(context, null);
    }

    public LiquidView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiquidView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setSaveEnabled(true);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LiquidView, 0, 0);
        try {
            String uri_;
            if (a.hasValue(R.styleable.LiquidView_liquidcore_URI) && (uri_ = a.getString(R.styleable.LiquidView_liquidcore_URI)) != null) {
                this.uri = URI.create(uri_);
            }
            if (a.hasValue(R.styleable.LiquidView_liquidcore_argv)) {
                this.argv = this.getResources().getStringArray(a.getResourceId(R.styleable.LiquidView_liquidcore_argv, 0));
            }
            if (a.hasValue(R.styleable.LiquidView_liquidcore_surface)) {
                String[] surfaces;
                TypedValue v = a.peekValue(R.styleable.LiquidView_liquidcore_surface);
                if (v != null && v.type == 3) {
                    String s = a.getString(R.styleable.LiquidView_liquidcore_surface);
                    surfaces = new String[]{s};
                } else {
                    surfaces = this.getResources().getStringArray(a.getResourceId(R.styleable.LiquidView_liquidcore_surfaces, 0));
                }
                for (String surface : surfaces) {
                    if (surface.startsWith(".")) {
                        surface = "org.liquidplayer.surface" + surface;
                    }
                    try {
                        this.enableSurface(((Object)((Object)this)).getClass().getClassLoader().loadClass(surface));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            a.recycle();
        }
        LayoutInflater.from((Context)context).inflate(R.layout.liquid_view, (ViewGroup)this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.surfaceId == -1 && this.uri != null) {
            this.start(this.uri, this.argv);
            this.uri = null;
        }
    }

    private static int generateViewIdCommon() {
        int newValue;
        int result;
        if (Build.VERSION.SDK_INT >= 17) {
            return LiquidView.generateViewId();
        }
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    private void attach(String surface_, final JSFunction callback) {
        final LiquidViewService service = (LiquidViewService)MicroService.getService(this.serviceId);
        try {
            Surface surface = null;
            if (service == null) {
                throw new Exception("service not available");
            }
            Log.d((String)"attach", (String)("surface_: " + surface_));
            for (Map.Entry<String, Surface> entry : surfaceHashMap.entrySet()) {
                Log.d((String)"attach", (String)("canon: " + entry.getValue().getClass().getCanonicalName()));
                if (!entry.getValue().getClass().getCanonicalName().equals(surface_)) continue;
                surface = entry.getValue();
                break;
            }
            if (surface == null) {
                throw new Exception("Invalid surface");
            }
            if (this.surfaceId == -1) {
                this.surfaceId = LiquidView.generateViewIdCommon();
            }
            this.canonicalSurface = surface_;
            final Surface s = surface;
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        LiquidView.this.surfaceView = s.attach(service, new Runnable(){

                            @Override
                            public void run() {
                                if (callback != null) {
                                    callback.call(null, new Object[0]);
                                }
                            }
                        });
                        LiquidView.this.surfaceView.setId(LiquidView.this.surfaceId);
                        ViewGroup parent = (ViewGroup)LiquidView.this.surfaceView.getParent();
                        if (parent != null) {
                            parent.removeView(LiquidView.this.surfaceView);
                        }
                        LiquidView.this.addView(LiquidView.this.surfaceView);
                        if (LiquidView.this.childrenStates != null) {
                            for (int i = 0; i < LiquidView.this.getChildCount(); ++i) {
                                LiquidView.this.getChildAt(i).restoreHierarchyState(LiquidView.this.childrenStates);
                            }
                            LiquidView.this.childrenStates = null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Log.d((String)"exception", (String)e.toString());
                        service.m_preserver.release();
                    }
                }
            });
            service.getProcess().addEventListener(new Process.EventListener(){

                @Override
                public void onProcessStart(Process process, JSContext context) {
                }

                @Override
                public void onProcessAboutToExit(Process process, int exitCode) {
                    LiquidView.this.detach(null);
                    process.removeEventListener(this);
                }

                @Override
                public void onProcessExit(Process process, int exitCode) {
                    LiquidView.this.detach(null);
                    process.removeEventListener(this);
                }

                @Override
                public void onProcessFailed(Process process, Exception error) {
                    LiquidView.this.detach(null);
                    process.removeEventListener(this);
                }
            });
        }
        catch (Exception e) {
            Log.d((String)"exception", (String)e.toString());
            if (callback != null) {
                callback.call(null, e.getMessage());
            }
            this.detach(null);
        }
    }

    private void detach(JSFunction callback) {
        this.surfaceId = -1;
        this.canonicalSurface = null;
        if (this.attachedSurface != null) {
            surfaceHashMap.get(this.attachedSurface).detach();
            this.attachedSurface = null;
        }
        if (this.surfaceView != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    LiquidView.this.removeView(LiquidView.this.surfaceView);
                    LiquidView.this.surfaceView = null;
                }
            });
        }
        if (callback != null) {
            callback.call();
        }
    }

    public void addServiceStartListener(MicroService.ServiceStartListener listener) {
        if (!this.startListeners.contains(listener)) {
            this.startListeners.add(listener);
        }
    }

    public MicroService start(final URI uri, String ... argv) {
        if (this.getId() == -1) {
            this.setId(LiquidView.generateViewIdCommon());
        }
        if (uri != null) {
            if (this.surfaceNames == null) {
                MicroService.AvailableSurface[] surfaces = this.availableSurfaces();
                this.surfaceNames = new ArrayList();
                this.surfaceVersions = new ArrayList();
                for (MicroService.AvailableSurface surface : surfaces) {
                    this.surfaceNames.add(surface.cls.getCanonicalName());
                    this.surfaceVersions.add(surface.version == null ? "0" : surface.version);
                }
            }
            LiquidViewService svc = new LiquidViewService(this.getContext(), uri, new MicroService.ServiceStartListener(){

                @Override
                public void onStart(final MicroService service, final Synchronizer synchronizer) {
                    LiquidView.this.serviceId = service.getId();
                    service.getProcess().addEventListener(new Process.EventListener(){

                        @Override
                        public void onProcessStart(Process process, final JSContext context) {
                            JSObject liquidCore = context.property("LiquidCore").toObject();
                            JSObject availableSurfaces = new JSObject(context);
                            for (int i = 0; LiquidView.this.surfaceNames != null && LiquidView.this.surfaceVersions != null && i < LiquidView.this.surfaceNames.size(); ++i) {
                                availableSurfaces.property((String)LiquidView.this.surfaceNames.get(i), LiquidView.this.surfaceVersions.get(i));
                            }
                            liquidCore.property("availableSurfaces", availableSurfaces);
                            liquidCore.property("attach", new JSFunction(context, "attach_"){

                                public void attach_(String s, JSFunction cb) {
                                    LiquidView.this.attach(s, cb);
                                }
                            });
                            liquidCore.property("detach", new JSFunction(context, "detach_"){

                                public void detach_(JSFunction cb) {
                                    LiquidView.this.detach(cb);
                                }
                            });
                            ((LiquidViewService)service).m_preserver = service.getProcess().keepAlive();
                            for (MicroService.AvailableSurface sfc : LiquidView.this.availableSurfaces()) {
                                synchronizer.enter();
                                final Class<? extends Surface> cls = sfc.cls;
                                final String boundSurfaceId = UUID.randomUUID().toString();
                                new Handler(Looper.getMainLooper()).post(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Surface s = (Surface)cls.getConstructor(Context.class).newInstance(LiquidView.this.getContext());
                                            surfaceHashMap.put(boundSurfaceId, s);
                                            LiquidView.this.boundSurfaces.add(boundSurfaceId);
                                            s.bind(service, context, synchronizer);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            Log.d((String)"exception", (String)e.toString());
                                            ((LiquidViewService)service).m_preserver.release();
                                        }
                                        finally {
                                            synchronizer.exit();
                                        }
                                    }
                                });
                            }
                            for (MicroService.ServiceStartListener listener : LiquidView.this.startListeners) {
                                listener.onStart(service, synchronizer);
                            }
                            LiquidView.this.startListeners.clear();
                        }

                        @Override
                        public void onProcessAboutToExit(Process process, int exitCode) {
                            process.removeEventListener(this);
                            for (String boundSurface : LiquidView.this.boundSurfaces) {
                                surfaceHashMap.remove(boundSurface);
                            }
                            LiquidView.this.boundSurfaces.clear();
                        }

                        @Override
                        public void onProcessExit(Process process, int exitCode) {
                            process.removeEventListener(this);
                            for (String boundSurface : LiquidView.this.boundSurfaces) {
                                surfaceHashMap.remove(boundSurface);
                            }
                            LiquidView.this.boundSurfaces.clear();
                        }

                        @Override
                        public void onProcessFailed(Process process, Exception error) {
                            process.removeEventListener(this);
                            for (String boundSurface : LiquidView.this.boundSurfaces) {
                                surfaceHashMap.remove(boundSurface);
                            }
                            LiquidView.this.boundSurfaces.clear();
                        }
                    });
                }
            }, new MicroService.ServiceErrorListener(){

                @Override
                public void onError(MicroService service, Exception e) {
                    LiquidView.this.detach(null);
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)LiquidView.this.getContext(), (CharSequence)("Failed to start service at " + uri), (int)1).show();
                        }
                    });
                }
            });
            svc.setAvailableSurfaces(this.availableSurfaces());
            svc.start(argv);
            return svc;
        }
        return null;
    }

    public void enableSurface(Class<? extends Surface> cls) {
        try {
            Field f = cls.getDeclaredField("SURFACE_VERSION");
            MicroService.AvailableSurface as = new MicroService.AvailableSurface(cls, f.get(null).toString());
            this.surfaces.add(as);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MicroService.AvailableSurface[] availableSurfaces() {
        return this.surfaces.toArray(new MicroService.AvailableSurface[this.surfaces.size()]);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.surfaceId = this.surfaceId;
        ss.surfaceNames = this.surfaceNames;
        ss.surfaceVersions = this.surfaceVersions;
        ss.serviceId = this.serviceId;
        ss.canonicalSurface = this.canonicalSurface;
        ss.childrenStates = new SparseArray();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).saveHierarchyState(ss.childrenStates);
        }
        ss.boundSurfaces = this.boundSurfaces;
        ss.attachedSurface = this.attachedSurface;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.surfaceId = ss.surfaceId;
        this.surfaceNames = ss.surfaceNames == null ? new ArrayList() : new ArrayList(ss.surfaceNames);
        if (ss.surfaceVersions == null) {
            ss.surfaceVersions = new ArrayList();
        } else {
            this.surfaceVersions = new ArrayList(ss.surfaceVersions);
        }
        for (String surface : this.surfaceNames) {
            try {
                this.enableSurface(((Object)((Object)this)).getClass().getClassLoader().loadClass(surface));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.serviceId = ss.serviceId;
        this.canonicalSurface = ss.canonicalSurface;
        this.childrenStates = ss.childrenStates;
        if (this.canonicalSurface != null) {
            this.attach(this.canonicalSurface, null);
        }
        this.boundSurfaces = ss.boundSurfaces == null ? new ArrayList() : new ArrayList(ss.boundSurfaces);
        this.attachedSurface = ss.attachedSurface;
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    static class SavedState
    extends View.BaseSavedState {
        SparseArray childrenStates;
        private int surfaceId;
        private List<String> surfaceNames;
        private List<String> surfaceVersions;
        private String serviceId;
        private String canonicalSurface;
        private List<String> boundSurfaces;
        private String attachedSurface;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return new SavedState(source, loader);
            }

            public SavedState createFromParcel(Parcel source) {
                return this.createFromParcel(source, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in, ClassLoader classLoader) {
            super(in);
            this.surfaceId = in.readInt();
            in.readStringList(this.surfaceNames);
            in.readStringList(this.surfaceVersions);
            this.serviceId = in.readString();
            this.canonicalSurface = in.readString();
            this.childrenStates = in.readSparseArray(classLoader);
            in.readStringList(this.boundSurfaces);
            this.attachedSurface = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.surfaceId);
            out.writeStringList(this.surfaceNames);
            out.writeStringList(this.surfaceVersions);
            out.writeString(this.serviceId);
            out.writeString(this.canonicalSurface);
            out.writeSparseArray(this.childrenStates);
            out.writeStringList(this.boundSurfaces);
            out.writeString(this.attachedSurface);
        }
    }

    private static class LiquidViewService
    extends MicroService {
        JSContextGroup.LoopPreserver m_preserver;

        LiquidViewService(Context ctx, URI serviceURI, MicroService.ServiceStartListener start, MicroService.ServiceErrorListener error) {
            super(ctx, serviceURI, start, error);
        }
    }
}

