/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDatatypeMismatchException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteOutOfMemoryException;
import android.database.sqlite.SQLiteReadOnlyDatabaseException;
import android.database.sqlite.SQLiteTableLockedException;
import org.liquidplayer.node.SQLite3Database;

class SQLite3Shim {
    private static SQLite3Shim sShim;

    private native void initNative();

    private SQLite3Shim() {
        this.initNative();
    }

    static void init() {
        if (sShim == null) {
            sShim = new SQLite3Shim();
        }
    }

    JNIReturnObject sqlite3_open_v2(String path, int flags, String jVFS) {
        try {
            SQLite3Database db = new SQLite3Database(path, flags, jVFS);
            return new JNIReturnObject(db);
        }
        catch (SQLiteException exception) {
            return new JNIReturnObject(exception);
        }
    }

    static enum CODES {
        SQLITE_OK("SQLITE_OK", 0, null),
        SQLITE_ERROR("SQLITE_ERROR", 1, SQLiteException.class),
        SQLITE_INTERNAL("SQLITE_INTERNAL", 2, null),
        SQLITE_PERM("SQLITE_PERM", 3, SQLiteAccessPermException.class),
        SQLITE_ABORT("SQLITE_ABORT", 4, SQLiteAbortException.class),
        SQLITE_BUSY("SQLITE_BUSY", 5, SQLiteDatabaseLockedException.class),
        SQLITE_LOCKED("SQLITE_LOCKED", 6, SQLiteTableLockedException.class),
        SQLITE_NOMEM("SQLITE_NOMEM", 7, SQLiteOutOfMemoryException.class),
        SQLITE_READONLY("SQLITE_READONLY", 8, SQLiteReadOnlyDatabaseException.class),
        SQLITE_INTERRUPT("SQLITE_INTERRUPT", 9, null),
        SQLITE_IOERR("SQLITE_IOERR", 10, SQLiteDiskIOException.class),
        SQLITE_CORRUPT("SQLITE_CORRUPT", 11, SQLiteDatabaseCorruptException.class),
        SQLITE_NOTFOUND("SQLITE_NOTFOUND", 12, null),
        SQLITE_FULL("SQLITE_FULL", 13, SQLiteFullException.class),
        SQLITE_CANTOPEN("SQLITE_CANTOPEN", 14, SQLiteCantOpenDatabaseException.class),
        SQLITE_PROTOCOL("SQLITE_PROTOCOL", 15, null),
        SQLITE_EMPTY("SQLITE_EMPTY", 16, null),
        SQLITE_SCHEMA("SQLITE_SCHEMA", 17, null),
        SQLITE_TOOBIG("SQLITE_TOOBIG", 18, SQLiteBlobTooBigException.class),
        SQLITE_CONSTRAINT("SQLITE_CONSTRAINT", 19, SQLiteConstraintException.class),
        SQLITE_MISMATCH("SQLITE_MISMATCH", 20, SQLiteDatatypeMismatchException.class),
        SQLITE_MISUSE("SQLITE_MISUSE", 21, SQLiteMisuseException.class),
        SQLITE_NOLFS("SQLITE_NOLFS", 22, null),
        SQLITE_AUTH("SQLITE_AUTH", 23, null),
        SQLITE_FORMAT("SQLITE_FORMAT", 24, null),
        SQLITE_RANGE("SQLITE_RANGE", 25, SQLiteBindOrColumnIndexOutOfRangeException.class),
        SQLITE_NOTADB("SQLITE_NOTADB", 26, null),
        SQLITE_NOTICE("SQLITE_NOTICE", 27, null),
        SQLITE_WARNING("SQLITE_WARNING", 28, null),
        SQLITE_ROW("SQLITE_ROW", 100, null),
        SQLITE_DONE("SQLITE_DONE", 101, SQLiteDoneException.class);

        final int errno;
        final String code;
        final Class<? extends SQLiteException> claz;

        private CODES(String code, int errno, Class<? extends SQLiteException> e) {
            this.code = code;
            this.errno = errno;
            this.claz = e;
        }
    }

    static class JNIReturnObject {
        final int status;
        final Object reference;
        final String error;

        JNIReturnObject(CODES code) {
            this.status = code.errno;
            this.reference = null;
            this.error = null;
        }

        JNIReturnObject(CODES code, String error) {
            this.status = code.errno;
            this.reference = null;
            this.error = error;
        }

        JNIReturnObject(SQLiteException exception) {
            CODES ecode = null;
            for (CODES code : CODES.values()) {
                if (code.claz != ((Object)((Object)exception)).getClass()) continue;
                ecode = code;
                break;
            }
            if (ecode == null) {
                ecode = CODES.SQLITE_ERROR;
            }
            this.status = ecode.errno;
            this.error = exception.getMessage();
            this.reference = null;
        }

        JNIReturnObject(Object reference) {
            this.status = CODES.SQLITE_OK.errno;
            this.error = null;
            this.reference = reference;
        }
    }
}

