/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.os.CancellationSignal;
import org.liquidplayer.node.SQLite3Shim;
import org.liquidplayer.node.SQLite3Statement;

class SQLite3Database {
    final SQLiteDatabase m_db;
    Long m_last_insert_rowId = 0L;
    CancellationSignal m_cancellationSignal = new CancellationSignal();
    private static final int SQLITE_OPEN_READONLY = 1;
    private static final int SQLITE_OPEN_READWRITE = 2;
    private static final int SQLITE_OPEN_CREATE = 4;
    private static final int SQLITE_OPEN_WAL = 524288;

    SQLite3Database(String path, int flags, String jVFS) throws SQLiteException {
        int mode = 0;
        if ((flags & 4) != 0) {
            mode |= 0x10000000;
        }
        if ((flags & 0x80000) != 0) {
            mode |= 0x20000000;
        }
        if ((flags & 1) != 0) {
            mode |= 1;
        }
        if ((flags & 2) != 0) {
            mode |= 0;
        }
        this.m_db = SQLiteDatabase.openDatabase((String)path, null, (int)mode, null);
    }

    SQLite3Shim.JNIReturnObject sqlite3_busy_timeout(int ms) {
        return new SQLite3Shim.JNIReturnObject(SQLite3Shim.CODES.SQLITE_OK);
    }

    int sqlite3_changes() {
        SQLiteStatement statement = this.m_db.compileStatement("SELECT changes()");
        return (int)statement.simpleQueryForLong();
    }

    SQLite3Shim.JNIReturnObject sqlite3_close() {
        try {
            this.m_db.close();
            return new SQLite3Shim.JNIReturnObject(SQLite3Shim.CODES.SQLITE_OK);
        }
        catch (SQLiteException exception) {
            return new SQLite3Shim.JNIReturnObject(exception);
        }
    }

    SQLite3Shim.JNIReturnObject sqlite3_enable_load_extension(int onoff) {
        if (onoff != 0) {
            return new SQLite3Shim.JNIReturnObject(SQLite3Shim.CODES.SQLITE_MISUSE, "sqlite3_enable_load_extension not supported");
        }
        return new SQLite3Shim.JNIReturnObject(SQLite3Shim.CODES.SQLITE_OK);
    }

    SQLite3Shim.JNIReturnObject sqlite3_exec(String sql) {
        try {
            this.m_db.execSQL(sql);
            return new SQLite3Shim.JNIReturnObject(SQLite3Shim.CODES.SQLITE_OK);
        }
        catch (SQLiteException exception) {
            return new SQLite3Shim.JNIReturnObject(exception);
        }
    }

    void sqlite3_interrupt() {
        this.m_cancellationSignal.cancel();
    }

    long sqlite3_last_insert_rowid() {
        return this.m_last_insert_rowId;
    }

    SQLite3Shim.JNIReturnObject sqlite3_prepare_v2(String sql, int nByte) {
        try {
            SQLite3Statement stmt = new SQLite3Statement(this, sql);
            return new SQLite3Shim.JNIReturnObject(stmt);
        }
        catch (SQLiteException exception) {
            return new SQLite3Shim.JNIReturnObject(exception);
        }
    }
}

