/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JNIReturnObject;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSObjectPropertiesMap;

public class JSValue {
    protected JNIJSValue valueRef;
    protected JSContext context = null;

    protected JSValue() {
    }

    public JSValue(JSContext ctx) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSValue.this.valueRef = JNIJSValue.makeUndefined(JSValue.this.context.ctxRef());
            }
        });
    }

    public JSValue(JSContext ctx, final Object val) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSValue.this.valueRef = val == null ? JNIJSValue.makeNull(JSValue.this.context.ctxRef()) : (val instanceof JSValue ? ((JSValue)val).valueRef() : (val instanceof Map ? new JSObjectPropertiesMap<Object>(JSValue.this.context, (Map)val, Object.class).getJSObject().valueRef() : (val instanceof List ? new JSArray<JSValue>(JSValue.this.context, (List)val, JSValue.class).valueRef() : (val.getClass().isArray() ? new JSArray<JSValue>(JSValue.this.context, (Object[])val, JSValue.class).valueRef() : (val instanceof Boolean ? JNIJSValue.makeBoolean(JSValue.this.context.ctxRef(), (Boolean)val) : (val instanceof Double ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), (Double)val) : (val instanceof Float ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), Double.valueOf(val.toString())) : (val instanceof Integer ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Integer)val).doubleValue()) : (val instanceof Long ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Long)val).doubleValue()) : (val instanceof Byte ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Byte)val).doubleValue()) : (val instanceof Short ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Short)val).doubleValue()) : (val instanceof String ? JNIJSValue.makeString(JSValue.this.context.ctxRef(), (String)val) : JNIJSValue.makeUndefined(JSValue.this.context.ctxRef())))))))))))));
            }
        });
    }

    protected JSValue(JNIJSValue valueRef, JSContext ctx) {
        this.context = ctx;
        if (valueRef != null) {
            this.valueRef = valueRef;
        } else {
            this.context.sync(new Runnable(){

                @Override
                public void run() {
                    JSValue.this.valueRef = JNIJSValue.makeUndefined(JSValue.this.context.ctxRef());
                }
            });
        }
    }

    public Boolean isUndefined() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isUndefined();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isNull() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isNull();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isBoolean() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isBoolean();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isNumber() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isNumber();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isString() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isString();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isArray() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isArray();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isDate() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isDate();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isTypedArray() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isTypedArray();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isInt8Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isInt8Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isInt16Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isInt16Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isInt32Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isInt32Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isUint8ClampedArray() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isUint8ClampedArray();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isUint8Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isUint8Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isUint16Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isUint16Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isUint32Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isUint32Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isFloat32Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isFloat32Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isFloat64Array() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isFloat64Array();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isObject() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isObject();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isInstanceOfConstructor(JSObject constructor) {
        try {
            JSFunction instanceOf = new JSFunction(this.context, "_instanceOf", new String[]{"a", "b"}, "return (a instanceof b);", null, 0);
            return instanceOf.call(null, this, constructor).toBoolean();
        }
        catch (JSException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    public boolean isEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue otherJSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        final JSValue ojsv = otherJSValue;
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.valueRef().isEqual(ojsv.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.exception == null && runnable.jni.bool;
    }

    public boolean isStrictEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue otherJSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        final JSValue ojsv = otherJSValue;
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().isStrictEqual(ojsv.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean toBoolean() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.valueRef().toBoolean();
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Double toNumber() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.valueRef().toNumber();
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)runnable.jni.exception, this.context)));
            return 0.0;
        }
        return runnable.jni.number;
    }

    public String toString() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.valueRef().toStringCopy();
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)runnable.jni.exception, this.context)));
            return null;
        }
        return runnable.jni.string;
    }

    public JSObject toObject() {
        if (this instanceof JSObject) {
            return (JSObject)this;
        }
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.valueRef().toObject();
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)runnable.jni.exception, this.context)));
            return new JSObject(this.context);
        }
        return this.context.getObjectFromRef((JNIJSObject)runnable.jni.reference);
    }

    public JSFunction toFunction() {
        JSObject obj;
        if (this.isObject().booleanValue() && (obj = this.toObject()) instanceof JSFunction) {
            return (JSFunction)obj;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not a function"));
        return null;
    }

    public JSBaseArray toJSArray() {
        JSObject obj;
        if (this.isObject().booleanValue() && (obj = this.toObject()) instanceof JSBaseArray) {
            return (JSBaseArray)obj;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not an array"));
        return null;
    }

    public String toJSON() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.valueRef().createJSONString();
                if (this.jni.exception == null) {
                    JSValue json = new JSValue((JNIJSValue)this.jni.reference, JSValue.this.context);
                    this.jni.string = json.isUndefined() != false ? null : json.toString();
                }
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)runnable.jni.exception, this.context)));
            return null;
        }
        return runnable.jni.string;
    }

    protected Object toJavaObject(Class clazz) {
        if (clazz == Object.class) {
            return this;
        }
        if (clazz == Map.class) {
            return new JSObjectPropertiesMap<Object>(this.toObject(), Object.class);
        }
        if (clazz == List.class) {
            return this.toJSArray();
        }
        if (clazz == String.class) {
            return this.toString();
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return this.toNumber();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(this.toNumber().floatValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return this.toNumber().intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return this.toNumber().longValue();
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return this.toNumber().byteValue();
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return this.toNumber().shortValue();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return this.toBoolean();
        }
        if (clazz.isArray()) {
            return this.toJSArray().toArray(clazz.getComponentType());
        }
        if (JSArray.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toJSArray());
        }
        if (JSObject.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toObject());
        }
        if (JSValue.class.isAssignableFrom(clazz)) {
            return clazz.cast(this);
        }
        return null;
    }

    public int hashCode() {
        if (this.isBoolean().booleanValue()) {
            return this.toBoolean().hashCode();
        }
        if (this.isNumber().booleanValue()) {
            return this.toNumber().hashCode();
        }
        if (this.isString().booleanValue()) {
            return this.toString().hashCode();
        }
        if (this.isUndefined().booleanValue() || this.isNull().booleanValue()) {
            return 0;
        }
        return super.hashCode();
    }

    public JSContext getContext() {
        return this.context;
    }

    public JNIJSValue valueRef() {
        return this.valueRef;
    }

    private abstract class JNIReturnClass
    implements Runnable {
        JNIReturnObject jni;

        private JNIReturnClass() {
        }
    }
}

