/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JNIReturnObject;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSIterator;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;

public class JSArray<T>
extends JSBaseArray<T> {
    private JNIJSValue testException(JNIReturnObject jni) {
        if (jni.exception != null) {
            this.valueRef = JNIJSObject.make(this.context.ctxRef());
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)jni.exception, this.context)));
            return this.valueRef;
        }
        return (JNIJSValue)jni.reference;
    }

    public JSArray(JSContext ctx, JSValue[] array, Class<T> cls) {
        super(ctx, cls);
        final JNIJSValue[] valueRefs = new JNIJSValue[array.length];
        for (int i = 0; i < array.length; ++i) {
            valueRefs[i] = array[i].valueRef();
        }
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSArray.this.valueRef = JSArray.this.testException(JNIJSObject.makeArray(JSArray.this.context.ctxRef(), valueRefs));
                JSArray.this.addJSExports();
            }
        });
        this.context.persistObject(this);
    }

    public JSArray(JSContext ctx, Class<T> cls) {
        super(ctx, cls);
        final JNIJSValue[] valueRefs = new JNIJSValue[]{};
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSArray.this.valueRef = JSArray.this.testException(JNIJSObject.makeArray(JSArray.this.context.ctxRef(), valueRefs));
                JSArray.this.addJSExports();
            }
        });
        this.context.persistObject(this);
    }

    public JSArray(JSContext ctx, Object[] array, Class<T> cls) {
        super(ctx, cls);
        final JNIJSValue[] valueRefs = new JNIJSValue[array.length];
        for (int i = 0; i < array.length; ++i) {
            JSValue v = new JSValue(this.context, array[i]);
            valueRefs[i] = v.valueRef();
        }
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSArray.this.valueRef = JSArray.this.testException(JNIJSObject.makeArray(JSArray.this.context.ctxRef(), valueRefs));
                JSArray.this.addJSExports();
            }
        });
        this.context.persistObject(this);
    }

    protected JSArray(JNIJSObject valueRef, JSContext ctx) {
        super(valueRef, ctx, JSValue.class);
    }

    protected JSArray(JNIJSObject valueRef, JSContext ctx, Class<T> cls) {
        super(valueRef, ctx, cls);
    }

    private JSArray(JSArray<T> superList, int leftBuffer, int rightBuffer, Class<T> cls) {
        super(superList, leftBuffer, rightBuffer, cls);
    }

    public JSArray(JSContext ctx, Collection list, Class<T> cls) {
        this(ctx, list.toArray(), cls);
    }

    @Override
    public void add(int index, T element) {
        if (this == element) {
            throw new IllegalArgumentException();
        }
        int count = this.size();
        if (index > count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.splice(index, 0, element);
    }

    @Override
    public T remove(int index) {
        int count = this.size();
        if (index >= count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.mSuperList == null) {
            return this.splice(index, 1, new Object[0]).get(0);
        }
        return this.mSuperList.remove(index + this.mLeftBuffer);
    }

    @Override
    @NonNull
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new JSArray<T>(this, fromIndex, this.size() - toIndex, this.mType);
    }

    public static JSArray<JSValue> from(JSContext ctx, Object arrayLike, JSFunction mapFn, JSObject thiz) {
        JSFunction from = ctx.property("Array").toObject().property("from").toFunction();
        return (JSArray)from.call(null, arrayLike, mapFn, thiz).toJSArray();
    }

    public static JSArray<JSValue> from(JSContext ctx, Object arrayLike, JSFunction mapFn) {
        JSFunction from = ctx.property("Array").toObject().property("from").toFunction();
        return (JSArray)from.call(null, arrayLike, mapFn).toJSArray();
    }

    public static JSArray<JSValue> from(JSContext ctx, Object arrayLike) {
        JSFunction from = ctx.property("Array").toObject().property("from").toFunction();
        return (JSArray)from.call(null, arrayLike).toJSArray();
    }

    public static JSArray<JSValue> from(JSContext ctx, Object arrayLike, final MapCallback<JSValue> mapFn) {
        ctx.property("Array").toObject();
        JSFunction from = ctx.property("Array").toObject().property("from").toFunction();
        return (JSArray)from.call(null, arrayLike, new JSFunction(ctx, "_callback"){

            public JSValue _callback(JSValue currentValue, int index, JSArray array) {
                return mapFn.callback(currentValue, index, array);
            }
        }).toJSArray();
    }

    public static boolean isArray(JSValue value) {
        if (value == null) {
            return false;
        }
        JSFunction isArray = value.getContext().property("Array").toObject().property("isArray").toFunction();
        return isArray.call(null, value).toBoolean();
    }

    public static JSArray<JSValue> of(JSContext ctx, Object ... params) {
        JSFunction of = ctx.property("Array").toObject().property("of").toFunction();
        return (JSArray)of.apply(null, params).toJSArray();
    }

    public JSArray<T> concat(Object ... params) {
        JSArray concat = (JSArray)this.property("concat").toFunction().apply(this, params).toJSArray();
        concat.mType = this.mType;
        return concat;
    }

    public T pop() {
        return (T)this.property("pop").toFunction().call(this, new Object[0]).toJavaObject(this.mType);
    }

    public int push(T ... elements) {
        return this.property("push").toFunction().apply(this, elements).toNumber().intValue();
    }

    public T shift() {
        JSValue shifted = this.property("shift").toFunction().call(this, new Object[0]);
        if (shifted.isUndefined().booleanValue()) {
            return null;
        }
        return (T)shifted.toJavaObject(this.mType);
    }

    public JSArray<T> splice(int start, int deleteCount, T ... elements) {
        ArrayList<T> args = new ArrayList<T>(Arrays.asList(elements));
        args.add(0, deleteCount);
        args.add(0, start);
        JSArray splice = (JSArray)this.property("splice").toFunction().apply(this, args.toArray()).toJSArray();
        splice.mType = this.mType;
        return splice;
    }

    public String toLocaleString() {
        return this.property("toLocaleString").toFunction().call(this, new Object[0]).toString();
    }

    public int unshift(T ... elements) {
        return this.property("unshift").toFunction().apply(this, elements).toNumber().intValue();
    }

    protected JSValue each(JSFunction callback, JSObject thiz, String each) {
        return this.property(each).toFunction().call(this, callback, thiz);
    }

    protected JSValue each(final EachBooleanCallback<T> callback, String each) {
        return this.property(each).toFunction().call(this, new JSFunction(this.context, "_callback"){

            public boolean _callback(T currentValue, int index, JSArray array) {
                return callback.callback(((JSValue)currentValue).toJavaObject(JSArray.this.mType), index, array);
            }
        });
    }

    protected JSValue each(final ForEachCallback<T> callback, String each) {
        return this.property(each).toFunction().call(this, new JSFunction(this.context, "_callback"){

            public void _callback(T currentValue, int index, JSArray array) {
                callback.callback(((JSValue)currentValue).toJavaObject(JSArray.this.mType), index, array);
            }
        });
    }

    protected JSValue each(final ReduceCallback callback, String each, Object initialValue) {
        return this.property(each).toFunction().call(this, new JSFunction(this.context, "_callback"){

            public JSValue _callback(JSValue previousValue, JSValue currentValue, int index, JSArray<JSValue> array) {
                return callback.callback(previousValue, currentValue, index, array);
            }
        }, initialValue);
    }

    public EntriesIterator<T> entries() {
        return new EntriesIterator(this.property("entries").toFunction().call(this, new Object[0]).toObject());
    }

    public boolean every(JSFunction callback, JSObject thiz) {
        return this.each(callback, thiz, "every").toBoolean();
    }

    public boolean every(JSFunction callback) {
        return this.every(callback, null);
    }

    public boolean every(EachBooleanCallback<T> callback) {
        return this.each(callback, "every").toBoolean();
    }

    public T find(JSFunction callback, JSObject thiz) {
        return (T)this.each(callback, thiz, "find").toJavaObject(this.mType);
    }

    public T find(JSFunction callback) {
        return this.find(callback, null);
    }

    public T find(EachBooleanCallback<T> callback) {
        return (T)this.each(callback, "find").toJavaObject(this.mType);
    }

    public int findIndex(JSFunction callback, JSObject thiz) {
        return this.each(callback, thiz, "findIndex").toNumber().intValue();
    }

    public int findIndex(JSFunction callback) {
        return this.findIndex(callback, null);
    }

    public int findIndex(EachBooleanCallback<T> callback) {
        return this.each(callback, "findIndex").toNumber().intValue();
    }

    public void forEach(JSFunction callback, JSObject thiz) {
        this.each(callback, thiz, "forEach");
    }

    public void forEach(JSFunction callback) {
        this.forEach(callback, null);
    }

    @Override
    public void forEach(ForEachCallback<T> callback) {
        this.each(callback, "forEach");
    }

    public boolean includes(T element, int fromIndex) {
        return this.property("includes").toFunction().call(this, element, fromIndex).toBoolean();
    }

    public boolean includes(T element) {
        return this.includes(element, 0);
    }

    public int indexOf(T element, int fromIndex) {
        return this.property("indexOf").toFunction().call(this, element, fromIndex).toNumber().intValue();
    }

    public String join(String separator) {
        return this.property("join").toFunction().call(this, separator).toString();
    }

    public String join() {
        return this.property("join").toFunction().call(this, new Object[0]).toString();
    }

    public KeysIterator keys() {
        return new KeysIterator(this.property("keys").toFunction().call(this, new Object[0]).toObject());
    }

    public int lastIndexOf(T element, int fromIndex) {
        return this.property("lastIndexOf").toFunction().call(this, element, fromIndex).toNumber().intValue();
    }

    public JSValue reduce(JSFunction callback, Object initialValue) {
        return this.property("reduce").toFunction().call(this, callback, initialValue);
    }

    public JSValue reduce(JSFunction callback) {
        return this.property("reduce").toFunction().call(this, callback);
    }

    public JSValue reduce(ReduceCallback callback, Object initialValue) {
        return this.each(callback, "reduce", initialValue);
    }

    public JSValue reduce(ReduceCallback callback) {
        return this.reduce(callback, null);
    }

    public JSValue reduceRight(JSFunction callback, Object initialValue) {
        return this.property("reduceRight").toFunction().call(this, callback, initialValue);
    }

    public JSValue reduceRight(JSFunction callback) {
        return this.property("reduceRight").toFunction().call(this, callback);
    }

    public JSValue reduceRight(ReduceCallback callback, Object initialValue) {
        return this.each(callback, "reduceRight", initialValue);
    }

    public JSValue reduceRight(ReduceCallback callback) {
        return this.reduceRight(callback, null);
    }

    public boolean some(JSFunction callback, JSObject thiz) {
        return this.each(callback, thiz, "some").toBoolean();
    }

    public boolean some(JSFunction callback) {
        return this.some(callback, null);
    }

    public boolean some(EachBooleanCallback<T> callback) {
        return this.each(callback, "some").toBoolean();
    }

    public JSArray<T> copyWithin(int target, int start, int end) {
        return (JSArray)this.property("copyWithin").toFunction().call(this, target, start, end).toJSArray();
    }

    public JSArray<T> copyWithin(int target, int start) {
        return this.copyWithin(target, start, this.size());
    }

    public JSArray<T> copyWithin(int target) {
        return this.copyWithin(target, 0);
    }

    public JSArray<T> fill(T value, int start, int end) {
        return (JSArray)this.property("fill").toFunction().call(this, value, start, end).toJSArray();
    }

    public JSArray<T> fill(T value, int start) {
        return this.fill(value, start, this.size());
    }

    public JSArray<T> fill(T value) {
        return this.fill(value, 0);
    }

    public JSArray<T> filter(JSFunction callback, JSObject thiz) {
        JSArray filter = (JSArray)this.each(callback, thiz, "filter").toJSArray();
        filter.mType = this.mType;
        return filter;
    }

    public JSArray<T> filter(JSFunction callback) {
        return this.filter(callback, null);
    }

    public JSArray<T> filter(EachBooleanCallback<T> callback) {
        JSArray filter = (JSArray)this.each(callback, "filter").toJSArray();
        filter.mType = this.mType;
        return filter;
    }

    public JSArray<JSValue> map(JSFunction callback, JSObject thiz) {
        return (JSArray)this.each(callback, thiz, "map").toJSArray();
    }

    public JSArray<JSValue> map(JSFunction callback) {
        return this.map(callback, null);
    }

    public JSArray<JSValue> map(final MapCallback<T> callback) {
        return (JSArray)this.property("map").toFunction().call(this, new JSFunction(this.context, "_callback"){

            public JSValue _callback(T currentValue, int index, JSArray<T> array) {
                return callback.callback(((JSValue)currentValue).toJavaObject(JSArray.this.mType), index, array);
            }
        }).toJSArray();
    }

    public JSArray<T> reverse() {
        return (JSArray)this.property("reverse").toFunction().call(this, new Object[0]).toJSArray();
    }

    public JSArray<T> slice(int begin, int end) {
        return (JSArray)this.property("slice").toFunction().call(this, begin, end).toJSArray();
    }

    public JSArray<T> slice(int begin) {
        return (JSArray)this.property("slice").toFunction().call(this, begin).toJSArray();
    }

    public JSArray<T> slice() {
        return (JSArray)this.property("slice").toFunction().call(this, new Object[0]).toJSArray();
    }

    public JSArray<T> sort(JSFunction compare) {
        return (JSArray)this.property("sort").toFunction().call(this, compare).toJSArray();
    }

    public JSArray<T> sort(final SortCallback<T> callback) {
        return (JSArray)this.property("sort").toFunction().call(this, new JSFunction(this.context, "_callback"){

            public double _callback(T a, T b) {
                return callback.callback(((JSValue)a).toJavaObject(JSArray.this.mType), ((JSValue)b).toJavaObject(JSArray.this.mType));
            }
        }).toJSArray();
    }

    public JSArray<T> sort() {
        return (JSArray)this.property("sort").toFunction().call(this, new Object[0]).toJSArray();
    }

    public class KeysIterator
    extends JSIterator<Integer> {
        protected KeysIterator(JSObject iterator) {
            super(iterator);
        }

        @Override
        public Integer next() {
            JSIterator.Next jsnext = this.jsnext();
            if (jsnext.value().isUndefined().booleanValue()) {
                return null;
            }
            JSValue next = jsnext.value();
            return (Integer)next.toJavaObject(Integer.class);
        }
    }

    public class EntriesIterator<U>
    extends JSIterator<Map.Entry<Integer, U>> {
        protected EntriesIterator(JSObject iterator) {
            super(iterator);
        }

        @Override
        public Map.Entry<Integer, U> next() {
            JSObject next = this.jsnext().value().toObject();
            return new AbstractMap.SimpleEntry<Integer, Object>(next.propertyAtIndex(0).toNumber().intValue(), next.propertyAtIndex(1).toJavaObject(JSArray.this.mType));
        }
    }

    public static interface SortCallback<T> {
        public double callback(T var1, T var2);
    }

    public static interface ReduceCallback {
        public JSValue callback(JSValue var1, JSValue var2, int var3, JSArray<JSValue> var4);
    }

    public static interface ForEachCallback<T> {
        public void callback(T var1, int var2, JSArray<T> var3);
    }

    public static interface EachBooleanCallback<T> {
        public boolean callback(T var1, int var2, JSArray<T> var3);
    }

    public static interface MapCallback<T> {
        public JSValue callback(T var1, int var2, JSArray<T> var3);
    }
}

