/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.liquidplayer.javascript.JNIJSContext;
import org.liquidplayer.javascript.JNIJSContextGroup;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JNIReturnObject;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSTypedArray;
import org.liquidplayer.javascript.JSValue;

public class JSContext
extends JSObject {
    private JSContextGroup contextGroup = null;
    private JNIJSContext jniContext;
    private IJSExceptionHandler exceptionHandler;
    private final HashMap<JNIJSObject, WeakReference<JSObject>> objects = new HashMap();
    private final Object objectsMutex = new Object();

    static void init() {
    }

    public void sync(final Runnable runnable) {
        if (this.isOnThread()) {
            runnable.run();
        } else {
            final Semaphore sempahore = new Semaphore(0);
            Runnable syncRunner = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    sempahore.release();
                }
            };
            this.getGroup().schedule(syncRunner);
            sempahore.acquireUninterruptibly();
        }
    }

    public void async(Runnable runnable) {
        if (this.isOnThread()) {
            runnable.run();
        } else {
            this.getGroup().schedule(runnable);
        }
    }

    private boolean isOnThread() {
        if (this.jniContext == null) {
            return true;
        }
        return this.getGroup().isOnThread();
    }

    public long getJSCContext() {
        return 0L;
    }

    protected JSContext(Object ctxHandle, JSContextGroup group) {
        this.context = this;
        this.contextGroup = group;
        this.jniContext = (JNIJSContext)ctxHandle;
        this.valueRef = (JNIJSValue)this.jniContext.getGlobalObject();
        this.addJSExports();
    }

    public JSContext() {
        this(new JSContextGroup());
    }

    public JSContext(final JSContextGroup inGroup) {
        this.context = this;
        this.contextGroup = inGroup;
        this.sync(new Runnable(){

            @Override
            public void run() {
                JSContext.this.jniContext = JNIJSContext.createInGroup(inGroup.groupRef());
                JSContext.this.valueRef = (JNIJSValue)JSContext.this.jniContext.getGlobalObject();
                JSContext.this.addJSExports();
            }
        });
    }

    public JSContext(Class<?> iface) {
        this(new JSContextGroup(), iface);
    }

    public JSContext(JSContextGroup inGroup, Class<?> iface) {
        this(inGroup);
        Method[] methods;
        for (Method m : methods = iface.getDeclaredMethods()) {
            JSFunction f = new JSFunction(this.context, m, JSObject.class, (JSObject)this.context);
            this.property(m.getName(), f);
        }
    }

    public void setExceptionHandler(IJSExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public void clearExceptionHandler() {
        this.exceptionHandler = null;
    }

    public void throwJSException(JSException exception) {
        if (this.exceptionHandler == null) {
            throw exception;
        }
        IJSExceptionHandler temp = this.exceptionHandler;
        this.exceptionHandler = null;
        temp.handle(exception);
        this.exceptionHandler = temp;
    }

    public JSContextGroup getGroup() {
        JNIJSContextGroup g = this.jniContext.getGroup();
        if (g == null) {
            return null;
        }
        return new JSContextGroup(g);
    }

    public JNIJSContext ctxRef() {
        return this.jniContext;
    }

    public JSValue evaluateScript(final @NonNull String script, final String sourceURL, final int startingLineNumber) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                String src = sourceURL == null ? "<code>" : sourceURL;
                this.jni = JSContext.this.jniContext.evaluateScript(script, src, startingLineNumber);
            }
        };
        this.sync(runnable);
        if (runnable.jni.exception != null) {
            this.throwJSException(new JSException(new JSValue((JNIJSValue)runnable.jni.exception, this.context)));
            return new JSValue(this);
        }
        return new JSValue((JNIJSValue)runnable.jni.reference, this);
    }

    public JSValue evaluateScript(String script) {
        return this.evaluateScript(script, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistObject(JSObject obj) {
        Object object = this.objectsMutex;
        synchronized (object) {
            if (JNIJSObject.class.isAssignableFrom(obj.valueRef().getClass())) {
                this.objects.put((JNIJSObject)obj.valueRef(), new WeakReference<JSObject>(obj));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeObject(JSObject obj) {
        Object object = this.objectsMutex;
        synchronized (object) {
            if (JNIJSObject.class.isAssignableFrom(obj.valueRef().getClass())) {
                this.objects.remove((JNIJSObject)obj.valueRef());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSObject getObjectFromRef(JNIJSObject objRef, boolean create) {
        WeakReference<JSObject> wr;
        if (objRef == this.valueRef()) {
            return this;
        }
        Object object = this.objectsMutex;
        synchronized (object) {
            wr = this.objects.get(objRef);
        }
        JSFunction obj = null;
        if (wr != null) {
            obj = (JSArray)wr.get();
        }
        if (obj == null && create) {
            obj = new JSObject(objRef, this);
            if (objRef.isArray()) {
                obj = new JSArray(objRef, this);
            } else if (JSTypedArray.isTypedArray(obj)) {
                obj = JSTypedArray.from(obj);
            } else if (objRef.isFunction()) {
                obj = new JSFunction(objRef, this);
            }
        }
        return obj;
    }

    protected JSObject getObjectFromRef(JNIJSObject objRef) {
        return this.getObjectFromRef(objRef, true);
    }

    static {
        System.loadLibrary("node");
        System.loadLibrary("liquidcore");
    }

    private abstract class JNIReturnClass
    implements Runnable {
        JNIReturnObject jni;

        private JNIReturnClass() {
        }
    }

    public static interface IJSExceptionHandler {
        public void handle(JSException var1);
    }
}

