/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.liquidplayer.javascript.JNIJSFunction;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;

public class JSFunction
extends JSObject {
    private Class<? extends JSObject> subclass = null;
    protected Method method = null;
    private JSObject invokeObject = null;

    public JSFunction(JSContext ctx, final @NonNull String name, final @NonNull String[] parameterNames, final @NonNull String body, final String sourceURL, final int startingLineNumber) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder("(function(");
                for (int i = 0; i < parameterNames.length; ++i) {
                    stringBuilder.append(parameterNames[i]);
                    if (i >= parameterNames.length - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("){");
                stringBuilder.append(body);
                stringBuilder.append("})");
                String string = stringBuilder.toString();
                org.liquidplayer.javascript.a a2 = JNIJSFunction.makeFunction(JSFunction.this.context.ctxRef(), name, string, sourceURL == null ? "<anonymous>" : sourceURL, startingLineNumber);
                JSFunction.this.valueRef = JSFunction.this.testException(a2);
                JSFunction.this.addJSExports();
            }
        });
        this.context.persistObject(this);
    }

    public JSFunction(JSContext ctx, @NonNull String name, @NonNull String body, String ... parameterNames) {
        this(ctx, name, parameterNames, body, null, 1);
    }

    private JNIJSObject testException(org.liquidplayer.javascript.a jni) {
        if (jni.d != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)jni.d, this.context)));
            return JNIJSObject.make(this.context.ctxRef());
        }
        return (JNIJSObject)jni.c;
    }

    public JSFunction(JSContext ctx, final Method method, final Class<? extends JSObject> instanceClass, JSObject invokeObject) {
        this.context = ctx;
        this.method = method;
        this.invokeObject = invokeObject == null ? this : invokeObject;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSFunction.this.valueRef = JNIJSFunction.makeFunctionWithCallback(JSFunction.this, JSFunction.this.context.ctxRef(), method.getName());
                JSFunction.this.subclass = instanceClass;
                JSFunction.this.addJSExports();
            }
        });
        this.context.persistObject(this);
        this.context.zombies.add(this);
    }

    public JSFunction(JSContext ctx, Method method, Class<? extends JSObject> instanceClass) {
        this(ctx, method, instanceClass, null);
    }

    public JSFunction(JSContext ctx, Method method) {
        this(ctx, method, JSObject.class);
    }

    public JSFunction(JSContext ctx) {
        this(ctx, (String)null);
    }

    public JSFunction(JSContext ctx, String methodName, final Class<? extends JSObject> instanceClass, JSObject invokeObject) {
        Method[] methodArray;
        this.context = ctx;
        this.invokeObject = invokeObject == null ? this : invokeObject;
        String string = methodName == null ? "__nullFunc" : methodName;
        for (Method method : methodArray = this.invokeObject.getClass().getMethods()) {
            if (!method.getName().equals(string)) continue;
            this.method = method;
            break;
        }
        if (this.method == null) {
            this.context.sync(new Runnable(){

                @Override
                public void run() {
                    JSFunction.this.valueRef = JNIJSObject.makeUndefined(JSFunction.this.context.ctxRef());
                }
            });
            this.context.throwJSException(new JSException(this.context, "No such method. Did you make it public?"));
        }
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSFunction.this.valueRef = JNIJSFunction.makeFunctionWithCallback(JSFunction.this, JSFunction.this.context.ctxRef(), JSFunction.this.method.getName());
                JSFunction.this.subclass = instanceClass;
                JSFunction.this.addJSExports();
            }
        });
        this.context.persistObject(this);
        this.context.zombies.add(this);
    }

    public JSFunction(JSContext ctx, String methodName, Class<? extends JSObject> instanceClass) {
        this(ctx, methodName, instanceClass, null);
    }

    public JSFunction(JSContext ctx, String methodName) {
        this(ctx, methodName, JSObject.class);
    }

    public JSFunction(JNIJSObject objRef, JSContext context) {
        super(objRef, context);
    }

    public JSValue call(JSObject thiz, Object ... args) {
        return this.apply(thiz, args);
    }

    private JNIJSValue[] argsToValueRefs(Object[] args) {
        ArrayList<JSArray<Object>> arrayList = new ArrayList<JSArray<Object>>();
        if (args != null) {
            for (Object object : args) {
                if (object == null) break;
                JSValue jSValue = object.getClass() == Void.class ? new JSArray<Object>(this.context) : (object instanceof JSValue ? (JSValue)object : (object instanceof Object[] ? new JSArray<Object>(this.context, (Object[])object, Object.class) : new JSValue(this.context, object)));
                arrayList.add((JSArray<Object>)jSValue);
            }
        }
        Object[] objectArray = new JNIJSValue[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = ((JSValue)arrayList.get(i)).valueRef();
        }
        return objectArray;
    }

    public JSValue apply(final JSObject thiz, final Object[] args) {
        a a2 = new a(){

            @Override
            public void run() {
                this.d = JSFunction.this.JNI().callAsFunction(thiz == null ? null : (JNIJSObject)thiz.valueRef(), JSFunction.this.argsToValueRefs(args));
            }
        };
        this.context.sync(a2);
        if (a2.d.d != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)a2.d.d, this.context)));
            return new JSValue(this.context);
        }
        return new JSValue((JNIJSValue)a2.d.c, this.context);
    }

    public JSValue call() {
        return this.call(null, new Object[0]);
    }

    public JSObject newInstance(final Object ... args) {
        a a2 = new a(){

            @Override
            public void run() {
                this.d = JSFunction.this.JNI().callAsConstructor(JSFunction.this.argsToValueRefs(args));
            }
        };
        this.context.sync(a2);
        return this.context.getObjectFromRef(this.testException(a2.d));
    }

    private org.liquidplayer.javascript.a functionCallback(JNIJSValue thisObjectRef, JNIJSValue[] argumentsValueRef) {
        org.liquidplayer.javascript.a a2 = new org.liquidplayer.javascript.a();
        try {
            JSValue[] jSValueArray = new JSValue[argumentsValueRef.length];
            for (int i = 0; i < argumentsValueRef.length; ++i) {
                jSValueArray[i] = JNIJSObject.class.isAssignableFrom(argumentsValueRef[i].getClass()) ? this.context.getObjectFromRef((JNIJSObject)argumentsValueRef[i], true) : new JSValue(argumentsValueRef[i], this.context);
            }
            JSObject jSObject = JNIJSObject.class.isAssignableFrom(thisObjectRef.getClass()) ? this.context.getObjectFromRef((JNIJSObject)thisObjectRef) : null;
            JSValue jSValue = this.function(jSObject, jSValueArray, this.invokeObject);
            a2.d = null;
            a2.c = jSValue == null ? null : jSValue.valueRef();
        }
        catch (JSException jSException) {
            jSException.printStackTrace();
            a2.d = jSException.getError().valueRef();
            a2.c = null;
        }
        return a2;
    }

    protected JSValue function(JSObject thiz, JSValue[] args) {
        return this.function(thiz, args, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSValue function(JSObject thiz, JSValue[] args, JSObject invokeObject) {
        JSValue jSValue;
        Class<?>[] classArray = this.method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (i < args.length) {
                if (args[i] == null) {
                    objectArray[i] = null;
                    continue;
                }
                objectArray[i] = args[i].toJavaObject(classArray[i]);
                continue;
            }
            objectArray[i] = null;
        }
        JSObject jSObject = null;
        try {
            jSObject = invokeObject.getThis();
            invokeObject.setThis(thiz);
            Object object = this.method.invoke((Object)invokeObject, objectArray);
            jSValue = object == null ? null : (object instanceof JSValue ? (JSValue)object : new JSValue(this.context, object));
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            this.context.throwJSException(new JSException(this.context, invocationTargetException.toString()));
            jSValue = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.context.throwJSException(new JSException(this.context, illegalAccessException.toString()));
            jSValue = null;
        }
        finally {
            invokeObject.setThis(jSObject);
        }
        return jSValue;
    }

    protected void constructor(final JNIJSObject thisObj, final JSValue[] args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Constructor constructor = JSFunction.this.subclass.getConstructor(new Class[0]);
                    JSObject jSObject = (JSObject)constructor.newInstance(new Object[0]);
                    jSObject.context = JSFunction.this.context;
                    jSObject.valueRef = thisObj;
                    jSObject.addJSExports();
                    JSFunction.this.function(jSObject, args);
                    JSFunction.this.context.persistObject(jSObject);
                    JSFunction.this.context.zombies.add(jSObject);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    String string = noSuchMethodException.toString() + "If " + JSFunction.this.subclass.getName() + " is an embedded class, did you specify it as 'static'?";
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, string));
                }
                catch (InvocationTargetException invocationTargetException) {
                    String string = invocationTargetException.toString() + "; Did you remember to call super?";
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, string));
                }
                catch (IllegalAccessException illegalAccessException) {
                    String string = illegalAccessException.toString() + "; Is your constructor public?";
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, string));
                }
                catch (InstantiationException instantiationException) {
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, instantiationException.toString()));
                }
            }
        };
        this.context.sync(runnable);
    }

    private org.liquidplayer.javascript.a constructorCallback(JNIJSObject thisObjectRef, JNIJSValue[] argumentsValueRef) {
        org.liquidplayer.javascript.a a2 = new org.liquidplayer.javascript.a();
        try {
            JSValue[] jSValueArray = new JSValue[argumentsValueRef.length];
            for (int i = 0; i < argumentsValueRef.length; ++i) {
                JSObject jSObject = null;
                if (JNIJSObject.class.isAssignableFrom(argumentsValueRef[i].getClass())) {
                    jSObject = this.context.getObjectFromRef((JNIJSObject)argumentsValueRef[i], false);
                }
                jSValueArray[i] = jSObject != null ? jSObject : new JSValue(argumentsValueRef[i], this.context);
            }
            this.constructor(thisObjectRef, jSValueArray);
            a2.d = null;
        }
        catch (JSException jSException) {
            a2.d = jSException.getError().valueRef();
        }
        return a2;
    }

    protected JSFunction() {
    }

    private abstract class a
    implements Runnable {
        org.liquidplayer.javascript.a d;

        private a() {
        }
    }
}

