/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.os.Process;
import java.io.File;
import java.io.IOException;
import org.liquidplayer.javascript.JNIJSContextGroup;
import org.liquidplayer.javascript.JNILoopPreserver;
import org.liquidplayer.javascript.JSContext;

public class JSContextGroup {
    private JNIJSContextGroup group;
    private int mContextGroupThreadTid = 0;
    private boolean hasDedicatedThread = false;

    public JSContextGroup() {
        this.group = JNIJSContextGroup.create();
        this.hasDedicatedThread = false;
    }

    JSContextGroup(Object groupRef) {
        this.group = (JNIJSContextGroup)groupRef;
        this.hasDedicatedThread = this.group.isManaged();
    }

    public JSContextGroup(File snapshot) {
        this.group = JNIJSContextGroup.createWithSnapshotFile(snapshot.getAbsolutePath());
        this.hasDedicatedThread = false;
    }

    public static File createSnapshot(String script, File snapshotToWrite) throws IOException {
        int n = JNIJSContextGroup.createSnapshot(script, snapshotToWrite.getAbsolutePath());
        switch (n) {
            case 0: {
                return snapshotToWrite;
            }
            case -1: {
                throw new IOException("Failed to create snapshot");
            }
            case -2: {
                throw new IOException("Unable to open for writing");
            }
            case -3: {
                throw new IOException("Could not write file");
            }
            case -4: {
                throw new IOException("Could not close file");
            }
        }
        throw new IOException();
    }

    private boolean hasDedicatedThread() {
        return this.hasDedicatedThread;
    }

    public JNIJSContextGroup groupRef() {
        return this.group;
    }

    boolean isOnThread() {
        return !this.hasDedicatedThread() || Process.myTid() == this.mContextGroupThreadTid;
    }

    private void inContextCallback(Runnable runnable) {
        this.mContextGroupThreadTid = Process.myTid();
        runnable.run();
    }

    void schedule(Runnable runnable) {
        this.group.runInContextGroup(this, runnable);
    }

    public LoopPreserver keepAlive() {
        return new LoopPreserver(JNILoopPreserver.create(this.groupRef()));
    }

    public boolean equals(Object other) {
        return other != null && this == other || other instanceof JSContextGroup && this.groupRef() != null && this.groupRef().equals(((JSContextGroup)other).groupRef());
    }

    static {
        JSContext.a();
    }

    public class LoopPreserver {
        private JNILoopPreserver b;

        LoopPreserver(JNILoopPreserver jniLoopPreserver) {
            this.b = jniLoopPreserver;
        }

        public void release() {
            if (this.b != null) {
                this.b.release();
            }
        }
    }
}

