/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.liquidplayer.javascript.JNIJSContext;
import org.liquidplayer.javascript.JNIJSContextGroup;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSTypedArray;
import org.liquidplayer.javascript.JSValue;

public class JSContext
extends JSObject {
    private JSContextGroup a = null;
    private JNIJSContext b;
    private IJSExceptionHandler c;
    private final HashMap<JNIJSObject, WeakReference<JSObject>> d = new HashMap();
    private final Object e = new Object();

    static void a() {
    }

    public void sync(final Runnable runnable) {
        if (this.b()) {
            runnable.run();
        } else {
            final Semaphore semaphore = new Semaphore(0);
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    semaphore.release();
                }
            };
            this.getGroup().schedule(runnable2);
            semaphore.acquireUninterruptibly();
        }
    }

    public void async(Runnable runnable) {
        if (this.b()) {
            runnable.run();
        } else {
            this.getGroup().schedule(runnable);
        }
    }

    private boolean b() {
        if (this.b == null) {
            return true;
        }
        return this.getGroup().isOnThread();
    }

    public long getJSCContext() {
        return 0L;
    }

    protected JSContext(Object ctxHandle, JSContextGroup group) {
        this.context = this;
        this.a = group;
        this.b = (JNIJSContext)ctxHandle;
        this.valueRef = (JNIJSValue)this.b.getGlobalObject();
        this.addJSExports();
    }

    public JSContext() {
        this(new JSContextGroup());
    }

    public JSContext(final JSContextGroup inGroup) {
        this.context = this;
        this.a = inGroup;
        this.sync(new Runnable(){

            @Override
            public void run() {
                JSContext.this.b = JNIJSContext.createInGroup(inGroup.groupRef());
                JSContext.this.valueRef = (JNIJSValue)JSContext.this.b.getGlobalObject();
                JSContext.this.addJSExports();
            }
        });
    }

    public JSContext(Class<?> iface) {
        this(new JSContextGroup(), iface);
    }

    public JSContext(JSContextGroup inGroup, Class<?> iface) {
        this(inGroup);
        Method[] methodArray;
        for (Method method : methodArray = iface.getDeclaredMethods()) {
            JSFunction jSFunction = new JSFunction(this.context, method, JSObject.class, (JSObject)this.context);
            this.property(method.getName(), jSFunction);
        }
    }

    public void setExceptionHandler(IJSExceptionHandler handler) {
        this.c = handler;
    }

    public void clearExceptionHandler() {
        this.c = null;
    }

    public void throwJSException(JSException exception) {
        if (this.c == null) {
            throw exception;
        }
        IJSExceptionHandler iJSExceptionHandler = this.c;
        this.c = null;
        iJSExceptionHandler.handle(exception);
        this.c = iJSExceptionHandler;
    }

    public JSContextGroup getGroup() {
        JNIJSContextGroup jNIJSContextGroup = this.b.getGroup();
        if (jNIJSContextGroup == null) {
            return null;
        }
        return new JSContextGroup(jNIJSContextGroup);
    }

    public JNIJSContext ctxRef() {
        return this.b;
    }

    public JSValue evaluateScript(final @NonNull String script, final String sourceURL, final int startingLineNumber) {
        a a2 = new a(){

            @Override
            public void run() {
                String string = sourceURL == null ? "<code>" : sourceURL;
                this.e = JSContext.this.b.evaluateScript(script, string, startingLineNumber);
            }
        };
        this.sync(a2);
        if (a2.e.d != null) {
            this.throwJSException(new JSException(new JSValue((JNIJSValue)a2.e.d, this.context)));
            return new JSValue(this);
        }
        return new JSValue((JNIJSValue)a2.e.c, this);
    }

    public JSValue evaluateScript(String script) {
        return this.evaluateScript(script, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistObject(JSObject obj) {
        Object object = this.e;
        synchronized (object) {
            if (JNIJSObject.class.isAssignableFrom(obj.valueRef().getClass())) {
                this.d.put((JNIJSObject)obj.valueRef(), new WeakReference<JSObject>(obj));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeObject(JSObject obj) {
        Object object = this.e;
        synchronized (object) {
            if (JNIJSObject.class.isAssignableFrom(obj.valueRef().getClass())) {
                this.d.remove((JNIJSObject)obj.valueRef());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSObject getObjectFromRef(JNIJSObject objRef, boolean create) {
        WeakReference<JSObject> weakReference;
        if (objRef == this.valueRef()) {
            return this;
        }
        JSFunction jSFunction = this.e;
        synchronized (jSFunction) {
            weakReference = this.d.get(objRef);
        }
        jSFunction = null;
        if (weakReference != null) {
            jSFunction = (JSObject)weakReference.get();
        }
        if (jSFunction == null && create) {
            jSFunction = new JSObject(objRef, this);
            if (objRef.isArray()) {
                jSFunction = new JSArray(objRef, this);
            } else if (JSTypedArray.isTypedArray(jSFunction)) {
                jSFunction = JSTypedArray.from(jSFunction);
            } else if (objRef.isFunction()) {
                jSFunction = new JSFunction(objRef, this);
            }
        }
        return jSFunction;
    }

    protected JSObject getObjectFromRef(JNIJSObject objRef) {
        return this.getObjectFromRef(objRef, true);
    }

    static {
        System.loadLibrary("node");
        System.loadLibrary("liquidcore");
    }

    private abstract class a
    implements Runnable {
        org.liquidplayer.javascript.a e;

        private a() {
        }
    }

    public static interface IJSExceptionHandler {
        public void handle(JSException var1);
    }
}

