/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSValue;

public abstract class JSBaseArray<T>
extends JSFunction
implements List<T> {
    protected Class<T> mType;
    protected int mLeftBuffer = 0;
    protected int mRightBuffer = 0;
    protected JSBaseArray<T> mSuperList = null;

    protected JSBaseArray(JNIJSObject valueRef, JSContext ctx, Class<T> cls) {
        super(valueRef, ctx);
        this.mType = cls;
    }

    protected JSBaseArray(JSBaseArray<T> superList, int leftBuffer, int rightBuffer, Class<T> cls) {
        this.mType = cls;
        this.mLeftBuffer = leftBuffer;
        this.mRightBuffer = rightBuffer;
        this.context = superList.context;
        this.valueRef = superList.valueRef();
        this.mSuperList = superList;
    }

    protected JSBaseArray(JSContext ctx, Class<T> cls) {
        this.context = ctx;
        this.mType = cls;
    }

    public Object[] toArray(Class clazz) {
        int n = this.size();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.elementAtIndex(i).toJavaObject(clazz);
        }
        return objectArray;
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.toArray(this.mType);
    }

    @Override
    public T get(int index) {
        int n = this.size();
        if (index >= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (T)this.elementAtIndex(index).toJavaObject(this.mType);
    }

    @Override
    public boolean add(T val) {
        int n = this.size();
        this.elementAtIndex(n, val);
        return true;
    }

    @Override
    public int size() {
        if (this.mSuperList == null) {
            return this.property("length").toNumber().intValue();
        }
        return Math.max(0, this.mSuperList.size() - this.mLeftBuffer - this.mRightBuffer);
    }

    protected JSValue arrayElement(int index) {
        return this.propertyAtIndex(index);
    }

    protected void arrayElement(int index, T value) {
        this.propertyAtIndex(index, value);
    }

    protected JSValue elementAtIndex(int index) {
        if (this.mSuperList == null) {
            return this.arrayElement(index);
        }
        return this.mSuperList.elementAtIndex(index + this.mLeftBuffer);
    }

    protected void elementAtIndex(int index, T value) {
        if (this.mSuperList == null) {
            this.arrayElement(index, value);
        } else {
            this.mSuperList.elementAtIndex(index + this.mLeftBuffer, value);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new a();
    }

    @Override
    @NonNull
    public <U> U[] toArray(@NonNull U[] elemArray) {
        if (this.size() > elemArray.length) {
            return this.toArray();
        }
        a a2 = new a();
        int n = 0;
        while (a2.hasNext()) {
            Object t = a2.next();
            elemArray[n++] = t;
        }
        for (int i = n; i < elemArray.length; ++i) {
            elemArray[i] = null;
        }
        return elemArray;
    }

    @Override
    public boolean remove(Object object) {
        a a2 = new a();
        while (a2.hasNext()) {
            if (!a2.next().equals(object)) continue;
            a2.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        for (Object object : collection.toArray()) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends T> collection) {
        int n = index;
        for (Object object : collection.toArray()) {
            this.add(n++, (T)object);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        boolean bl = false;
        ListIterator<T> listIterator = this.listIterator();
        block0: while (listIterator.hasNext()) {
            T t = listIterator.next();
            for (Object obj : collection) {
                if (!t.equals(obj)) continue;
                listIterator.remove();
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        boolean bl = false;
        ListIterator<T> listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            T t = listIterator.next();
            boolean bl2 = true;
            for (Object obj : collection) {
                if (!t.equals(obj)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            listIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        for (int i = this.size(); i > 0; --i) {
            this.remove(i - 1);
        }
    }

    @Override
    public T set(int index, T element) {
        int n = this.size();
        if (index >= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        JSValue jSValue = this.elementAtIndex(index);
        this.elementAtIndex(index, element);
        return (T)jSValue.toJavaObject(this.mType);
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<T> listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            if (!listIterator.next().equals(object)) continue;
            return listIterator.nextIndex() - 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<T> listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            if (!listIterator.previous().equals(object)) continue;
            return listIterator.previousIndex() + 1;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator(int index) {
        return new a(index);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List list = (List)other;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<T> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e;
            T t = iterator.next();
            if (t.equals(e = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (T t : this) {
            n = 31 * n + (t == null ? 0 : t.hashCode());
        }
        return n;
    }

    private class a
    implements ListIterator<T> {
        private int b = 0;
        private Integer c = null;

        public a() {
            this(0);
        }

        public a(int n) {
            if (n > JSBaseArray.this.size()) {
                n = JSBaseArray.this.size();
            }
            if (n < 0) {
                n = 0;
            }
            this.b = n;
        }

        @Override
        public boolean hasNext() {
            return this.b < JSBaseArray.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.b > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.c = this.b;
            return JSBaseArray.this.get(this.b++);
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.c = --this.b;
            return JSBaseArray.this.get(this.b);
        }

        @Override
        public void remove() {
            if (this.c == null) {
                throw new NoSuchElementException();
            }
            JSBaseArray.this.remove(this.c);
            this.b = this.c;
            this.c = null;
        }

        @Override
        public int nextIndex() {
            return this.b;
        }

        @Override
        public int previousIndex() {
            return this.b - 1;
        }

        @Override
        public void set(T value) {
            if (this.c == null) {
                throw new NoSuchElementException();
            }
            JSBaseArray.this.set((int)this.c, value);
        }

        @Override
        public void add(T value) {
            JSBaseArray.this.add(this.b++, value);
            this.c = null;
        }
    }
}

