/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteStatement;
import android.util.SparseArray;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.liquidplayer.node.SQLite3Database;
import org.liquidplayer.node.SQLite3Shim;

class SQLite3Statement {
    private final String m_operation;
    private final SQLite3Database m_db;
    private final String m_sql;
    private final boolean m_isQuery;
    private SQLiteStatement m_stmt;
    private Cursor m_cursor;
    private SparseArray<String> m_query_bindings;
    private Long m_result;
    private ArrayList<String> m_parameters = null;
    private static final int SQLITE_INTEGER = 1;
    private static final int SQLITE_FLOAT = 2;
    private static final int SQLITE_TEXT = 3;
    private static final int SQLITE_BLOB = 4;
    private static final int SQLITE_NULL = 5;

    SQLite3Statement(SQLite3Database db, String sql) throws SQLiteException {
        this.m_operation = sql.trim().split(" ")[0].toUpperCase();
        this.m_db = db;
        this.m_sql = sql;
        if ("SELECT".equals(this.m_operation)) {
            this.m_query_bindings = new SparseArray();
            this.m_isQuery = true;
            this.m_db.m_db.compileStatement(sql);
        } else {
            this.m_stmt = this.m_db.m_db.compileStatement(sql);
            this.m_isQuery = false;
        }
    }

    SQLite3Shim.b sqlite3_bind_blob(int pos, byte[] blob) {
        try {
            if (this.m_isQuery) {
                throw new SQLiteMisuseException("Why are you querying a blob, son?");
            }
            this.m_stmt.bindBlob(pos, blob);
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    SQLite3Shim.b sqlite3_bind_double(int pos, double value) {
        try {
            if (this.m_isQuery) {
                this.m_query_bindings.setValueAt(pos, (Object)Double.toString(value));
            } else {
                this.m_stmt.bindDouble(pos, value);
            }
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    SQLite3Shim.b sqlite3_bind_int(int pos, int value) {
        try {
            if (this.m_isQuery) {
                this.m_query_bindings.setValueAt(pos, (Object)Long.toString(value));
            } else {
                this.m_stmt.bindLong(pos, (long)value);
            }
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    SQLite3Shim.b sqlite3_bind_null(int pos) {
        try {
            if (this.m_isQuery) {
                this.m_query_bindings.setValueAt(pos, null);
            } else {
                this.m_stmt.bindNull(pos);
            }
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    SQLite3Shim.b sqlite3_bind_text(int pos, String text) {
        try {
            if (this.m_isQuery) {
                this.m_query_bindings.setValueAt(pos, (Object)text);
            } else {
                this.m_stmt.bindString(pos, text);
            }
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    int sqlite3_bind_parameter_index(String zName) {
        if (this.m_parameters == null) {
            String string = "\"(?:\\\\\"|[^\"])*?\"";
            String string2 = "'(?:\\\\'|[^'])*?'";
            String string3 = this.m_sql.replaceAll("\"(?:\\\\\"|[^\"])*?\"", "\"\"");
            string3 = string3.replaceAll("'(?:\\\\'|[^'])*?'", "\"\"");
            String[] stringArray = string3.split(" \t\\[\\]\\(\\)\n\\{\\}");
            this.m_parameters = new ArrayList();
            for (String string4 : stringArray) {
                if (!string4.startsWith("?") && !string4.startsWith(":") && !string4.startsWith("@") && !string4.startsWith("$")) continue;
                this.m_parameters.add(string4);
            }
        }
        int n = 1;
        for (String string3 : this.m_parameters) {
            if (string3.equals(zName)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    SQLite3Shim.b sqlite3_clear_bindings() {
        try {
            if (this.m_isQuery) {
                this.m_query_bindings.clear();
            } else {
                this.m_stmt.clearBindings();
            }
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    byte[] sqlite3_column_blob(int iCol) {
        try {
            if (this.m_cursor != null) {
                return this.m_cursor.getBlob(iCol);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    int sqlite3_column_bytes(int iCol) {
        try {
            if (this.m_cursor != null && this.m_cursor.getType(iCol) == 4) {
                return this.m_cursor.getBlob(iCol).length;
            }
            if (this.m_cursor != null && this.m_cursor.getType(iCol) == 3) {
                return this.m_cursor.getString(iCol).getBytes(Charset.forName("UTF-8")).length;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    double sqlite3_column_double(int iCol) {
        try {
            if (this.m_cursor != null) {
                return this.m_cursor.getDouble(iCol);
            }
            if (this.m_result != null && iCol == 1) {
                return this.m_result.doubleValue();
            }
            return 0.0;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    long sqlite3_column_int64(int iCol) {
        try {
            if (this.m_cursor != null) {
                return this.m_cursor.getLong(iCol);
            }
            if (this.m_result != null && iCol == 1) {
                return this.m_result;
            }
            return 0L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    String sqlite3_column_text(int iCol) {
        try {
            if (this.m_cursor != null) {
                return this.m_cursor.getString(iCol);
            }
            if (this.m_result != null && iCol == 1) {
                return this.m_result.toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    int sqlite3_column_type(int iCol) {
        try {
            int n = 0;
            if (this.m_cursor != null) {
                switch (this.m_cursor.getType(iCol)) {
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                    case 0: {
                        n = 5;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    int sqlite3_column_count() {
        try {
            if (this.m_cursor != null) {
                return this.m_cursor.getColumnCount();
            }
            if (this.m_result != null) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    String sqlite3_column_name(int N) {
        try {
            if (this.m_cursor != null) {
                return this.m_cursor.getColumnName(N);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    SQLite3Shim.b sqlite3_finalize() {
        SQLite3Shim.b b2 = this.sqlite3_reset();
        if (b2.a != SQLite3Shim.a.a.F) {
            return b2;
        }
        try {
            if (this.m_stmt != null) {
                this.m_stmt.close();
                this.m_stmt = null;
            }
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    SQLite3Shim.b sqlite3_reset() {
        try {
            if (this.m_cursor != null) {
                this.m_cursor.close();
                this.m_cursor = null;
            }
            if (this.m_query_bindings != null) {
                this.m_query_bindings.clear();
            }
            if (this.m_stmt != null) {
                this.m_stmt.clearBindings();
            }
            this.m_result = null;
            return new SQLite3Shim.b(SQLite3Shim.a.a);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }

    SQLite3Shim.b sqlite3_step() {
        try {
            SQLite3Shim.a a2;
            if (this.m_isQuery) {
                if (this.m_cursor == null) {
                    String[] stringArray = new String[this.m_query_bindings.size()];
                    for (int i = 0; i < this.m_query_bindings.size(); ++i) {
                        stringArray[i] = (String)this.m_query_bindings.valueAt(i);
                    }
                    this.m_cursor = this.m_db.m_db.rawQuery(this.m_sql, stringArray, this.m_db.m_cancellationSignal);
                    this.m_cursor.moveToFirst();
                    a2 = this.m_cursor.isAfterLast() ? SQLite3Shim.a.E : SQLite3Shim.a.D;
                } else {
                    a2 = this.m_cursor.moveToNext() ? SQLite3Shim.a.D : SQLite3Shim.a.E;
                }
                this.m_result = null;
            } else if ("INSERT".equals(this.m_operation)) {
                if (this.m_result == null) {
                    this.m_db.m_last_insert_rowId = this.m_result = Long.valueOf(this.m_stmt.executeInsert());
                    a2 = SQLite3Shim.a.D;
                } else {
                    this.m_result = null;
                    a2 = SQLite3Shim.a.E;
                }
            } else if ("UPDATE".equals(this.m_operation) || "DELETE".equals(this.m_operation)) {
                if (this.m_result == null) {
                    this.m_result = this.m_stmt.executeUpdateDelete();
                    a2 = SQLite3Shim.a.D;
                } else {
                    this.m_result = null;
                    a2 = SQLite3Shim.a.E;
                }
            } else {
                this.m_stmt.execute();
                this.m_result = null;
                a2 = SQLite3Shim.a.E;
            }
            return new SQLite3Shim.b(a2);
        }
        catch (SQLiteException sQLiteException) {
            return new SQLite3Shim.b(sQLiteException);
        }
    }
}

