/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.content.Context;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.node.Modules;

public class Process {
    public static final int kMediaAccessPermissionsNone = 0;
    public static final int kMediaAccessPermissionsRead = 1;
    public static final int kMediaAccessPermissionsWrite = 2;
    public static final int kMediaAccessPermissionsRW = 3;
    private boolean notifiedExit = false;
    private long exitCode;
    protected WeakReference<JSContext> jscontext = new WeakReference<Object>(null);
    private boolean isActive = false;
    private boolean isDone = false;
    private org.liquidplayer.node.a fs = null;
    private JSContext holdContext;
    private ArrayList<EventListener> listeners = new ArrayList();
    private final long processRef;
    private final String uniqueID;
    private final Context androidCtx;
    private final int mediaAccessMask;

    public Process(Context androidContext, String uniqueID, int mediaAccessMask, EventListener listener) {
        this.addEventListener(listener);
        new Modules(androidContext).a();
        this.processRef = this.start();
        this.androidCtx = androidContext;
        this.uniqueID = uniqueID;
        this.mediaAccessMask = mediaAccessMask;
    }

    public synchronized void addEventListener(final EventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        JSContext jSContext = (JSContext)this.jscontext.get();
        if (this.isActive() && jSContext != null) {
            jSContext.sync(new Runnable(){

                @Override
                public void run() {
                    JSContext jSContext = (JSContext)Process.this.jscontext.get();
                    if (Process.this.isActive() && jSContext != null) {
                        listener.onProcessStart(Process.this, jSContext);
                    } else {
                        listener.onProcessExit(Process.this, Long.valueOf(Process.this.exitCode).intValue());
                    }
                }
            });
        } else if (this.isDone) {
            listener.onProcessExit(this, Long.valueOf(this.exitCode).intValue());
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isActive() {
        return this.isActive && this.jscontext != null;
    }

    public void exit(final int exitc) {
        JSContext jSContext = (JSContext)this.jscontext.get();
        if (this.isActive() && jSContext != null) {
            jSContext.sync(new Runnable(){

                @Override
                public void run() {
                    JSContext jSContext = (JSContext)Process.this.jscontext.get();
                    if (Process.this.isActive() && jSContext != null) {
                        jSContext.evaluateScript("process.exit(" + exitc + ");");
                    }
                }
            });
        }
    }

    public JSContextGroup.LoopPreserver keepAlive() {
        JSContext jSContext = (JSContext)this.jscontext.get();
        if (this.isActive() && jSContext != null) {
            return jSContext.getGroup().keepAlive();
        }
        return null;
    }

    public static void uninstall(Context ctx, String uniqueID, UninstallScope scope) {
        org.liquidplayer.node.a.a(ctx, uniqueID);
        if (scope == UninstallScope.Global) {
            org.liquidplayer.node.a.b(ctx, uniqueID);
        }
    }

    private synchronized void eventOnStart(JSContext ctx) {
        for (EventListener eventListener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            eventListener.onProcessStart(this, ctx);
        }
    }

    private synchronized void eventOnAboutToExit(long code) {
        this.exitCode = code;
        for (EventListener eventListener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            eventListener.onProcessAboutToExit(this, Long.valueOf(code).intValue());
        }
    }

    private synchronized void eventOnProcessFailed(Exception e) {
        for (EventListener eventListener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            eventListener.onProcessFailed(this, e);
        }
    }

    private void eventOnExit(long code) {
        this.exitCode = code;
        if (!this.notifiedExit) {
            this.notifiedExit = true;
            for (EventListener eventListener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
                eventListener.onProcessExit(this, Long.valueOf(code).intValue());
            }
            if (this.fs != null) {
                this.fs.a();
            }
            this.fs = null;
        }
    }

    private void onNodeStarted(final Object mainContext, Object ctxGroupRef, long jscCtxRef) {
        try {
            Constructor constructor = JSContextGroup.class.getDeclaredConstructor(Object.class);
            constructor.setAccessible(true);
            JSContextGroup jSContextGroup = (JSContextGroup)constructor.newInstance(ctxGroupRef);
            this.holdContext = new a(mainContext, jSContextGroup, jscCtxRef);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.jscontext = new WeakReference<JSContext>(this.holdContext);
        this.isActive = true;
        this.holdContext.property("__nodedroid_onLoad", new JSFunction(this.holdContext, "__nodedroid_onLoad"){});
    }

    private void onNodeExit(long exitCode) {
        this.isActive = false;
        this.jscontext = null;
        this.isDone = true;
        this.eventOnExit(exitCode);
        new Thread(){

            @Override
            public void run() {
                Process.this.dispose(Process.this.processRef);
            }
        }.start();
    }

    private native long start();

    private native void dispose(long var1);

    private native void setFileSystem(Object var1, Object var2);

    static /* synthetic */ org.liquidplayer.node.a access$102(Process x0, org.liquidplayer.node.a x1) {
        x0.fs = x1;
        return x0.fs;
    }

    static /* synthetic */ Context access$200(Process x0) {
        return x0.androidCtx;
    }

    static /* synthetic */ String access$300(Process x0) {
        return x0.uniqueID;
    }

    static /* synthetic */ int access$400(Process x0) {
        return x0.mediaAccessMask;
    }

    static /* synthetic */ org.liquidplayer.node.a access$100(Process x0) {
        return x0.fs;
    }

    static /* synthetic */ void access$500(Process x0, Object x1, Object x2) {
        x0.setFileSystem(x1, x2);
    }

    static /* synthetic */ void access$600(Process x0, long x1) {
        x0.eventOnAboutToExit(x1);
    }

    static /* synthetic */ void access$700(Process x0, Exception x1) {
        x0.eventOnProcessFailed(x1);
    }

    static /* synthetic */ void access$800(Process x0, JSContext x1) {
        x0.eventOnStart(x1);
    }

    static /* synthetic */ JSContext access$902(Process x0, JSContext x1) {
        x0.holdContext = x1;
        return x0.holdContext;
    }

    static {
        try {
            Method method = JSContext.class.getDeclaredMethod("a", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class a
    extends JSContext {
        private final long b;

        a(Object object, JSContextGroup jSContextGroup, long l) {
            super(object, jSContextGroup);
            this.b = l;
        }

        @Override
        public long getJSCContext() {
            return this.b;
        }
    }

    public static enum UninstallScope {
        Local,
        Global;

    }

    public static interface EventListener {
        public void onProcessStart(Process var1, JSContext var2);

        public void onProcessAboutToExit(Process var1, int var2);

        public void onProcessExit(Process var1, int var2);

        public void onProcessFailed(Process var1, Exception var2);
    }
}

