/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JNIJSValue;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSObjectPropertiesMap;

public class JSValue {
    protected JNIJSValue valueRef;
    protected JSContext context = null;

    protected JSValue() {
    }

    public JSValue(JSContext ctx) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSValue.this.valueRef = JNIJSValue.makeUndefined(JSValue.this.context.ctxRef());
            }
        });
    }

    public JSValue(JSContext ctx, final Object val) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSValue.this.valueRef = val == null ? JNIJSValue.makeNull(JSValue.this.context.ctxRef()) : (val instanceof JSValue ? ((JSValue)val).valueRef() : (val instanceof Map ? new JSObjectPropertiesMap<Object>(JSValue.this.context, (Map)val, Object.class).getJSObject().valueRef() : (val instanceof List ? new JSArray<JSValue>(JSValue.this.context, (List)val, JSValue.class).valueRef() : (val.getClass().isArray() ? new JSArray<JSValue>(JSValue.this.context, (Object[])val, JSValue.class).valueRef() : (val instanceof Boolean ? JNIJSValue.makeBoolean(JSValue.this.context.ctxRef(), (Boolean)val) : (val instanceof Double ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), (Double)val) : (val instanceof Float ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), Double.valueOf(val.toString())) : (val instanceof Integer ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Integer)val).doubleValue()) : (val instanceof Long ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Long)val).doubleValue()) : (val instanceof Byte ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Byte)val).doubleValue()) : (val instanceof Short ? JNIJSValue.makeNumber(JSValue.this.context.ctxRef(), ((Short)val).doubleValue()) : (val instanceof String ? JNIJSValue.makeString(JSValue.this.context.ctxRef(), (String)val) : JNIJSValue.makeUndefined(JSValue.this.context.ctxRef())))))))))))));
            }
        });
    }

    protected JSValue(JNIJSValue valueRef, JSContext ctx) {
        this.context = ctx;
        if (valueRef != null) {
            this.valueRef = valueRef;
        } else {
            this.context.sync(new Runnable(){

                @Override
                public void run() {
                    JSValue.this.valueRef = JNIJSValue.makeUndefined(JSValue.this.context.ctxRef());
                }
            });
        }
    }

    public Boolean isUndefined() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isUndefined();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isNull() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isNull();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isBoolean() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isBoolean();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isNumber() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isNumber();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isString() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isString();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isArray() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isArray();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isDate() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isDate();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isObject() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isObject();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean isInstanceOfConstructor(JSObject constructor) {
        try {
            JSFunction jSFunction = new JSFunction(this.context, "_instanceOf", new String[]{"a", "b"}, "return (a instanceof b);", null, 0);
            return jSFunction.call(null, this, constructor).toBoolean();
        }
        catch (JSException jSException) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    public boolean isEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue jSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        final JSValue jSValue2 = jSValue;
        a a2 = new a(){

            @Override
            public void run() {
                this.c = JSValue.this.valueRef().isEqual(jSValue2.valueRef);
            }
        };
        this.context.sync(a2);
        return a2.c.d == null && a2.c.a;
    }

    public boolean isStrictEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue jSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        final JSValue jSValue2 = jSValue;
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().isStrictEqual(jSValue2.valueRef);
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Boolean toBoolean() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = new org.liquidplayer.javascript.a();
                this.c.a = JSValue.this.valueRef().toBoolean();
            }
        };
        this.context.sync(a2);
        return a2.c.a;
    }

    public Double toNumber() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = JSValue.this.valueRef().toNumber();
            }
        };
        this.context.sync(a2);
        if (a2.c.d != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)a2.c.d, this.context)));
            return 0.0;
        }
        return a2.c.b;
    }

    public String toString() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = JSValue.this.valueRef().toStringCopy();
            }
        };
        this.context.sync(a2);
        if (a2.c.d != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)a2.c.d, this.context)));
            return null;
        }
        return a2.c.e;
    }

    public JSObject toObject() {
        if (this instanceof JSObject) {
            return (JSObject)this;
        }
        a a2 = new a(){

            @Override
            public void run() {
                this.c = JSValue.this.valueRef().toObject();
            }
        };
        this.context.sync(a2);
        if (a2.c.d != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)a2.c.d, this.context)));
            return new JSObject(this.context);
        }
        return this.context.getObjectFromRef((JNIJSObject)a2.c.c);
    }

    public JSFunction toFunction() {
        JSObject jSObject;
        if (this.isObject().booleanValue() && (jSObject = this.toObject()) instanceof JSFunction) {
            return (JSFunction)jSObject;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not a function"));
        return null;
    }

    public JSBaseArray toJSArray() {
        JSObject jSObject;
        if (this.isObject().booleanValue() && (jSObject = this.toObject()) instanceof JSBaseArray) {
            return (JSBaseArray)jSObject;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not an array"));
        return null;
    }

    public String toJSON() {
        a a2 = new a(){

            @Override
            public void run() {
                this.c = JSValue.this.valueRef().createJSONString();
                if (this.c.d == null) {
                    JSValue jSValue = new JSValue((JNIJSValue)this.c.c, JSValue.this.context);
                    this.c.e = jSValue.isUndefined() != false ? null : jSValue.toString();
                }
            }
        };
        this.context.sync(a2);
        if (a2.c.d != null) {
            this.context.throwJSException(new JSException(new JSValue((JNIJSValue)a2.c.d, this.context)));
            return null;
        }
        return a2.c.e;
    }

    protected Object toJavaObject(Class clazz) {
        if (clazz == Object.class) {
            return this;
        }
        if (clazz == Map.class) {
            return new JSObjectPropertiesMap<Object>(this.toObject(), Object.class);
        }
        if (clazz == List.class) {
            return this.toJSArray();
        }
        if (clazz == String.class) {
            return this.toString();
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return this.toNumber();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(this.toNumber().floatValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return this.toNumber().intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return this.toNumber().longValue();
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return this.toNumber().byteValue();
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return this.toNumber().shortValue();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return this.toBoolean();
        }
        if (clazz.isArray()) {
            return this.toJSArray().toArray(clazz.getComponentType());
        }
        if (JSArray.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toJSArray());
        }
        if (JSObject.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toObject());
        }
        if (JSValue.class.isAssignableFrom(clazz)) {
            return clazz.cast(this);
        }
        return null;
    }

    public int hashCode() {
        if (this.isBoolean().booleanValue()) {
            return this.toBoolean().hashCode();
        }
        if (this.isNumber().booleanValue()) {
            return this.toNumber().hashCode();
        }
        if (this.isString().booleanValue()) {
            return this.toString().hashCode();
        }
        if (this.isUndefined().booleanValue() || this.isNull().booleanValue()) {
            return 0;
        }
        return super.hashCode();
    }

    public JSContext getContext() {
        return this.context;
    }

    public JNIJSValue valueRef() {
        return this.valueRef;
    }

    private abstract class a
    implements Runnable {
        org.liquidplayer.javascript.a c;

        private a() {
        }
    }
}

