/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import org.liquidplayer.javascript.JNIJSObject;
import org.liquidplayer.javascript.JSArrayBuffer;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFloat32Array;
import org.liquidplayer.javascript.JSFloat64Array;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSInt16Array;
import org.liquidplayer.javascript.JSInt32Array;
import org.liquidplayer.javascript.JSInt8Array;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSUint16Array;
import org.liquidplayer.javascript.JSUint32Array;
import org.liquidplayer.javascript.JSUint8Array;
import org.liquidplayer.javascript.JSUint8ClampedArray;
import org.liquidplayer.javascript.JSValue;

public abstract class JSTypedArray<T>
extends JSBaseArray<T> {
    protected JSTypedArray(JSContext ctx, int length, String jsConstructor, Class<T> cls) {
        super(ctx, cls);
        JSFunction jSFunction = new JSFunction(this.context, "_" + jsConstructor, new String[]{"length"}, "return new " + jsConstructor + "(length);", null, 0);
        JSValue jSValue = jSFunction.call(null, length);
        this.valueRef = jSValue.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSTypedArray typedArray, String jsConstructor, Class<T> cls) {
        super(typedArray.context, cls);
        JSFunction jSFunction = new JSFunction(this.context, "_" + jsConstructor, new String[]{"tarr"}, "return new " + jsConstructor + "(tarr);", null, 0);
        JSValue jSValue = jSFunction.call(null, typedArray);
        this.valueRef = jSValue.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSContext ctx, Object object, String jsConstructor, Class<T> cls) {
        super(ctx, cls);
        this.context = ctx;
        JSFunction jSFunction = new JSFunction(this.context, "_" + jsConstructor, new String[]{"obj"}, "return new " + jsConstructor + "(obj);", null, 0);
        JSValue jSValue = jSFunction.call(null, object);
        this.valueRef = jSValue.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSArrayBuffer buffer, int byteOffset, int length, String jsConstructor, Class<T> cls) {
        super(buffer.getJSObject().getContext(), cls);
        JSFunction jSFunction = new JSFunction(this.context, "_" + jsConstructor, new String[]{"buffer,byteOffset,length"}, "return new " + jsConstructor + "(buffer,byteOffset,length);", null, 0);
        JSValue jSValue = jSFunction.call(null, buffer.getJSObject(), byteOffset, length);
        this.valueRef = jSValue.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSArrayBuffer buffer, int byteOffset, String jsConstructor, Class<T> cls) {
        super(buffer.getJSObject().getContext(), cls);
        JSFunction jSFunction = new JSFunction(this.context, "_" + jsConstructor, new String[]{"buffer,byteOffset"}, "return new " + jsConstructor + "(buffer,byteOffset);", null, 0);
        JSValue jSValue = jSFunction.call(null, buffer.getJSObject(), byteOffset);
        this.valueRef = jSValue.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JSArrayBuffer buffer, String jsConstructor, Class<T> cls) {
        super(buffer.getJSObject().getContext(), cls);
        JSFunction jSFunction = new JSFunction(this.context, "_" + jsConstructor, new String[]{"buffer"}, "return new " + jsConstructor + "(buffer);", null, 0);
        JSValue jSValue = jSFunction.call(null, buffer.getJSObject());
        this.valueRef = jSValue.valueRef();
        this.addJSExports();
        this.context.persistObject(this);
    }

    protected JSTypedArray(JNIJSObject objRef, JSContext ctx, Class<T> cls) {
        super(objRef, ctx, cls);
    }

    protected JSTypedArray(JSTypedArray superList, int leftBuffer, int rightBuffer, Class<T> cls) {
        super(superList, leftBuffer, rightBuffer, cls);
    }

    public static JSTypedArray from(JSObject obj) {
        JSTypedArray jSTypedArray = null;
        if (JSTypedArray.isTypedArray(obj)) {
            switch (obj.property("constructor").toObject().property("name").toString()) {
                case "Int8Array": {
                    jSTypedArray = new JSInt8Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Uint8Array": {
                    jSTypedArray = new JSUint8Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Uint8ClampedArray": {
                    jSTypedArray = new JSUint8ClampedArray(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Int16Array": {
                    jSTypedArray = new JSInt16Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Uint16Array": {
                    jSTypedArray = new JSUint16Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Int32Array": {
                    jSTypedArray = new JSInt32Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Uint32Array": {
                    jSTypedArray = new JSUint32Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Float32Array": {
                    jSTypedArray = new JSFloat32Array(obj.toObject().JNI(), obj.getContext());
                    break;
                }
                case "Float64Array": {
                    jSTypedArray = new JSFloat64Array(obj.toObject().JNI(), obj.getContext());
                }
            }
        }
        if (jSTypedArray == null) {
            throw new JSException(obj.getContext(), "Object not a typed array");
        }
        return jSTypedArray;
    }

    public static boolean isTypedArray(JSValue value) {
        if (!value.isObject().booleanValue()) {
            return false;
        }
        JSObject jSObject = value.toObject();
        return jSObject.hasProperty("BYTES_PER_ELEMENT") && jSObject.hasProperty("length") && jSObject.hasProperty("byteOffset") && jSObject.hasProperty("byteLength");
    }

    public JSArrayBuffer buffer() {
        return new JSArrayBuffer(this.property("buffer").toObject());
    }

    public int byteLength() {
        return this.property("byteLength").toNumber().intValue();
    }

    public int byteOffset() {
        return this.property("byteOffset").toNumber().intValue();
    }

    @Override
    protected JSValue arrayElement(int index) {
        JSFunction jSFunction = new JSFunction(this.context, "_getElement", new String[]{"thiz", "index"}, "return thiz[index]", null, 0);
        return jSFunction.call(null, this, index);
    }

    @Override
    protected void arrayElement(int index, T value) {
        JSFunction jSFunction = new JSFunction(this.context, "_setElement", new String[]{"thiz", "index", "value"}, "thiz[index] = value", null, 0);
        jSFunction.call(null, this, index, value);
    }

    @Override
    public boolean add(T val) throws JSException {
        throw new UnsupportedOperationException();
    }

    protected JSTypedArray<T> subarray(int begin, int end) {
        JSObject jSObject = this.property("subarray").toFunction().call(this, begin, end).toObject();
        return (JSTypedArray)jSObject.toJSArray();
    }

    protected JSTypedArray<T> subarray(int begin) {
        JSObject jSObject = this.property("subarray").toFunction().call(this, begin).toObject();
        return (JSTypedArray)jSObject.toJSArray();
    }
}

