/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;
import org.liquidplayer.javascript.c;

public class JSObjectPropertiesMap<V>
extends c
implements Map<String, V> {
    private final Class<V> a;

    public JSObjectPropertiesMap(JSObject object, Class<V> cls) {
        super(object);
        this.a = cls;
    }

    public JSObjectPropertiesMap(JSContext context, Map map, Class<V> cls) {
        super(new JSObject(context, map));
        this.a = cls;
    }

    public JSObjectPropertiesMap(JSContext context, Class<V> cls) {
        super(new JSObject(context));
        this.a = cls;
    }

    @Override
    public int size() {
        return this.propertyNames().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hasProperty(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        String[] stringArray;
        for (String string : stringArray = this.propertyNames()) {
            if (!this.property(string).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        JSValue jSValue = this.property(key.toString());
        if (jSValue.isUndefined().booleanValue()) {
            return null;
        }
        return (V)jSValue.toJavaObject(this.a);
    }

    @Override
    public V put(String key, V value) {
        V v = this.get(key);
        this.property(key, value);
        return v;
    }

    @Override
    public V remove(Object key) {
        V v = this.get(key);
        this.deleteProperty(key.toString());
        return v;
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends V> map) {
        for (String string : map.keySet()) {
            this.put(string, map.get(string));
        }
    }

    @Override
    public void clear() {
        for (String string : this.propertyNames()) {
            this.deleteProperty(string);
        }
    }

    @Override
    @NonNull
    public Set keySet() {
        return new HashSet<String>(Arrays.asList(this.propertyNames()));
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                String[] stringArray = JSObjectPropertiesMap.this.propertyNames();
                if (index > stringArray.length) {
                    throw new IndexOutOfBoundsException();
                }
                return JSObjectPropertiesMap.this.get(stringArray[index]);
            }

            @Override
            public int size() {
                return JSObjectPropertiesMap.this.propertyNames().length;
            }

            @Override
            public boolean contains(Object val) {
                return JSObjectPropertiesMap.this.containsValue(val);
            }
        };
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            @NonNull
            public Iterator<Map.Entry<String, V>> iterator() {
                return new a();
            }

            @Override
            public int size() {
                return JSObjectPropertiesMap.this.propertyNames().length;
            }
        };
    }

    private class a
    implements Iterator<Map.Entry<String, V>> {
        private String b = null;
        private String c = null;

        a() {
            String[] stringArray = JSObjectPropertiesMap.this.propertyNames();
            if (stringArray.length > 0) {
                this.b = stringArray[0];
            }
        }

        @Override
        public boolean hasNext() {
            String[] stringArray;
            if (this.b == null) {
                return false;
            }
            for (String string : stringArray = JSObjectPropertiesMap.this.propertyNames()) {
                if (!this.b.equals(string)) continue;
                return true;
            }
            return false;
        }

        public Map.Entry<String, V> a() {
            int n;
            if (this.b == null) {
                throw new NoSuchElementException();
            }
            String[] stringArray = JSObjectPropertiesMap.this.propertyNames();
            Map.Entry entry = null;
            for (n = 0; n < stringArray.length; ++n) {
                if (!this.b.equals(stringArray[n])) continue;
                final String string = stringArray[n];
                entry = new Map.Entry<String, V>(){

                    public String a() {
                        return (String)string;
                    }

                    @Override
                    public V getValue() {
                        return JSObjectPropertiesMap.this.get(string);
                    }

                    @Override
                    public V setValue(V object) {
                        return JSObjectPropertiesMap.this.put((String)string, object);
                    }

                    @Override
                    public /* synthetic */ Object getKey() {
                        return this.a();
                    }
                };
                break;
            }
            this.c = this.b;
            this.b = n + 1 < stringArray.length ? stringArray[n + 1] : null;
            if (entry != null) {
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.c == null) {
                throw new NoSuchElementException();
            }
            JSObjectPropertiesMap.this.deleteProperty(this.c);
            this.c = null;
        }

        @Override
        public /* synthetic */ Object next() {
            return this.a();
        }
    }
}

