/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.content.Context;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.node.FileSystem;
import org.liquidplayer.node.Modules;

public class Process {
    public static final int kContextFinalizedButProcessStillActive = -222;
    public static final int kMediaAccessPermissionsNone = 0;
    public static final int kMediaAccessPermissionsRead = 1;
    public static final int kMediaAccessPermissionsWrite = 2;
    public static final int kMediaAccessPermissionsRW = 3;
    private boolean notifiedExit = false;
    private long exitCode;
    protected WeakReference<ProcessContext> jscontext = null;
    private boolean isActive = false;
    private boolean isDone = false;
    private FileSystem fs = null;
    private ArrayList<EventListener> listeners = new ArrayList();
    private final long processRef;
    private final String uniqueID;
    private final Context androidCtx;
    private final int mediaAccessMask;

    public Process(Context androidContext, String uniqueID, int mediaAccessMask, EventListener listener) {
        this.addEventListener(listener);
        new Modules(androidContext).setUpNodeModules();
        this.processRef = this.start();
        this.androidCtx = androidContext;
        this.uniqueID = uniqueID;
        this.mediaAccessMask = mediaAccessMask;
    }

    public synchronized void addEventListener(final EventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).sync(new Runnable(){

                @Override
                public void run() {
                    if (Process.this.isActive()) {
                        listener.onProcessStart(Process.this, (JSContext)Process.this.jscontext.get());
                    } else {
                        listener.onProcessExit(Process.this, Long.valueOf(Process.this.exitCode).intValue());
                    }
                }
            });
        } else if (this.isDone) {
            listener.onProcessExit(this, Long.valueOf(this.exitCode).intValue());
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isActive() {
        return this.isActive && this.jscontext.get() != null;
    }

    public void exit(final int exitc) {
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).sync(new Runnable(){

                @Override
                public void run() {
                    if (Process.this.isActive()) {
                        ((ProcessContext)Process.this.jscontext.get()).evaluateScript("process.exit(" + exitc + ");");
                    }
                }
            });
        }
    }

    public void keepAlive() {
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).keepAlive();
        }
    }

    public void letDie() {
        if (this.isActive()) {
            ((ProcessContext)this.jscontext.get()).letDie();
        }
    }

    public static void uninstall(Context ctx, String uniqueID, UninstallScope scope) {
        FileSystem.uninstallLocal(ctx, uniqueID);
        if (scope == UninstallScope.Global) {
            FileSystem.uninstallGlobal(ctx, uniqueID);
        }
    }

    private synchronized void eventOnStart(JSContext ctx) {
        for (EventListener listener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            listener.onProcessStart(this, ctx);
        }
    }

    private synchronized void eventOnAboutToExit(long code) {
        this.exitCode = code;
        for (EventListener listener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            listener.onProcessAboutToExit(this, Long.valueOf(code).intValue());
        }
    }

    private synchronized void eventOnProcessFailed(Exception e) {
        for (EventListener listener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
            listener.onProcessFailed(this, e);
        }
    }

    private void eventOnExit(long code) {
        this.exitCode = code;
        if (!this.notifiedExit) {
            this.notifiedExit = true;
            for (EventListener listener : this.listeners.toArray(new EventListener[this.listeners.size()])) {
                listener.onProcessExit(this, Long.valueOf(code).intValue());
            }
            if (this.fs != null) {
                this.fs.cleanUp();
            }
            this.fs = null;
        }
    }

    private void onNodeStarted(final long mainContext, long ctxGroupRef, long jscCtxRef) {
        final ProcessContext ctx = new ProcessContext(mainContext, new JSContextGroup(ctxGroupRef), jscCtxRef);
        this.jscontext = new WeakReference<ProcessContext>(ctx);
        this.isActive = true;
        ctx.property("__nodedroid_onLoad", new JSFunction(ctx, "__nodedroid_onLoad"){

            public void __nodedroid_onLoad() {
                if (Process.this.isActive()) {
                    ((ProcessContext)Process.this.jscontext.get()).deleteProperty("__nodedroid_onLoad");
                    Process.this.fs = new FileSystem(ctx, Process.this.androidCtx, Process.this.uniqueID, Process.this.mediaAccessMask);
                    Process.this.setFileSystem(mainContext, Process.this.fs.valueRef());
                    JSFunction onExit = new JSFunction(this.context, "onExit"){

                        public void onExit(int code) {
                            Process.this.eventOnAboutToExit(code);
                        }
                    };
                    new JSFunction(this.context, "__onExit", new String[]{"exitFunc"}, "process.on('exit',exitFunc);", null, 0).call(null, onExit);
                    JSFunction onUncaughtException = new JSFunction(this.context, "onUncaughtException"){

                        public void onUncaughtException(JSObject error) {
                            Log.i((String)"Unhandled", (String)"There is an unhandled exception!");
                            Log.i((String)"Unhandled", (String)error.toString());
                            Log.i((String)"Unhandled", (String)error.property("stack").toString());
                            Process.this.eventOnProcessFailed(new JSException(error));
                            this.context.evaluateScript("process.exit(process.exitCode === undefined ? -1 : process.exitCode)");
                        }
                    };
                    new JSFunction(this.context, "__onUncaughtException", new String[]{"handleFunc"}, "process.on('uncaughtException',handleFunc);", null, 0).call(null, onUncaughtException);
                    JSObject stdout = ctx.property("process").toObject().property("stdout").toObject();
                    stdout.property("write", new JSFunction(stdout.getContext(), "write"){

                        public void write(String string) {
                            Log.i((String)"stdout", (String)string);
                        }
                    });
                    JSObject stderr = ctx.property("process").toObject().property("stderr").toObject();
                    stderr.property("write", new JSFunction(stderr.getContext(), "write"){

                        public void write(String string) {
                            Log.e((String)"stderr", (String)string);
                        }
                    });
                    Process.this.eventOnStart((JSContext)Process.this.jscontext.get());
                }
            }
        });
    }

    private void onNodeExit(long exitCode) {
        ProcessContext ctx;
        this.isActive = false;
        if (this.jscontext != null && this.jscontext.get() != null && (ctx = (ProcessContext)this.jscontext.get()) != null) {
            ctx.setDefunct();
        }
        this.jscontext = null;
        this.isDone = true;
        this.eventOnExit(exitCode);
        new Thread(){

            @Override
            public void run() {
                Process.this.dispose(Process.this.processRef);
            }
        }.start();
    }

    private native long start();

    private native void dispose(long var1);

    private native long keepAlive(long var1);

    private native void letDie(long var1);

    private native long setFileSystem(long var1, long var3);

    static {
        JSContext.dummy();
    }

    private class ProcessContext
    extends JSContext {
        private final long mJscCtxRef;
        private long handleRef;
        private int count;

        ProcessContext(long contextRef, JSContextGroup group, long jscCtxRef) {
            super(contextRef, group);
            this.handleRef = 0L;
            this.count = 0;
            this.mJscCtxRef = jscCtxRef;
        }

        @Override
        public long getJSCContext() {
            return this.mJscCtxRef;
        }

        void setDefunct() {
            this.isDefunct = true;
        }

        void keepAlive() {
            if (this.handleRef == 0L && !this.isDefunct.booleanValue()) {
                this.handleRef = Process.this.keepAlive(this.ctxRef());
            }
            ++this.count;
        }

        @Override
        public void sync(Runnable runnable) {
            super.sync(runnable);
        }

        void letDie() {
            if (--this.count < 1 && this.handleRef != 0L && !this.isDefunct.booleanValue()) {
                Process.this.letDie(this.handleRef);
                this.handleRef = 0L;
                this.count = 0;
            }
        }

        @Override
        public void finalize() throws Throwable {
            Process.this.exit(-222);
            Process.this.eventOnExit(Process.this.exitCode);
            super.finalize();
            Process.this.isActive = false;
        }
    }

    public static enum UninstallScope {
        Local,
        Global;

    }

    public static interface EventListener {
        public void onProcessStart(Process var1, JSContext var2);

        public void onProcessAboutToExit(Process var1, int var2);

        public void onProcessExit(Process var1, int var2);

        public void onProcessFailed(Process var1, Exception var2);
    }
}

