/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import java.util.List;
import java.util.Map;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSBaseArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSObjectPropertiesMap;

public class JSValue {
    protected Long valueRef = 3735928559L;
    protected JSContext context = null;
    protected Boolean isDefunct = false;

    protected JSValue() {
    }

    public JSValue(JSContext ctx) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSValue.this.valueRef = JSValue.this.makeUndefined(JSValue.this.context.ctxRef());
            }
        });
    }

    public JSValue(JSContext ctx, final Object val) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                if (val == null) {
                    JSValue.this.valueRef = JSValue.this.makeNull(JSValue.this.context.ctxRef());
                } else if (val instanceof JSValue) {
                    JSValue.this.valueRef = ((JSValue)val).valueRef();
                    JSValue.this.protect(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
                } else if (val instanceof Map) {
                    JSValue.this.valueRef = new JSObjectPropertiesMap<Object>(JSValue.this.context, (Map)val, Object.class).getJSObject().valueRef();
                    JSValue.this.protect(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
                } else if (val instanceof List) {
                    JSValue.this.valueRef = new JSArray<JSValue>(JSValue.this.context, (List)val, JSValue.class).valueRef();
                    JSValue.this.protect(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
                } else if (val.getClass().isArray()) {
                    JSValue.this.valueRef = new JSArray<JSValue>(JSValue.this.context, (Object[])val, JSValue.class).valueRef();
                    JSValue.this.protect(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
                } else {
                    JSValue.this.valueRef = val instanceof Boolean ? Long.valueOf(JSValue.this.makeBoolean(JSValue.this.context.ctxRef(), (Boolean)val)) : (val instanceof Double ? Long.valueOf(JSValue.this.makeNumber(JSValue.this.context.ctxRef(), (Double)val)) : (val instanceof Float ? Long.valueOf(JSValue.this.makeNumber(JSValue.this.context.ctxRef(), Double.valueOf(val.toString()))) : (val instanceof Integer ? Long.valueOf(JSValue.this.makeNumber(JSValue.this.context.ctxRef(), ((Integer)val).doubleValue())) : (val instanceof Long ? Long.valueOf(JSValue.this.makeNumber(JSValue.this.context.ctxRef(), ((Long)val).doubleValue())) : (val instanceof Byte ? Long.valueOf(JSValue.this.makeNumber(JSValue.this.context.ctxRef(), ((Byte)val).doubleValue())) : (val instanceof Short ? Long.valueOf(JSValue.this.makeNumber(JSValue.this.context.ctxRef(), ((Short)val).doubleValue())) : (val instanceof String ? Long.valueOf(JSValue.this.makeString(JSValue.this.context.ctxRef(), (String)val)) : Long.valueOf(JSValue.this.makeUndefined(JSValue.this.context.ctxRef())))))))));
                }
            }
        });
    }

    protected JSValue(long valueRef, JSContext ctx) {
        this.context = ctx;
        if (valueRef != 0L) {
            this.valueRef = valueRef;
        } else {
            this.context.sync(new Runnable(){

                @Override
                public void run() {
                    JSValue.this.valueRef = JSValue.this.makeUndefined(JSValue.this.context.ctxRef());
                }
            });
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public Boolean isUndefined() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isUndefined(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isNull() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isNull(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isBoolean() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isBoolean(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isNumber() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isNumber(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isString() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isString(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isArray() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isArray(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isDate() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isDate(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isObject() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isObject(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean isInstanceOfConstructor(JSObject constructor) {
        try {
            JSFunction instanceOf = new JSFunction(this.context, "_instanceOf", new String[]{"a", "b"}, "return (a instanceof b);", null, 0);
            return instanceOf.call(null, this, constructor).toBoolean();
        }
        catch (JSException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    public boolean isEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue otherJSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        final JSValue ojsv = otherJSValue;
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.isEqual(JSValue.this.context.ctxRef(), JSValue.this.valueRef, ojsv.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.exception == 0L && runnable.jni.bool;
    }

    public boolean isStrictEqual(Object other) {
        if (other == this) {
            return true;
        }
        JSValue otherJSValue = other instanceof JSValue ? (JSValue)other : new JSValue(this.context, other);
        final JSValue ojsv = otherJSValue;
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.isStrictEqual(JSValue.this.context.ctxRef(), JSValue.this.valueRef, ojsv.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Boolean toBoolean() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = new JNIReturnObject();
                this.jni.bool = JSValue.this.toBoolean(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        return runnable.jni.bool;
    }

    public Double toNumber() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.toNumber(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return 0.0;
        }
        return runnable.jni.number;
    }

    public String toString() {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.toStringCopy(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return null;
        }
        return runnable.jni.string;
    }

    public JSObject toObject() {
        if (this instanceof JSObject) {
            return (JSObject)this;
        }
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.toObject(JSValue.this.context.ctxRef(), JSValue.this.valueRef);
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return new JSObject(this.context);
        }
        return this.context.getObjectFromRef(runnable.jni.reference);
    }

    public JSFunction toFunction() {
        JSObject obj;
        if (this.isObject().booleanValue() && (obj = this.toObject()) instanceof JSFunction) {
            return (JSFunction)obj;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not a function"));
        return null;
    }

    public JSBaseArray toJSArray() {
        JSObject obj;
        if (this.isObject().booleanValue() && (obj = this.toObject()) instanceof JSBaseArray) {
            return (JSBaseArray)obj;
        }
        this.context.throwJSException(new JSException(this.context, "JSObject not an array"));
        return null;
    }

    public String toJSON(final int indent) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSValue.this.createJSONString(JSValue.this.context.ctxRef(), JSValue.this.valueRef, indent);
                if (this.jni.exception == 0L) {
                    JSValue json = new JSValue(this.jni.reference, JSValue.this.context);
                    this.jni.string = json.isUndefined() != false ? null : json.toString();
                }
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return null;
        }
        return runnable.jni.string;
    }

    public String toJSON() {
        return this.toJSON(0);
    }

    protected Object toJavaObject(Class clazz) {
        if (clazz == Object.class) {
            return this;
        }
        if (clazz == Map.class) {
            return new JSObjectPropertiesMap<Object>(this.toObject(), Object.class);
        }
        if (clazz == List.class) {
            return this.toJSArray();
        }
        if (clazz == String.class) {
            return this.toString();
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return this.toNumber();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(this.toNumber().floatValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return this.toNumber().intValue();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return this.toNumber().longValue();
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return this.toNumber().byteValue();
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return this.toNumber().shortValue();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return this.toBoolean();
        }
        if (clazz.isArray()) {
            return this.toJSArray().toArray(clazz.getComponentType());
        }
        if (JSArray.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toJSArray());
        }
        if (JSObject.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.toObject());
        }
        if (JSValue.class.isAssignableFrom(clazz)) {
            return clazz.cast(this);
        }
        return null;
    }

    public int hashCode() {
        if (this.isBoolean().booleanValue()) {
            return this.toBoolean().hashCode();
        }
        if (this.isNumber().booleanValue()) {
            return this.toNumber().hashCode();
        }
        if (this.isString().booleanValue()) {
            return this.toString().hashCode();
        }
        if (this.isUndefined().booleanValue() || this.isNull().booleanValue()) {
            return 0;
        }
        return super.hashCode();
    }

    public JSContext getContext() {
        return this.context;
    }

    public Long valueRef() {
        return this.valueRef;
    }

    protected native boolean isUndefined(long var1, long var3);

    protected native boolean isNull(long var1, long var3);

    protected native boolean isBoolean(long var1, long var3);

    protected native boolean isNumber(long var1, long var3);

    protected native boolean isString(long var1, long var3);

    protected native boolean isObject(long var1, long var3);

    protected native boolean isArray(long var1, long var3);

    protected native boolean isDate(long var1, long var3);

    protected native JNIReturnObject isEqual(long var1, long var3, long var5);

    protected native boolean isStrictEqual(long var1, long var3, long var5);

    protected native long makeUndefined(long var1);

    protected native long makeNull(long var1);

    protected native long makeBoolean(long var1, boolean var3);

    protected native long makeNumber(long var1, double var3);

    protected native long makeString(long var1, String var3);

    protected native long makeFromJSONString(long var1, String var3);

    protected native JNIReturnObject createJSONString(long var1, long var3, int var5);

    protected native boolean toBoolean(long var1, long var3);

    protected native JNIReturnObject toNumber(long var1, long var3);

    protected native JNIReturnObject toStringCopy(long var1, long var3);

    protected native JNIReturnObject toObject(long var1, long var3);

    protected native void protect(long var1, long var3);

    protected native void unprotect(long var1, long var3);

    protected native void setException(long var1, long var3);

    private abstract class JNIReturnClass
    implements Runnable {
        JNIReturnObject jni;

        private JNIReturnClass() {
        }
    }

    static class JNIReturnObject {
        public boolean bool;
        public double number;
        public long reference;
        public long exception;
        public String string;

        JNIReturnObject() {
        }
    }
}

