/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.support.annotation.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;

public class JSFunction
extends JSObject {
    private Class<? extends JSObject> subclass = null;
    protected Method method = null;
    private JSObject invokeObject = null;

    public JSFunction(JSContext ctx, final @NonNull String name, final @NonNull String[] parameterNames, final @NonNull String body, final String sourceURL, final int startingLineNumber) {
        this.context = ctx;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                String func = "(function(";
                for (int i = 0; i < parameterNames.length; ++i) {
                    func = func + parameterNames[i];
                    if (i >= parameterNames.length - 1) continue;
                    func = func + ",";
                }
                String function = func = func + "){" + body + "})";
                JSValue.JNIReturnObject jni = JSFunction.this.makeFunction(JSFunction.this.context.ctxRef(), name, function, sourceURL == null ? "<anonymous>" : sourceURL, startingLineNumber);
                JSFunction.this.valueRef = JSFunction.this.testException(jni);
                JSFunction.this.addJSExports();
            }
        });
        this.context.persistObject(this);
    }

    public JSFunction(JSContext ctx, @NonNull String name, @NonNull String body, String ... parameterNames) {
        this(ctx, name, parameterNames, body, null, 1);
    }

    private long testException(JSValue.JNIReturnObject jni) {
        if (jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(jni.exception, this.context)));
            return this.make(this.context.ctxRef());
        }
        return jni.reference;
    }

    public JSFunction(JSContext ctx, final Method method, final Class<? extends JSObject> instanceClass, JSObject invokeObject) {
        this.context = ctx;
        this.method = method;
        this.invokeObject = invokeObject == null ? this : invokeObject;
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSFunction.this.valueRef = JSFunction.this.makeFunctionWithCallback(JSFunction.this.context.ctxRef(), method.getName());
                JSFunction.this.subclass = instanceClass;
                JSFunction.this.addJSExports();
            }
        });
        this.context.persistObject(this);
        this.context.zombies.add(this);
    }

    public JSFunction(JSContext ctx, Method method, Class<? extends JSObject> instanceClass) {
        this(ctx, method, instanceClass, null);
    }

    public JSFunction(JSContext ctx, Method method) {
        this(ctx, method, JSObject.class);
    }

    public JSFunction(JSContext ctx) {
        this(ctx, (String)null);
    }

    public JSFunction(JSContext ctx, String methodName, final Class<? extends JSObject> instanceClass, JSObject invokeObject) {
        Method[] methods;
        this.context = ctx;
        this.invokeObject = invokeObject == null ? this : invokeObject;
        String name = methodName == null ? "__nullFunc" : methodName;
        for (Method method : methods = this.invokeObject.getClass().getMethods()) {
            if (!method.getName().equals(name)) continue;
            this.method = method;
            break;
        }
        if (this.method == null) {
            this.context.sync(new Runnable(){

                @Override
                public void run() {
                    JSFunction.this.valueRef = JSFunction.this.makeUndefined(JSFunction.this.context.ctxRef());
                }
            });
            this.context.throwJSException(new JSException(this.context, "No such method. Did you make it public?"));
        }
        this.context.sync(new Runnable(){

            @Override
            public void run() {
                JSFunction.this.valueRef = JSFunction.this.makeFunctionWithCallback(JSFunction.this.context.ctxRef(), JSFunction.this.method.getName());
                JSFunction.this.subclass = instanceClass;
                JSFunction.this.addJSExports();
            }
        });
        this.context.persistObject(this);
        this.context.zombies.add(this);
    }

    public JSFunction(JSContext ctx, String methodName, Class<? extends JSObject> instanceClass) {
        this(ctx, methodName, instanceClass, null);
    }

    public JSFunction(JSContext ctx, String methodName) {
        this(ctx, methodName, JSObject.class);
    }

    public JSFunction(long objRef, JSContext context) {
        super(objRef, context);
    }

    public JSValue call(JSObject thiz, Object ... args) {
        return this.apply(thiz, args);
    }

    private long[] argsToValueRefs(Object[] args) {
        ArrayList<JSArray<Object>> largs = new ArrayList<JSArray<Object>>();
        if (args != null) {
            for (Object o : args) {
                if (o == null) break;
                JSValue v = o.getClass() == Void.class ? new JSArray<Object>(this.context) : (o instanceof JSValue ? (JSValue)o : (o instanceof Object[] ? new JSArray<Object>(this.context, (Object[])o, Object.class) : new JSValue(this.context, o)));
                largs.add((JSArray<Object>)v);
            }
        }
        long[] valueRefs = new long[largs.size()];
        for (int i = 0; i < largs.size(); ++i) {
            valueRefs[i] = ((JSValue)largs.get(i)).valueRef();
        }
        return valueRefs;
    }

    public JSValue apply(final JSObject thiz, final Object[] args) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSFunction.this.callAsFunction(JSFunction.this.context.ctxRef(), JSFunction.this.valueRef, thiz == null ? 0L : thiz.valueRef(), JSFunction.this.argsToValueRefs(args));
            }
        };
        this.context.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.context.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return new JSValue(this.context);
        }
        return new JSValue(runnable.jni.reference, this.context);
    }

    public JSValue call() {
        return this.call(null, new Object[0]);
    }

    public JSObject newInstance(final Object ... args) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                this.jni = JSFunction.this.callAsConstructor(JSFunction.this.context.ctxRef(), JSFunction.this.valueRef, JSFunction.this.argsToValueRefs(args));
            }
        };
        this.context.sync(runnable);
        return this.context.getObjectFromRef(this.testException(runnable.jni));
    }

    private long functionCallback(long thisObjectRef, long[] argumentsValueRef, long exceptionRefRef) {
        try {
            JSValue[] args = new JSValue[argumentsValueRef.length];
            for (int i = 0; i < argumentsValueRef.length; ++i) {
                JSObject obj = this.context.getObjectFromRef(argumentsValueRef[i], false);
                args[i] = obj != null ? obj : new JSValue(argumentsValueRef[i], this.context);
            }
            JSObject thiz = this.context.getObjectFromRef(thisObjectRef);
            JSValue value = this.function(thiz, args, this.invokeObject);
            this.setException(0L, exceptionRefRef);
            return value == null ? 0L : value.valueRef();
        }
        catch (JSException e) {
            e.printStackTrace();
            this.setException(e.getError().valueRef(), exceptionRefRef);
            return 0L;
        }
    }

    protected JSValue function(JSObject thiz, JSValue[] args) {
        return this.function(thiz, args, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSValue function(JSObject thiz, JSValue[] args, JSObject invokeObject) {
        JSValue returnValue;
        Class<?>[] pType = this.method.getParameterTypes();
        Object[] passArgs = new Object[pType.length];
        for (int i = 0; i < passArgs.length; ++i) {
            if (i < args.length) {
                if (args[i] == null) {
                    passArgs[i] = null;
                    continue;
                }
                passArgs[i] = args[i].toJavaObject(pType[i]);
                continue;
            }
            passArgs[i] = null;
        }
        JSObject stack = null;
        try {
            stack = invokeObject.getThis();
            invokeObject.setThis(thiz);
            Object ret = this.method.invoke((Object)invokeObject, passArgs);
            returnValue = ret == null ? null : (ret instanceof JSValue ? (JSValue)ret : new JSValue(this.context, ret));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.context.throwJSException(new JSException(this.context, e.toString()));
            returnValue = null;
        }
        catch (IllegalAccessException e) {
            this.context.throwJSException(new JSException(this.context, e.toString()));
            returnValue = null;
        }
        finally {
            invokeObject.setThis(stack);
        }
        return returnValue;
    }

    protected void constructor(final long thisObj, final JSValue[] args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JSValue proto = JSFunction.this.prototype();
                try {
                    Constructor defaultConstructor = JSFunction.this.subclass.getConstructor(new Class[0]);
                    JSObject thiz = (JSObject)defaultConstructor.newInstance(new Object[0]);
                    thiz.context = JSFunction.this.context;
                    thiz.valueRef = thisObj;
                    thiz.addJSExports();
                    JSFunction.this.function(thiz, args);
                    JSFunction.this.context.persistObject(thiz);
                    JSFunction.this.context.zombies.add(thiz);
                }
                catch (NoSuchMethodException e) {
                    String error = e.toString() + "If " + JSFunction.this.subclass.getName() + " is an embedded class, did you specify it as 'static'?";
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, error));
                }
                catch (InvocationTargetException e) {
                    String error = e.toString() + "; Did you remember to call super?";
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, error));
                }
                catch (IllegalAccessException e) {
                    String error = e.toString() + "; Is your constructor public?";
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, error));
                }
                catch (InstantiationException e) {
                    JSFunction.this.context.throwJSException(new JSException(JSFunction.this.context, e.toString()));
                }
            }
        };
        this.context.sync(runnable);
    }

    private void constructorCallback(long thisObjectRef, long[] argumentsValueRef, long exceptionRefRef) {
        try {
            JSValue[] args = new JSValue[argumentsValueRef.length];
            for (int i = 0; i < argumentsValueRef.length; ++i) {
                JSObject obj = this.context.getObjectFromRef(argumentsValueRef[i], false);
                args[i] = obj != null ? obj : new JSValue(argumentsValueRef[i], this.context);
            }
            this.constructor(thisObjectRef, args);
            this.setException(0L, exceptionRefRef);
        }
        catch (JSException e) {
            this.setException(e.getError().valueRef(), exceptionRefRef);
        }
    }

    protected JSFunction() {
    }

    protected native long makeFunctionWithCallback(long var1, String var3);

    private abstract class JNIReturnClass
    implements Runnable {
        JSValue.JNIReturnObject jni;

        private JNIReturnClass() {
        }
    }
}

