/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSError;
import org.liquidplayer.javascript.JSValue;

public class JSException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private JSError error;

    public JSException(JSValue error) {
        super(new JSError(error).message());
        this.error = new JSError(error);
    }

    public JSException(JSContext ctx, String message) {
        super(message == null ? "Error" : message);
        try {
            this.error = new JSError(ctx, message == null ? "Error" : message);
        }
        catch (JSException e) {
            this.error = null;
        }
    }

    public JSError getError() {
        return this.error;
    }

    public String stack() {
        return this.error != null ? this.error.stack() : "undefined";
    }

    public String name() {
        return this.error != null ? this.error.name() : "JSError";
    }

    @Override
    public String toString() {
        if (this.error != null) {
            try {
                return this.error.toString();
            }
            catch (JSException e) {
                return "Unknown Error";
            }
        }
        return "Unknown Error";
    }
}

