/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.node;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.liquidplayer.javascript.JSContext;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSValue;

class FileSystem
extends JSObject {
    @JSObject.jsexport(attributes=2)
    private JSObject.Property<JSObject> access_;
    @JSObject.jsexport(attributes=2)
    private JSObject.Property<JSObject> aliases_;
    @JSObject.jsexport(attributes=2)
    private JSObject.Property<JSFunction> fs;
    @JSObject.jsexport(attributes=2)
    private JSObject.Property<JSFunction> alias;
    @JSObject.jsexport
    private JSObject.Property<String> cwd;
    private final Context androidCtx;
    private final String uniqueID;
    private final String sessionID;
    private static final Object sessionMutex = new Object();
    private static final ArrayList<String> activeSessions = new ArrayList();
    private static long lastSessionBark = 0L;
    private static final long SESSION_WATCHDOG_TIMER = 300000L;

    private String realDir(String dir) {
        JSValue v = this.getContext().evaluateScript("(function(){try {return require('fs').realpathSync('" + dir + "');}catch(e){}})()");
        if (v.isUndefined().booleanValue() || v.isNull().booleanValue()) {
            return null;
        }
        return v.toString();
    }

    private String mkdir(String dir) {
        if (new File(dir).mkdirs()) {
            Log.i((String)"mkdir", (String)("Created directory " + dir));
        }
        return this.realDir(dir);
    }

    private void symlink(String target, String linkpath) {
        this.getContext().evaluateScript("(function(){require('fs').symlinkSync('" + target + "','" + linkpath + "');})()");
    }

    private static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    static void deleteRecursive(File fileOrDirectory) {
        try {
            if (fileOrDirectory.isDirectory() && !FileSystem.isSymlink(fileOrDirectory) && fileOrDirectory.listFiles() != null) {
                for (File child : fileOrDirectory.listFiles()) {
                    FileSystem.deleteRecursive(child);
                }
            }
        }
        catch (IOException e) {
            Log.e((String)"deleteRecursive", (String)e.getMessage());
        }
        if (!fileOrDirectory.delete()) {
            Log.e((String)"deleteRecursive", (String)("Failed to delete " + fileOrDirectory.getAbsolutePath()));
        }
    }

    private void linkMedia(String type, String dir, String home, int mediaPermissionsMask) {
        String media;
        File external = Environment.getExternalStoragePublicDirectory((String)type);
        if (external.mkdirs()) {
            Log.i((String)"linkMedia", (String)("Created external directory " + external));
        }
        if ((media = this.realDir(external.getAbsolutePath())) != null) {
            this.symlink(media, home + "/public/media/" + dir);
            this.aliases_.get().property("/home/public/media/" + dir, media);
            this.access_.get().property("/home/public/media/" + dir, mediaPermissionsMask);
        }
    }

    private void setUp(int mediaPermissionsMask) {
        String suffix = "/__org.liquidplayer.node__/_" + this.uniqueID;
        String sessionSuffix = "/__org.liquidplayer.node__/sessions/" + this.sessionID;
        String home = this.mkdir(this.androidCtx.getCacheDir().getAbsolutePath() + sessionSuffix + "/home");
        this.aliases_.get().property("/home", home);
        this.access_.get().property("/home", 1);
        String module = this.mkdir(this.androidCtx.getFilesDir().getAbsolutePath() + suffix + "/module");
        this.symlink(module, home + "/module");
        this.aliases_.get().property("/home/module", module);
        this.access_.get().property("/home/module", 1);
        String temp = this.mkdir(this.androidCtx.getCacheDir().getAbsolutePath() + sessionSuffix + "/temp");
        this.symlink(temp, home + "/temp");
        this.aliases_.get().property("/home/temp", temp);
        this.access_.get().property("/home/temp", 3);
        String cache = this.mkdir(this.androidCtx.getCacheDir().getAbsolutePath() + suffix + "/cache");
        this.symlink(cache, home + "/cache");
        this.aliases_.get().property("/home/cache", cache);
        this.access_.get().property("/home/cache", 3);
        String local = this.mkdir(this.androidCtx.getFilesDir().getAbsolutePath() + suffix + "/local");
        this.symlink(local, home + "/local");
        this.aliases_.get().property("/home/local", local);
        this.access_.get().property("/home/local", 3);
        String node_modules = this.androidCtx.getFilesDir().getAbsolutePath() + "/__org.liquidplayer.node__/node_modules";
        this.symlink(node_modules, home + "/node_modules");
        this.aliases_.get().property("/home/node_modules", node_modules);
        this.access_.get().property("/home/node_modules", 1);
        String state = Environment.getExternalStorageState();
        if (!("mounted".equals(state) || "mounted_ro".equals(state) || "shared".equals(state))) {
            Log.w((String)"FileSystem", (String)"Warning: external storage is unavailable");
        } else {
            File external;
            if ("mounted_ro".equals(state) && (mediaPermissionsMask & 2) != 0) {
                Log.w((String)"FileSystem", (String)"Warning: external storage is read only.");
                mediaPermissionsMask &= 0xFFFFFFFD;
            }
            if (!new File(home + "/public").mkdirs()) {
                Log.e((String)"FileSystem", (String)"Error: Failed to set up /home/public");
            }
            if ((external = this.androidCtx.getExternalFilesDir(null)) != null) {
                String externalPersistent = this.mkdir(external.getAbsolutePath() + "/LiquidPlayer/" + this.uniqueID);
                this.symlink(externalPersistent, home + "/public/data");
                this.aliases_.get().property("/home/public/data", externalPersistent);
                this.access_.get().property("/home/public/data", 3);
            }
            if (!new File(home + "/public/media").mkdirs()) {
                Log.e((String)"FileSystem", (String)"Error: Failed to set up /home/public/media");
            }
            if ((mediaPermissionsMask & 2) != 0 && ContextCompat.checkSelfPermission((Context)this.androidCtx, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                mediaPermissionsMask &= 0xFFFFFFFD;
            }
            this.linkMedia(Environment.DIRECTORY_MOVIES, "Movies", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_PICTURES, "Pictures", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_DCIM, "DCIM", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_ALARMS, "Alarms", home, mediaPermissionsMask);
            if (Build.VERSION.SDK_INT >= 19) {
                this.linkMedia(Environment.DIRECTORY_DOCUMENTS, "Documents", home, mediaPermissionsMask);
            }
            this.linkMedia(Environment.DIRECTORY_DOWNLOADS, "Downloads", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_MUSIC, "Music", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_NOTIFICATIONS, "Notifications", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_PODCASTS, "Podcasts", home, mediaPermissionsMask);
            this.linkMedia(Environment.DIRECTORY_RINGTONES, "Ringtones", home, mediaPermissionsMask);
        }
        this.cwd.set("/home");
    }

    private static void uninstallSession(Context ctx, String sessionID) {
        String sessionSuffix = "/__org.liquidplayer.node__/sessions/" + sessionID;
        File session = new File(ctx.getCacheDir().getAbsolutePath() + sessionSuffix);
        Log.i((String)"sessionWatchdog", (String)("deleting session " + session));
        FileSystem.deleteRecursive(session);
    }

    static void uninstallLocal(Context ctx, String serviceID) {
        String suffix = "/__org.liquidplayer.node__/_" + serviceID;
        FileSystem.deleteRecursive(new File(ctx.getCacheDir().getAbsolutePath() + suffix));
        FileSystem.deleteRecursive(new File(ctx.getFilesDir().getAbsolutePath() + suffix));
    }

    static void uninstallGlobal(Context ctx, String serviceID) {
        File external = ctx.getExternalFilesDir(null);
        if (external != null) {
            String externalPersistent = external.getAbsolutePath() + "/LiquidPlayer/" + serviceID;
            FileSystem.deleteRecursive(new File(externalPersistent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileSystem(JSContext ctx, Context androidCtx, String uniqueID, int mediaPermissionsMask) {
        super(ctx);
        this.androidCtx = androidCtx;
        FileSystem.sessionWatchdog(androidCtx);
        this.uniqueID = uniqueID;
        this.sessionID = UUID.randomUUID().toString();
        Object object = sessionMutex;
        synchronized (object) {
            activeSessions.add(this.sessionID);
        }
        this.aliases_.set(new JSObject(ctx));
        this.access_.set(new JSObject(ctx));
        this.setUp(mediaPermissionsMask);
        this.fs.set(new JSFunction(ctx, "fs", "if (!file.startsWith('/')) { file = ''+this.cwd+'/'+file; }try { file = require('path').resolve(file); } catch (e) {console.log(e);}var access = 0;var keys = Object.keys(this.aliases_).sort().reverse();for (var p=0; p<keys.length; p++) {    if (file.startsWith(this.aliases_[keys[p]] + '/')) {        file = keys[p] + '/' + file.substring(this.aliases_[keys[p]].length + 1);        break;    } else if (file == this.aliases_[keys[p]]) {        file = keys[p];        break;    }}var acckeys = Object.keys(this.access_).sort().reverse();for (var p=0; p<acckeys.length; p++) {    if (file.startsWith(acckeys[p] + '/') || acckeys[p]==file) {        access = this.access_[acckeys[p]];        break;    }}var newfile = file;for (var p=0; p<keys.length; p++) {    if (file.startsWith(keys[p] + '/')) {        newfile = this.aliases_[keys[p]] +'/'+file.substring(keys[p].length + 1);        break;    } else if (file == keys[p]) {        newfile = this.aliases_[keys[p]];        break;    }}return [access,newfile];", "file"));
        this.alias.set(new JSFunction(ctx, "alias", "var keys = Object.keys(this.aliases_).sort().reverse();for (var p=0; p<keys.length; p++) {   if (file.startsWith(this.aliases_[keys[p]] + '/')) {       file = keys[p] + '/' + file.substring(this.aliases_[keys[p]].length + 1);       break;   } else if (file == this.aliases_[keys[p]]) {       file = keys[p];       break;   }}return file;", "file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sessionWatchdog(Context ctx) {
        String sessionsSuffix = "/__org.liquidplayer.node__/sessions";
        if (new Date().getTime() - lastSessionBark > 300000L) {
            File sessions = new File(ctx.getCacheDir().getAbsolutePath() + "/__org.liquidplayer.node__/sessions");
            File[] files = sessions.listFiles();
            if (files != null) {
                for (File session : files) {
                    boolean isActive;
                    Object object = sessionMutex;
                    synchronized (object) {
                        isActive = activeSessions.contains(session.getName());
                    }
                    if (isActive) continue;
                    FileSystem.uninstallSession(ctx, session.getName());
                }
            }
            lastSessionBark = new Date().getTime();
        }
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() {
        boolean needClean;
        Object object = sessionMutex;
        synchronized (object) {
            needClean = activeSessions.contains(this.sessionID);
            activeSessions.remove(this.sessionID);
        }
        if (needClean) {
            FileSystem.uninstallSession(this.androidCtx, this.sessionID);
        }
    }
}

