/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

public class JSContextGroup {
    private Long group;
    private boolean hasDedicatedThread = false;

    public JSContextGroup() {
        this.group = this.create();
        this.hasDedicatedThread = false;
    }

    public JSContextGroup(Long groupRef) {
        this.group = groupRef;
        this.hasDedicatedThread = this.isManaged(this.group);
        if (this.hasDedicatedThread) {
            JSContextGroup.release(this.group);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.hasDedicatedThread) {
            JSContextGroup.release(this.group);
        }
    }

    boolean hasDedicatedThread() {
        return this.hasDedicatedThread;
    }

    public Long groupRef() {
        return this.group;
    }

    public boolean equals(Object other) {
        return other != null && this == other || other instanceof JSContextGroup && this.groupRef() != null && this.groupRef() != 0L && this.groupRef().equals(((JSContextGroup)other).groupRef());
    }

    protected native long create();

    protected static native void release(long var0);

    protected native boolean isManaged(long var1);
}

