/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.service;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.support.v4.os.ResultReceiver;
import android.support.v7.app.AppCompatActivity;

class PermissionHelper {
    private static final String KEY_RESULT_RECEIVER = "resultReceiver";
    private static final String KEY_PERMISSIONS = "permissions";
    private static final String KEY_GRANT_RESULTS = "grantResults";
    private static final String KEY_REQUEST_CODE = "requestCode";

    PermissionHelper() {
    }

    static <T extends Context> void requestPermissions(final T context, String[] permissions, int requestCode, String notificationTitle, String notificationText, int notificationIcon) {
        ResultReceiver resultReceiver = new ResultReceiver(new Handler(Looper.getMainLooper())){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                int[] grantResults;
                String[] outPermissions = resultData.getStringArray(PermissionHelper.KEY_PERMISSIONS);
                if (outPermissions == null) {
                    outPermissions = new String[]{};
                }
                if ((grantResults = resultData.getIntArray(PermissionHelper.KEY_GRANT_RESULTS)) == null) {
                    grantResults = new int[]{};
                }
                ((ActivityCompat.OnRequestPermissionsResultCallback)context).onRequestPermissionsResult(resultCode, outPermissions, grantResults);
            }
        };
        Intent permIntent = new Intent(context, PermissionRequestActivity.class);
        permIntent.putExtra(KEY_RESULT_RECEIVER, (Parcelable)resultReceiver);
        permIntent.putExtra(KEY_PERMISSIONS, permissions);
        permIntent.putExtra(KEY_REQUEST_CODE, requestCode);
        TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
        stackBuilder.addNextIntent(permIntent);
        PendingIntent permPendingIntent = stackBuilder.getPendingIntent(0, 0x8000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setSmallIcon(notificationIcon).setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationText).setOngoing(true).setAutoCancel(true).setWhen(0L).setContentIntent(permPendingIntent).setStyle(null);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(requestCode, builder.build());
    }

    public static class PermissionRequestActivity
    extends AppCompatActivity {
        ResultReceiver resultReceiver;
        String[] permissions;
        int requestCode;

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            Bundle resultData = new Bundle();
            resultData.putStringArray(PermissionHelper.KEY_PERMISSIONS, permissions);
            resultData.putIntArray(PermissionHelper.KEY_GRANT_RESULTS, grantResults);
            this.resultReceiver.send(requestCode, resultData);
            this.finish();
        }

        protected void onStart() {
            super.onStart();
            this.resultReceiver = (ResultReceiver)this.getIntent().getParcelableExtra(PermissionHelper.KEY_RESULT_RECEIVER);
            this.permissions = this.getIntent().getStringArrayExtra(PermissionHelper.KEY_PERMISSIONS);
            this.requestCode = this.getIntent().getIntExtra(PermissionHelper.KEY_REQUEST_CODE, 0);
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)this.requestCode);
        }
    }
}

