/*
 * Decompiled with CFR 0.152.
 */
package org.liquidplayer.javascript;

import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.util.LongSparseArray;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import org.liquidplayer.javascript.JSArray;
import org.liquidplayer.javascript.JSContextGroup;
import org.liquidplayer.javascript.JSException;
import org.liquidplayer.javascript.JSFunction;
import org.liquidplayer.javascript.JSObject;
import org.liquidplayer.javascript.JSTypedArray;
import org.liquidplayer.javascript.JSValue;

public class JSContext
extends JSObject {
    private int mContextThreadTid = 0;
    private JSContextGroup contextGroup = null;
    protected Long ctx;
    private IJSExceptionHandler exceptionHandler;
    private boolean isThreadSpecific = false;
    private final LongSparseArray<WeakReference<JSObject>> objects = new LongSparseArray();
    private final Object objectsMutex = new Object();

    public static void dummy() {
    }

    protected void sync(final Runnable runnable) {
        if (!this.isThreadSpecific || Process.myTid() == this.mContextThreadTid) {
            runnable.run();
        } else {
            final Semaphore sempahore = new Semaphore(0);
            Runnable syncRunner = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    sempahore.release();
                }
            };
            this.runInContextGroup(this.contextGroup.groupRef(), syncRunner);
            sempahore.acquireUninterruptibly();
        }
    }

    protected void async(Runnable runnable) {
        if (!this.isThreadSpecific) {
            runnable.run();
        } else {
            this.runInContextGroup(this.contextGroup.groupRef(), runnable);
        }
    }

    private void inContextCallback(Runnable runnable) {
        this.mContextThreadTid = Process.myTid();
        runnable.run();
    }

    protected JSContext(long ctxHandle, JSContextGroup group) {
        this.context = this;
        this.contextGroup = group;
        this.isThreadSpecific = true;
        this.ctx = ctxHandle;
        this.valueRef = this.getGlobalObject(this.ctx);
        this.addJSExports();
    }

    public JSContext() {
        this(new JSContextGroup());
    }

    public JSContext(final JSContextGroup inGroup) {
        this.context = this;
        this.contextGroup = inGroup;
        this.sync(new Runnable(){

            @Override
            public void run() {
                JSContext.this.ctx = JSContext.this.createInGroup(inGroup.groupRef());
                JSContext.this.valueRef = JSContext.this.getGlobalObject(JSContext.this.ctx);
                JSContext.this.addJSExports();
            }
        });
    }

    public JSContext(Class<?> iface) {
        this(new JSContextGroup(), iface);
    }

    public JSContext(JSContextGroup inGroup, Class<?> iface) {
        this(inGroup);
        Method[] methods;
        for (Method m : methods = iface.getDeclaredMethods()) {
            JSFunction f = new JSFunction(this.context, m, JSObject.class, (JSObject)this.context);
            this.property(m.getName(), f);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isDefunct.booleanValue()) {
            this.release(this.ctx);
        }
    }

    public void setExceptionHandler(IJSExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public void clearExceptionHandler() {
        this.exceptionHandler = null;
    }

    public void throwJSException(JSException exception) {
        if (this.exceptionHandler == null) {
            throw exception;
        }
        IJSExceptionHandler temp = this.exceptionHandler;
        this.exceptionHandler = null;
        temp.handle(exception);
        this.exceptionHandler = temp;
    }

    public JSContextGroup getGroup() {
        Long g = this.getGroup(this.ctx);
        if (g == 0L) {
            return null;
        }
        return new JSContextGroup(g);
    }

    public Long ctxRef() {
        return this.ctx;
    }

    public JSValue evaluateScript(final @NonNull String script, final String sourceURL, final int startingLineNumber) {
        JNIReturnClass runnable = new JNIReturnClass(){

            @Override
            public void run() {
                String src = sourceURL == null ? "<code>" : sourceURL;
                this.jni = JSContext.this.evaluateScript(JSContext.this.ctx, script, src, startingLineNumber);
            }
        };
        this.sync(runnable);
        if (runnable.jni.exception != 0L) {
            this.throwJSException(new JSException(new JSValue(runnable.jni.exception, this.context)));
            return new JSValue(this);
        }
        return new JSValue(runnable.jni.reference, this);
    }

    public JSValue evaluateScript(String script) {
        return this.evaluateScript(script, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistObject(JSObject obj) {
        Object object = this.objectsMutex;
        synchronized (object) {
            this.objects.put(obj.valueRef().longValue(), new WeakReference<JSObject>(obj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeObject(JSObject obj) {
        Object object = this.objectsMutex;
        synchronized (object) {
            this.objects.remove(obj.valueRef().longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSObject getObjectFromRef(long objRef, boolean create) {
        WeakReference wr;
        if (objRef == this.valueRef()) {
            this.unprotect(this.context.ctxRef(), objRef);
            return this;
        }
        Object object = this.objectsMutex;
        synchronized (object) {
            wr = (WeakReference)this.objects.get(objRef);
        }
        JSFunction obj = null;
        if (wr != null && (obj = (JSArray)wr.get()) != null) {
            obj.unprotect(this.ctxRef(), objRef);
        }
        if (obj == null && create) {
            obj = new JSObject(objRef, this);
            if (this.isArray(this.ctxRef(), objRef)) {
                obj = new JSArray(objRef, this);
                this.protect(this.ctxRef(), objRef);
            } else if (JSTypedArray.isTypedArray(obj)) {
                obj = JSTypedArray.from(obj);
            } else if (this.isFunction(this.ctxRef(), objRef)) {
                obj = new JSFunction(objRef, this);
                this.protect(this.ctxRef(), objRef);
            }
        }
        return obj;
    }

    protected JSObject getObjectFromRef(long objRef) {
        return this.getObjectFromRef(objRef, true);
    }

    protected native void runInContextGroup(long var1, Runnable var3);

    protected native long create();

    protected native long createInGroup(long var1);

    protected native long retain(long var1);

    protected native long release(long var1);

    protected native long getGroup(long var1);

    protected native long getGlobalObject(long var1);

    protected native JSValue.JNIReturnObject evaluateScript(long var1, String var3, String var4, int var5);

    static {
        System.loadLibrary("node");
        System.loadLibrary("liquidcore");
    }

    private abstract class JNIReturnClass
    implements Runnable {
        JSValue.JNIReturnObject jni;

        private JNIReturnClass() {
        }
    }

    public static interface IJSExceptionHandler {
        public void handle(JSException var1);
    }
}

