/*
 * Decompiled with CFR 0.152.
 */
package com.lwj.widget.viewpagerindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.lwj.widget.viewpagerindicator.R;

public class ViewPagerIndicator
extends View {
    private Path mPath;
    private Paint paintFill;
    private Paint paintStroke;
    private int mNum;
    private float mRadius;
    private float mRadiusSelected;
    private float mLength;
    private float mHeight;
    private float mOffset;
    private int mSelected_color;
    private int mDefault_color;
    private int mIndicatorType;
    private int mDistanceType;
    private float mDistance;
    private int mPosition;
    private static final float M = 0.55191505f;
    private float mPercent;
    private boolean mIsLeft;
    private boolean mIsInfiniteCircle;
    private boolean mAnimation;
    private Point[] mSpringPoint = new Point[6];
    private Point[] mControlPoint = new Point[9];
    private CenterPoint mCenterPoint = new CenterPoint();

    public ViewPagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setStyleable(context, attrs);
        this.initPaint();
    }

    private void setStyleable(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ViewPagerIndicator);
        this.mSelected_color = array.getColor(R.styleable.ViewPagerIndicator_vpi_selected_color, -1);
        this.mDefault_color = array.getColor(R.styleable.ViewPagerIndicator_vpi_default_color, -3289651);
        this.mRadius = array.getDimension(R.styleable.ViewPagerIndicator_vpi_radius, 20.0f);
        this.mRadiusSelected = array.getDimension(R.styleable.ViewPagerIndicator_vpi_radius_selected, this.mRadius);
        this.mLength = array.getDimension(R.styleable.ViewPagerIndicator_vpi_length, 2.0f * this.mRadius);
        this.mDistance = array.getDimension(R.styleable.ViewPagerIndicator_vpi_distance, 3.0f * this.mRadius);
        this.mDistanceType = array.getInteger(R.styleable.ViewPagerIndicator_vpi_distanceType, 0);
        this.mIndicatorType = array.getInteger(R.styleable.ViewPagerIndicator_vpi_indicatorType, 1);
        this.mNum = array.getInteger(R.styleable.ViewPagerIndicator_vpi_num, 0);
        this.mAnimation = array.getBoolean(R.styleable.ViewPagerIndicator_vpi_animation, true);
        array.recycle();
        switch (this.mIndicatorType) {
            case 3: {
                this.mControlPoint = new Point[]{new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point(), new Point()};
                break;
            }
            case 4: {
                this.mSpringPoint = new Point[]{new Point(), new Point(), new Point(), new Point(), new Point(), new Point()};
            }
        }
        this.invalidate();
    }

    private void initPaint() {
        this.paintStroke = new Paint();
        this.paintFill = new Paint();
        this.mPath = new Path();
        this.paintFill.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintFill.setColor(this.mSelected_color);
        this.paintFill.setAntiAlias(true);
        this.paintFill.setStrokeWidth(3.0f);
        this.paintStroke.setStyle(Paint.Style.FILL);
        this.paintStroke.setColor(this.mDefault_color);
        this.paintStroke.setAntiAlias(true);
        this.paintStroke.setStrokeWidth(3.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mNum <= 0) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        canvas.translate((float)(width / 2), (float)(height / 2));
        this.initPaint();
        switch (this.mDistanceType) {
            case 1: {
                break;
            }
            case 0: {
                this.mDistance = 3.0f * this.mRadius;
                break;
            }
            case 2: {
                this.mDistance = this.mIndicatorType == 2 ? (float)(width / (this.mNum + 1)) : (float)(width / this.mNum);
            }
        }
        switch (this.mIndicatorType) {
            case 1: {
                for (int i = 0; i < this.mNum; ++i) {
                    canvas.drawCircle((float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                }
                canvas.drawCircle((float)(-(this.mNum - 1)) * 0.5f * this.mDistance + this.mOffset, 0.0f, this.mRadiusSelected, this.paintFill);
                break;
            }
            case 0: {
                this.paintStroke.setStrokeWidth(this.mRadius);
                float startX = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance - this.mLength / 2.0f;
                float stopX = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + this.mLength / 2.0f;
                for (int i = 0; i < this.mNum; ++i) {
                    canvas.drawLine(startX + (float)i * this.mDistance, 0.0f, stopX + (float)i * this.mDistance, 0.0f, this.paintStroke);
                }
                this.paintFill.setStrokeWidth(this.mRadius);
                float startF = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance - this.mLength / 2.0f + this.mOffset;
                float stopF = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + this.mLength / 2.0f + this.mOffset;
                canvas.drawLine(startF, 0.0f, stopF, 0.0f, this.paintFill);
                break;
            }
            case 2: {
                if (this.mPosition == this.mNum - 1) {
                    float leftClose = (float)(-this.mNum) * 0.5f * this.mDistance - this.mRadius;
                    float rightClose = leftClose + 2.0f * this.mRadius + this.mOffset;
                    float topClose = -this.mRadius;
                    float bottomClose = this.mRadius;
                    RectF rectClose = new RectF(leftClose, topClose, rightClose, bottomClose);
                    canvas.drawRoundRect(rectClose, this.mRadius, this.mRadius, this.paintStroke);
                    float rightOpen = (float)(-this.mNum) * 0.5f * this.mDistance + (float)this.mNum * this.mDistance + this.mRadius;
                    float leftOpen = rightOpen - 2.0f * this.mRadius - this.mDistance + this.mOffset;
                    float topOpen = -this.mRadius;
                    float bottomOpen = this.mRadius;
                    RectF rectOpen = new RectF(leftOpen, topOpen, rightOpen, bottomOpen);
                    canvas.drawRoundRect(rectOpen, this.mRadius, this.mRadius, this.paintStroke);
                    for (int i = 1; i < this.mNum; ++i) {
                        canvas.drawCircle(rightClose - this.mRadius + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                    }
                } else {
                    int i;
                    float leftClose = (float)(-this.mNum) * 0.5f * this.mDistance + (float)this.mPosition * this.mDistance - this.mRadius;
                    float rightClose = leftClose + 2.0f * this.mRadius + this.mDistance - this.mOffset;
                    float topClose = -this.mRadius;
                    float bottomClose = this.mRadius;
                    RectF rectClose = new RectF(leftClose, topClose, rightClose, bottomClose);
                    canvas.drawRoundRect(rectClose, this.mRadius, this.mRadius, this.paintStroke);
                    if (this.mPosition < this.mNum - 1) {
                        float rightOpen = (float)(-this.mNum) * 0.5f * this.mDistance + (float)(this.mPosition + 2) * this.mDistance + this.mRadius;
                        float leftOpen = rightOpen - 2.0f * this.mRadius - this.mOffset;
                        float topOpen = -this.mRadius;
                        float bottomOpen = this.mRadius;
                        RectF rectOpen = new RectF(leftOpen, topOpen, rightOpen, bottomOpen);
                        canvas.drawRoundRect(rectOpen, this.mRadius, this.mRadius, this.paintStroke);
                    }
                    for (i = this.mPosition + 3; i <= this.mNum; ++i) {
                        canvas.drawCircle((float)(-this.mNum) * 0.5f * this.mDistance + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                    }
                    for (i = this.mPosition - 1; i >= 0; --i) {
                        canvas.drawCircle((float)(-this.mNum) * 0.5f * this.mDistance + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.mNum; ++i) {
                    canvas.drawCircle((float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                }
                this.drawCubicBezier(canvas);
                break;
            }
            case 4: {
                for (int i = 0; i < this.mNum; ++i) {
                    canvas.drawCircle((float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                }
                this.drawSpringBezier(canvas);
                break;
            }
            case 5: {
                for (int i = 0; i < this.mNum; ++i) {
                    canvas.drawCircle((float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)i * this.mDistance, 0.0f, this.mRadius, this.paintStroke);
                }
                float rightOpen = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + this.mOffset + this.mRadius;
                float leftOpen = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance - this.mRadius;
                float topOpen = -this.mRadius;
                float bottomOpen = this.mRadius;
                RectF rectOpen = new RectF(leftOpen, topOpen, rightOpen, bottomOpen);
                canvas.drawRoundRect(rectOpen, this.mRadius, this.mRadius, this.paintFill);
            }
        }
    }

    private void drawSpringBezier(Canvas canvas) {
        float left_circle_radius;
        float right_circle_radius;
        float left_circle_x;
        float right_circle_x;
        float max_radius = this.mRadius;
        float min_radius = this.mRadius / 2.0f;
        if (this.mPosition == this.mNum - 1 && !this.mIsLeft) {
            if ((double)this.mPercent <= 0.5) {
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(this.mNum - 1) * this.mDistance;
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (0.5f - this.mPercent) / 0.5f * (float)(this.mNum - 1) * this.mDistance;
                right_circle_radius = min_radius + (max_radius - min_radius) * (0.5f - this.mPercent) / 0.5f;
            } else {
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (1.0f - this.mPercent) / 0.5f * (float)(this.mNum - 1) * this.mDistance;
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance;
                right_circle_radius = min_radius;
            }
            left_circle_radius = this.mRadius * this.mPercent;
        } else if (this.mPosition == this.mNum - 1 && this.mIsLeft) {
            if ((double)this.mPercent >= 0.5) {
                left_circle_radius = min_radius + (max_radius - min_radius) * (-0.5f + this.mPercent) / 0.5f;
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance;
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (1.0f - this.mPercent) / 0.5f * (float)(this.mNum - 1) * this.mDistance;
            } else {
                left_circle_radius = min_radius;
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (0.5f - this.mPercent) / 0.5f * (float)(this.mNum - 1) * this.mDistance;
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(this.mNum - 1) * this.mDistance;
            }
            right_circle_radius = this.mRadius * (1.0f - this.mPercent);
        } else if (this.mIsLeft) {
            this.mOffset = (this.mPercent + (float)this.mPosition) * this.mDistance;
            if ((double)this.mPercent >= 0.5) {
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + ((this.mPercent - 0.5f) / 0.5f + (float)this.mPosition) * this.mDistance;
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(1 + this.mPosition) * this.mDistance;
                right_circle_radius = min_radius + (max_radius - min_radius) * (this.mPercent - 0.5f) / 0.5f;
            } else {
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (this.mPercent / 0.5f + (float)this.mPosition) * this.mDistance;
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)this.mPosition * this.mDistance;
                right_circle_radius = min_radius;
            }
            left_circle_radius = this.mRadius * (1.0f - this.mPercent);
        } else {
            this.mOffset = (this.mPercent + (float)this.mPosition) * this.mDistance;
            if ((double)this.mPercent <= 0.5) {
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)this.mPosition * this.mDistance;
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (this.mPercent / 0.5f + (float)this.mPosition) * this.mDistance;
                left_circle_radius = min_radius + (max_radius - min_radius) * (0.5f - this.mPercent) / 0.5f;
            } else {
                left_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + ((this.mPercent - 0.5f) / 0.5f + (float)this.mPosition) * this.mDistance;
                right_circle_x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(this.mPosition + 1) * this.mDistance;
                left_circle_radius = min_radius;
            }
            right_circle_radius = this.mRadius * this.mPercent;
        }
        canvas.drawCircle(right_circle_x, 0.0f, right_circle_radius, this.paintFill);
        canvas.drawCircle(left_circle_x, 0.0f, left_circle_radius, this.paintFill);
        this.mSpringPoint[0].x = left_circle_x;
        this.mSpringPoint[0].y = -left_circle_radius;
        this.mSpringPoint[5].x = this.mSpringPoint[0].x;
        this.mSpringPoint[5].y = left_circle_radius;
        this.mSpringPoint[1].x = (left_circle_x + right_circle_x) / 2.0f;
        this.mSpringPoint[1].y = -left_circle_radius / 2.0f;
        this.mSpringPoint[4].x = this.mSpringPoint[1].x;
        this.mSpringPoint[4].y = left_circle_radius / 2.0f;
        this.mSpringPoint[2].x = right_circle_x;
        this.mSpringPoint[2].y = -right_circle_radius;
        this.mSpringPoint[3].x = this.mSpringPoint[2].x;
        this.mSpringPoint[3].y = right_circle_radius;
        this.mPath.reset();
        this.mPath.moveTo(this.mSpringPoint[0].x, this.mSpringPoint[0].y);
        this.mPath.quadTo(this.mSpringPoint[1].x, this.mSpringPoint[1].y, this.mSpringPoint[2].x, this.mSpringPoint[2].y);
        this.mPath.lineTo(this.mSpringPoint[3].x, this.mSpringPoint[3].y);
        this.mPath.quadTo(this.mSpringPoint[4].x, this.mSpringPoint[4].y, this.mSpringPoint[5].x, this.mSpringPoint[5].y);
        canvas.drawPath(this.mPath, this.paintFill);
    }

    private void drawCubicBezier(Canvas canvas) {
        this.changePoint();
        this.mPath.reset();
        this.mPath.moveTo(this.mControlPoint[0].x, this.mControlPoint[0].y);
        this.mPath.cubicTo(this.mControlPoint[1].x, this.mControlPoint[1].y, this.mControlPoint[2].x, this.mControlPoint[2].y, this.mControlPoint[3].x, this.mControlPoint[3].y);
        this.mPath.cubicTo(this.mControlPoint[4].x, this.mControlPoint[4].y, this.mControlPoint[5].x, this.mControlPoint[5].y, this.mControlPoint[6].x, this.mControlPoint[6].y);
        this.mPath.cubicTo(this.mControlPoint[7].x, this.mControlPoint[7].y, this.mControlPoint[8].x, this.mControlPoint[8].y, this.mControlPoint[9].x, this.mControlPoint[9].y);
        this.mPath.cubicTo(this.mControlPoint[10].x, this.mControlPoint[10].y, this.mControlPoint[11].x, this.mControlPoint[11].y, this.mControlPoint[0].x, this.mControlPoint[0].y);
        canvas.drawPath(this.mPath, this.paintFill);
    }

    private void changePoint() {
        this.mCenterPoint.y = 0.0f;
        float mc = 0.55191505f;
        this.mControlPoint[2].y = this.mRadius;
        this.mControlPoint[8].y = -this.mRadius;
        if (this.mPosition == this.mNum - 1 && !this.mIsLeft) {
            if ((double)this.mPercent <= 0.2) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(this.mNum - 1) * this.mDistance;
            } else if ((double)this.mPercent <= 0.8) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (1.0f - (this.mPercent - 0.2f) / 0.6f) * (float)(this.mNum - 1) * this.mDistance;
            } else if ((double)this.mPercent > 0.8 && this.mPercent < 1.0f) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance;
            } else if (this.mPercent == 1.0f) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance;
            }
            if ((double)this.mPercent > 0.8 && this.mPercent <= 1.0f) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (2.0f - (this.mPercent - 0.8f) / 0.2f);
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius;
            } else if ((double)this.mPercent > 0.5 && (double)this.mPercent <= 0.8) {
                this.mControlPoint[5].x = this.mCenterPoint.x + 2.0f * this.mRadius;
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + (0.8f - this.mPercent) / 0.3f);
                this.mControlPoint[2].y = this.mRadius * (1.0f + (this.mPercent - 0.8f) / 0.3f * 0.1f);
                this.mControlPoint[8].y = -this.mRadius * (1.0f + (this.mPercent - 0.8f) / 0.3f * 0.1f);
                mc *= 1.0f + (-this.mPercent + 0.8f) / 0.3f * 0.3f;
            } else if ((double)this.mPercent > 0.2 && (double)this.mPercent <= 0.5) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f + (this.mPercent - 0.2f) / 0.3f);
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + (this.mPercent - 0.2f) / 0.3f);
                this.mControlPoint[2].y = this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                this.mControlPoint[8].y = -this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                mc *= 1.0f + (this.mPercent - 0.2f) / 0.3f * 0.3f;
            } else if ((double)this.mPercent > 0.1 && (double)this.mPercent <= 0.2) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius;
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f - (0.2f - this.mPercent) / 0.1f * 0.5f);
            } else if (this.mPercent >= 0.0f && (double)this.mPercent <= 0.1) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius;
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f - this.mPercent / 0.1f * 0.5f);
            }
        } else if (this.mPosition == this.mNum - 1 && this.mIsLeft) {
            if ((double)this.mPercent <= 0.2) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(this.mNum - 1) * this.mDistance;
            } else if ((double)this.mPercent <= 0.8) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (1.0f - (this.mPercent - 0.2f) / 0.6f) * (float)(this.mNum - 1) * this.mDistance;
            } else if ((double)this.mPercent > 0.8 && this.mPercent < 1.0f) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance;
            } else if (this.mPercent == 1.0f) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)this.mPosition * this.mDistance;
            }
            if (!(this.mPercent <= 0.0f)) {
                if ((double)this.mPercent <= 0.2 && this.mPercent >= 0.0f) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius;
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + this.mPercent / 0.2f);
                } else if ((double)this.mPercent > 0.2 && (double)this.mPercent <= 0.5) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f + (this.mPercent - 0.2f) / 0.3f);
                    this.mControlPoint[0].x = this.mCenterPoint.x - 2.0f * this.mRadius;
                    this.mControlPoint[2].y = this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                    this.mControlPoint[8].y = -this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                    mc *= 1.0f + (this.mPercent - 0.2f) / 0.3f * 0.3f;
                } else if ((double)this.mPercent > 0.5 && (double)this.mPercent <= 0.8) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f + (0.8f - this.mPercent) / 0.3f);
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + (0.8f - this.mPercent) / 0.3f);
                    this.mControlPoint[2].y = this.mRadius * (1.0f + (this.mPercent - 0.8f) / 0.3f * 0.1f);
                    this.mControlPoint[8].y = -this.mRadius * (1.0f + (this.mPercent - 0.8f) / 0.3f * 0.1f);
                    mc *= 1.0f + (0.8f - this.mPercent) / 0.3f * 0.3f;
                } else if ((double)this.mPercent > 0.8 && (double)this.mPercent <= 0.9) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f - (this.mPercent - 0.8f) / 0.1f * 0.5f);
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius;
                } else if ((double)this.mPercent > 0.9 && this.mPercent <= 1.0f) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f - (this.mPercent - 0.9f) / 0.1f * 0.5f);
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius;
                }
            }
        } else {
            if ((double)this.mPercent <= 0.2) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)this.mPosition * this.mDistance;
            } else if ((double)this.mPercent <= 0.8) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + ((float)this.mPosition + this.mPercent) * this.mDistance;
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + ((float)this.mPosition + (this.mPercent - 0.2f) / 0.6f) * this.mDistance;
            } else if ((double)this.mPercent > 0.8 && this.mPercent < 1.0f) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)(this.mPosition + 1) * this.mDistance;
            } else if (this.mPercent == 1.0f) {
                this.mCenterPoint.x = (float)(-(this.mNum - 1)) * 0.5f * this.mDistance + (float)this.mPosition * this.mDistance;
            }
            if (this.mIsLeft) {
                if (this.mPercent >= 0.0f && (double)this.mPercent <= 0.2) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (2.0f - (0.2f - this.mPercent) / 0.2f);
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius;
                } else if ((double)this.mPercent > 0.2 && (double)this.mPercent <= 0.5) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + 2.0f * this.mRadius;
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + (this.mPercent - 0.2f) / 0.3f);
                    this.mControlPoint[2].y = this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                    this.mControlPoint[8].y = -this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                    mc *= 1.0f + (this.mPercent - 0.2f) / 0.3f * 0.3f;
                } else if ((double)this.mPercent > 0.5 && (double)this.mPercent <= 0.8) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f + (0.8f - this.mPercent) / 0.3f);
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + (0.8f - this.mPercent) / 0.3f);
                    this.mControlPoint[2].y = this.mRadius * (1.0f + (this.mPercent - 0.8f) / 0.3f * 0.1f);
                    this.mControlPoint[8].y = -this.mRadius * (1.0f + (this.mPercent - 0.8f) / 0.3f * 0.1f);
                    mc *= 1.0f + (-this.mPercent + 0.8f) / 0.3f * 0.3f;
                } else if ((double)this.mPercent > 0.8 && (double)this.mPercent <= 0.9) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius;
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f - (this.mPercent - 0.8f) / 0.1f * 0.5f);
                } else if ((double)this.mPercent > 0.9 && this.mPercent <= 1.0f) {
                    this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius;
                    this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f - (1.0f - this.mPercent) / 0.1f * 0.5f);
                }
            } else if (this.mPercent <= 1.0f && (double)this.mPercent >= 0.8) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius;
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (2.0f - (this.mPercent - 0.8f) / 0.2f);
            } else if ((double)this.mPercent > 0.5 && (double)this.mPercent <= 0.8) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (2.0f - (this.mPercent - 0.5f) / 0.3f);
                this.mControlPoint[0].x = this.mCenterPoint.x - 2.0f * this.mRadius;
                this.mControlPoint[2].y = this.mRadius * (1.0f - (0.8f - this.mPercent) / 0.3f * 0.1f);
                this.mControlPoint[8].y = -this.mRadius * (1.0f - (0.8f - this.mPercent) / 0.3f * 0.1f);
                mc *= 1.0f + (0.8f - this.mPercent) / 0.3f * 0.3f;
            } else if ((double)this.mPercent > 0.2 && (double)this.mPercent <= 0.5) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f + (this.mPercent - 0.2f) / 0.3f);
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius * (1.0f + (this.mPercent - 0.2f) / 0.3f);
                this.mControlPoint[2].y = this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                this.mControlPoint[8].y = -this.mRadius * (1.0f - (this.mPercent - 0.2f) / 0.3f * 0.1f);
                mc *= 1.0f + (this.mPercent - 0.2f) / 0.3f * 0.3f;
            } else if ((double)this.mPercent > 0.1 && (double)this.mPercent <= 0.2) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f - (0.2f - this.mPercent) / 0.1f * 0.5f);
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius;
            } else if (this.mPercent >= 0.0f && (double)this.mPercent <= 0.1) {
                this.mControlPoint[5].x = this.mCenterPoint.x + this.mRadius * (1.0f - this.mPercent / 0.1f * 0.5f);
                this.mControlPoint[0].x = this.mCenterPoint.x - this.mRadius;
            }
        }
        this.mControlPoint[0].y = 0.0f;
        this.mControlPoint[1].x = this.mControlPoint[0].x;
        this.mControlPoint[1].y = this.mRadius * mc;
        this.mControlPoint[11].x = this.mControlPoint[0].x;
        this.mControlPoint[11].y = -this.mRadius * mc;
        this.mControlPoint[2].x = this.mCenterPoint.x - this.mRadius * mc;
        this.mControlPoint[3].x = this.mCenterPoint.x;
        this.mControlPoint[3].y = this.mControlPoint[2].y;
        this.mControlPoint[4].x = this.mCenterPoint.x + this.mRadius * mc;
        this.mControlPoint[4].y = this.mControlPoint[2].y;
        this.mControlPoint[5].y = this.mRadius * mc;
        this.mControlPoint[6].x = this.mControlPoint[5].x;
        this.mControlPoint[6].y = 0.0f;
        this.mControlPoint[7].x = this.mControlPoint[5].x;
        this.mControlPoint[7].y = -this.mRadius * mc;
        this.mControlPoint[8].x = this.mCenterPoint.x + this.mRadius * mc;
        this.mControlPoint[9].x = this.mCenterPoint.x;
        this.mControlPoint[9].y = this.mControlPoint[8].y;
        this.mControlPoint[10].x = this.mCenterPoint.x - this.mRadius * mc;
        this.mControlPoint[10].y = this.mControlPoint[8].y;
    }

    public void move(float percent, int position, boolean isLeft) {
        this.mPosition = position;
        this.mPercent = percent;
        this.mIsLeft = isLeft;
        switch (this.mIndicatorType) {
            case 2: {
                if (this.mPosition == this.mNum - 1 && !isLeft) {
                    this.mOffset = percent * this.mDistance;
                }
                if (this.mPosition == this.mNum - 1 && isLeft) {
                    this.mOffset = percent * this.mDistance;
                    break;
                }
                this.mOffset = percent * this.mDistance;
                break;
            }
            case 0: 
            case 1: 
            case 5: {
                if (this.mPosition == this.mNum - 1 && !isLeft) {
                    this.mOffset = (1.0f - percent) * (float)(this.mNum - 1) * this.mDistance;
                    break;
                }
                if (this.mPosition == this.mNum - 1 && isLeft) {
                    this.mOffset = (1.0f - percent) * (float)(this.mNum - 1) * this.mDistance;
                    break;
                }
                this.mOffset = (percent + (float)this.mPosition) * this.mDistance;
                break;
            }
            case 3: {
                break;
            }
        }
        this.invalidate();
    }

    public ViewPagerIndicator setNum(int num) {
        this.mNum = num;
        this.invalidate();
        return this;
    }

    public ViewPagerIndicator setType(int indicatorType) {
        this.mIndicatorType = indicatorType;
        this.invalidate();
        return this;
    }

    public ViewPagerIndicator setRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
        return this;
    }

    public ViewPagerIndicator setDistance(float distance) {
        this.mDistance = distance;
        this.invalidate();
        return this;
    }

    public ViewPagerIndicator setDistanceType(int mDistanceType) {
        this.mDistanceType = mDistanceType;
        this.invalidate();
        return this;
    }

    public ViewPagerIndicator setViewPager(ViewPager viewPager) {
        this.setViewPager(viewPager, viewPager.getAdapter().getCount(), false);
        return this;
    }

    public ViewPagerIndicator setViewPager(ViewPager viewpager, int CycleNumber) {
        this.setViewPager(viewpager, CycleNumber, false);
        return this;
    }

    public ViewPagerIndicator setViewPager(ViewPager viewPager, boolean isInfiniteCircle) {
        if (isInfiniteCircle) {
            this.setViewPager(viewPager, viewPager.getAdapter().getCount() - 2, isInfiniteCircle);
        } else {
            this.setViewPager(viewPager, viewPager.getAdapter().getCount(), isInfiniteCircle);
        }
        return this;
    }

    public ViewPagerIndicator setViewPager(ViewPager viewpager, int CycleNumber, boolean isInfiniteCircle) {
        this.mNum = CycleNumber;
        this.mIsInfiniteCircle = isInfiniteCircle;
        viewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){
            private int lastValue = -1;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (!ViewPagerIndicator.this.mAnimation) {
                    return;
                }
                boolean isLeft = ViewPagerIndicator.this.mIsLeft;
                if (this.lastValue / 10 > positionOffsetPixels / 10) {
                    isLeft = false;
                } else if (this.lastValue / 10 < positionOffsetPixels / 10) {
                    isLeft = true;
                }
                if (ViewPagerIndicator.this.mNum > 0 && !ViewPagerIndicator.this.mIsInfiniteCircle) {
                    ViewPagerIndicator.this.move(positionOffset, position % ViewPagerIndicator.this.mNum, isLeft);
                } else if (ViewPagerIndicator.this.mNum > 0 && ViewPagerIndicator.this.mIsInfiniteCircle) {
                    position = position == 0 ? ViewPagerIndicator.this.mNum - 1 : (position == ViewPagerIndicator.this.mNum + 1 ? 0 : --position);
                    ViewPagerIndicator.this.move(positionOffset, position, isLeft);
                }
                this.lastValue = positionOffsetPixels;
            }

            public void onPageSelected(int position) {
                if (ViewPagerIndicator.this.mAnimation) {
                    return;
                }
                if (ViewPagerIndicator.this.mNum > 0 && !ViewPagerIndicator.this.mIsInfiniteCircle) {
                    ViewPagerIndicator.this.move(0.0f, position % ViewPagerIndicator.this.mNum, false);
                } else if (ViewPagerIndicator.this.mNum > 0 && ViewPagerIndicator.this.mIsInfiniteCircle) {
                    position = position == 0 ? ViewPagerIndicator.this.mNum - 1 : (position == ViewPagerIndicator.this.mNum + 1 ? 0 : --position);
                    ViewPagerIndicator.this.move(0.0f, position, false);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        return this;
    }

    public static interface DistanceType {
        public static final int BY_RADIUS = 0;
        public static final int BY_DISTANCE = 1;
        public static final int BY_LAYOUT = 2;
    }

    public static interface IndicatorType {
        public static final int LINE = 0;
        public static final int CIRCLE = 1;
        public static final int CIRCLE_LINE = 2;
        public static final int BEZIER = 3;
        public static final int SPRING = 4;
        public static final int PROGRESS = 5;
    }

    class Point {
        float x;
        float y;

        Point() {
        }
    }

    class CenterPoint {
        float x;
        float y;

        CenterPoint() {
        }
    }
}

