/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.adapter;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zhengsr.tablib.view.adapter.BaseFlowAdapter;
import java.util.List;

public abstract class TemplateAdapter<T>
extends BaseFlowAdapter<T> {
    public TemplateAdapter(int layoutId, List data) {
        super(layoutId, data);
    }

    public BaseFlowAdapter addChildrenClick(View view, int viewId, final int position) {
        final View child = view.findViewById(viewId);
        if (child != null) {
            child.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TemplateAdapter.this.onItemChildClick(child, position);
                }
            });
        }
        return this;
    }

    public BaseFlowAdapter addChildrenLongClick(View view, int viewId, final int position) {
        final View child = view.findViewById(viewId);
        if (child != null) {
            child.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return TemplateAdapter.this.onItemChildLongClick(child, position);
                }
            });
        }
        return this;
    }

    public TemplateAdapter setText(View view, int viewId, int resId) {
        TextView textView = (TextView)view.findViewById(viewId);
        if (textView != null) {
            textView.setText(resId);
        }
        return this;
    }

    public TemplateAdapter setText(View view, int viewId, String msg) {
        TextView textView = (TextView)view.findViewById(viewId);
        if (textView != null) {
            textView.setText((CharSequence)msg);
        }
        return this;
    }

    public TemplateAdapter setTextColor(View view, int viewId, int textColor) {
        TextView textView = (TextView)view.findViewById(viewId);
        if (textView != null) {
            textView.setTextColor(textColor);
        }
        return this;
    }

    public TemplateAdapter setImageView(View view, int viewId, int res) {
        ImageView imageView = (ImageView)view.findViewById(viewId);
        if (imageView != null) {
            imageView.setImageResource(res);
        }
        return this;
    }

    public TemplateAdapter setImageView(View view, int viewId, Bitmap bitmap) {
        ImageView imageView = (ImageView)view.findViewById(viewId);
        if (imageView != null) {
            imageView.setImageBitmap(bitmap);
        }
        return this;
    }

    public TemplateAdapter setVisible(View view, int viewId, boolean isVisible) {
        View childView = view.findViewById(viewId);
        if (childView != null) {
            childView.setVisibility(isVisible ? 0 : 8);
        }
        return this;
    }

    public TemplateAdapter setVisible(View view, int viewId, int visible) {
        View childView = view.findViewById(viewId);
        if (childView != null) {
            childView.setVisibility(visible);
        }
        return this;
    }
}

