/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JInternalFrame;

public class Normalize
extends AbstractTool {
    FileArgument destfile = null;
    int pagecount;
    float width;
    float height;
    PdfDictionary lastpage = null;
    float tolerancex = 60.0f;
    float tolerancey = 60.0f;
    int pagecountinsertedpages;
    int pagecountrotatedpages;

    public Normalize() {
        this.menuoptions = 3;
        FileArgument inputfile = new FileArgument(this, "srcfile", "The file you want to normalize", false, new PdfFilter());
        this.arguments.add(inputfile);
        this.destfile = new FileArgument(this, "destfile", "The resulting PDF", true, new PdfFilter());
        this.arguments.add(this.destfile);
        inputfile.addPropertyChangeListener(this.destfile);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Normalize", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Normalize OPENED ===");
    }

    protected void iteratePages(PdfDictionary page, PdfReader pdfreader, ArrayList<PdfDictionary> pageInh, int count_in_leaf, PdfWriter writer) throws IOException {
        PdfArray kidsPR = page.getAsArray(PdfName.KIDS);
        if (kidsPR == null) {
            PdfArray arr = page.getAsArray(PdfName.MEDIABOX);
            float curwidth = Float.parseFloat(arr.getPdfObject(2).toString());
            float curheight = Float.parseFloat(arr.getPdfObject(3).toString());
            PdfNumber rotation = page.getAsNumber(PdfName.ROTATE);
            if (rotation == null) {
                System.out.println("optional rotation missing");
                rotation = new PdfNumber(0);
            }
            Ausrichtung ausr = new Ausrichtung(rotation.floatValue(), new Rectangle(curwidth, curheight));
            switch (ausr.type) {
                case 2: 
                case 3: {
                    ausr.rotate();
                    page.put(PdfName.ROTATE, (PdfObject)new PdfNumber(ausr.getRotation()));
                    System.out.println("rotate page:" + (this.pagecount + 1) + " targetformat: " + ausr);
                    ++this.pagecountrotatedpages;
                }
            }
            curwidth = ausr.getM5();
            curheight = ausr.getM6();
            if ((this.pagecount + 1) % 2 == 0 && (Math.abs(curwidth - this.width) > this.tolerancex || Math.abs(curheight - this.height) > this.tolerancey)) {
                this.Seitehinzufuegen(page, count_in_leaf, writer, arr);
                ++this.pagecountinsertedpages;
            }
            if ((this.pagecount + 1) % 2 == 1) {
                this.width = curwidth;
                this.height = curheight;
                this.lastpage = page;
            }
            pageInh.add(this.pagecount, page);
            ++this.pagecount;
        } else {
            page.put(PdfName.TYPE, (PdfObject)PdfName.PAGES);
            for (int k = 0; k < kidsPR.size(); ++k) {
                PdfDictionary kid = kidsPR.getAsDict(k);
                this.iteratePages(kid, pdfreader, pageInh, k, writer);
            }
        }
    }

    private void Seitehinzufuegen(PdfDictionary page, int count_in_leaf, PdfWriter writer, PdfArray array) throws IOException {
        PdfDictionary parent;
        System.out.print("change!");
        PdfArray kids = parent.getAsArray(PdfName.KIDS);
        PdfIndirectReference ref = writer.getPdfIndirectReference();
        kids.add(count_in_leaf, (PdfObject)ref);
        PdfDictionary newPage = new PdfDictionary(PdfName.PAGE);
        newPage.merge(this.lastpage);
        newPage.remove(PdfName.CONTENTS);
        newPage.remove(PdfName.ANNOTS);
        newPage.put(PdfName.RESOURCES, (PdfObject)new PdfDictionary());
        writer.addToBody((PdfObject)newPage, ref);
        PdfNumber count = null;
        for (parent = page.getAsDict(PdfName.PARENT); parent != null; parent = parent.getAsDict(PdfName.PARENT)) {
            count = parent.getAsNumber(PdfName.COUNT);
            parent.put(PdfName.COUNT, (PdfObject)new PdfNumber(count.intValue() + 1));
        }
        System.out.println("page:" + (this.pagecount + 1) + " nr in leaf:" + count_in_leaf + " arl x:" + array.getPdfObject(0) + " y:" + array.getPdfObject(1) + " width:" + array.getPdfObject(2) + " height:" + array.getPdfObject(3));
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File dest = (File)this.getValue("destfile");
            this.pagecountinsertedpages = 0;
            this.pagecountrotatedpages = 0;
            this.pagecount = 0;
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            PdfStamper stp = new PdfStamper(reader, (OutputStream)new FileOutputStream(dest));
            PdfWriter writer = stp.getWriter();
            ArrayList<PdfDictionary> pageInh = new ArrayList<PdfDictionary>();
            PdfDictionary catalog = reader.getCatalog();
            PdfDictionary rootPages = catalog.getAsDict(PdfName.PAGES);
            this.iteratePages(rootPages, reader, pageInh, 0, writer);
            if (this.pagecount % 2 == 1) {
                this.appendemptypageatend(reader, writer);
                ++this.pagecountinsertedpages;
            }
            stp.close();
            System.out.println("In " + dest.getAbsolutePath() + " pages= " + this.pagecount + " inserted pages=" + this.getPagecountinsertedpages() + " rotated pages=" + this.getPagecountrotatedpages());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void appendemptypageatend(PdfReader reader, PdfWriter writer) throws IOException {
        PdfDictionary parent;
        System.out.println("last page odd. add page!");
        PdfDictionary page = reader.getPageN(reader.getNumberOfPages());
        PdfArray kids = parent.getAsArray(PdfName.KIDS);
        PdfIndirectReference ref = writer.getPdfIndirectReference();
        kids.add((PdfObject)ref);
        PdfDictionary newPage = new PdfDictionary(PdfName.PAGE);
        newPage.merge(this.lastpage);
        newPage.remove(PdfName.CONTENTS);
        newPage.remove(PdfName.ANNOTS);
        newPage.put(PdfName.RESOURCES, (PdfObject)new PdfDictionary());
        writer.addToBody((PdfObject)newPage, ref);
        PdfNumber count = null;
        for (parent = page.getAsDict(PdfName.PARENT); parent != null; parent = parent.getAsDict(PdfName.PARENT)) {
            count = parent.getAsNumber(PdfName.COUNT);
            parent.put(PdfName.COUNT, (PdfObject)new PdfNumber(count.intValue() + 1));
        }
    }

    public int getPagecountinsertedpages() {
        return this.pagecountinsertedpages;
    }

    public int getPagecountrotatedpages() {
        return this.pagecountrotatedpages;
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && arg.getName().equalsIgnoreCase("srcfile")) {
            String filename = arg.getValue().toString();
            String filenameout = filename.substring(0, filename.indexOf(".", filename.length() - 4)) + "_out.pdf";
            this.destfile.setValue(filenameout);
        }
    }

    public static void main(String[] args) {
        Normalize tool = new Normalize();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Normalize.addVersion("$Id: Normalize.java 3736 2009-02-26 08:52:21Z xlv $");
    }

    public class Ausrichtung {
        static final float tolerance = 60.0f;
        static final int UNKNOWN = 0;
        static final int A4Portrait = 1;
        static final int A4Landscape = 2;
        static final int A3Portrait = 3;
        static final int A3Landscape = 4;
        float rotation;
        Rectangle rect;
        float m5;
        float m6;
        int type;

        public Ausrichtung() {
            this(0.0f, new Rectangle(1.0f, 1.0f));
        }

        public Ausrichtung(float rotation, Rectangle unrotatedoriginalrect) {
            this.rotation = rotation;
            this.rect = rotation == 90.0f || rotation == 270.0f ? unrotatedoriginalrect.rotate() : unrotatedoriginalrect;
            this.m5 = this.rect.getWidth();
            this.m6 = this.rect.getHeight();
            this.klassifiziere();
        }

        private void klassifiziere() {
            this.type = Math.abs(this.rect.getWidth() - 595.0f) < 60.0f && Math.abs(this.rect.getHeight() - 842.0f) < 60.0f ? 1 : (Math.abs(this.rect.getWidth() - 842.0f) < 60.0f && Math.abs(this.rect.getHeight() - 595.0f) < 60.0f ? 2 : (Math.abs(this.rect.getWidth() - 1190.0f) < 60.0f && Math.abs(this.rect.getHeight() - 842.0f) < 60.0f ? 4 : (Math.abs(this.rect.getWidth() - 842.0f) < 60.0f && Math.abs(this.rect.getHeight() - 1190.0f) < 60.0f ? 3 : 0)));
        }

        public float getM5() {
            return this.m5;
        }

        public float getM6() {
            return this.m6;
        }

        public String toString() {
            String back;
            switch (this.type) {
                case 0: {
                    back = this.rect.getWidth() + "*" + this.rect.getHeight();
                    break;
                }
                case 4: {
                    back = "A3 Landscape";
                    break;
                }
                case 3: {
                    back = "A3 Portrait";
                    break;
                }
                case 2: {
                    back = "A4 Landscape";
                    break;
                }
                case 1: {
                    back = "A4 Portrait";
                    break;
                }
                default: {
                    back = "";
                }
            }
            return back;
        }

        public void rotate() {
            this.rect = this.rect.rotate();
            this.m5 = this.rect.getWidth();
            this.m6 = this.rect.getHeight();
            this.rotation += 90.0f;
            this.rotation %= 360.0f;
            this.klassifiziere();
        }

        public float getRotation() {
            return this.rotation;
        }
    }
}

