/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.PluginHook;
import java.util.Iterator;
import java.util.UUID;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import net.citizensnpcs.api.ai.speech.event.SpeechEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class CitizensHook
extends PluginHook {
    public CitizensHook(SuperVanish superVanish) {
        super(superVanish);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onNPCTarget(NPCSpeechEvent e) {
        e.setCancelled(!this.checkContext(e.getContext()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpeechTargeted(SpeechEvent e) {
        e.setCancelled(!this.checkContext(e.getContext()));
    }

    private boolean checkContext(SpeechContext context) {
        for (UUID uuid : this.superVanish.getVanishStateMgr().getOnlineVanishedPlayers()) {
            if (!context.getMessage().contains(Bukkit.getPlayer((UUID)uuid).getName())) continue;
            return false;
        }
        Iterator iterator = context.iterator();
        while (iterator.hasNext()) {
            Talkable recipient = (Talkable)iterator.next();
            Entity entity = recipient.getEntity();
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (!this.superVanish.getVanishStateMgr().isVanished(player.getUniqueId())) continue;
            iterator.remove();
        }
        return context.hasRecipients();
    }
}

